<?php
/**
* Filename.......: email.list.normal.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/04 12:11:22 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* This function is array_diff except that with
* 4.04 it uses it's own implementation.
*/
	function vwebmail_array_diff()
	{
		$version = explode('.', phpversion());
		$version = (int)($version[0] . $version[1] . $version[2]);

		$args = func_get_args();
		if (count($args) < 2) {
			return array();
		}

		// PHP 4.0.4pl1
		if ($version == 404) {
			$first_arg = array_shift($args);
			foreach ($first_arg as $key => $value) {
				foreach ($args as $arg) {
					if (in_array($value, $arg)) {
						unset($first_arg[$key]);
					}
				}
			}
			return array_values($first_arg);

		// PHP 4.0.5+
		} else {
			return array_values(call_user_func_array('array_diff', $args));
		}
	}

/**
* Function which applies the blacklists to the INBOX
*/
	function applyBlacklists()
	{
		global $USERPREFS, $mailaccess;

		$msgIDs = array();

		// Search term relations
		$searchTerms = array('senders' => 'FROM', 'recipients' => 'TO', 'bodies' => 'BODY', 'subjects' => 'SUBJECT');

		// Run thru blacklists adding found msg ids to $msgIDs
		foreach (array('senders', 'recipients', 'bodies', 'subjects') as $blacklist) {
			if (!empty($USERPREFS['blacklists'][$blacklist])) {
				foreach ($USERPREFS['blacklists'][$blacklist] as $value) {
					$msgIDs = array_merge($msgIDs, $mailaccess->getMsgIds('normal', 1, 1, 0, sprintf('%s "%s"', $searchTerms[$blacklist], $value), $numMsgs));
				}
			}
		}

		// Now either delete or move the messages based on the defined setting
		runBlacklistsAction($msgIDs);
	}

/**
 * Function which applies the blacklists action to the given messages.
 *
 * @param variant msgIDs Array of message ids
 */
	function runBlacklistsAction($msgIDs = array())
	{
		global $USERPREFS, $mailaccess, $summaryMsg;

		if (!is_array($msgIDs)) {
			$msgIDs = array($msgIDs);
		}

		// Now either delete or move the messages based on the defined setting
		if (!empty($msgIDs)) {
			$mailaccess->setFlag(implode(',', $msgIDs), 'read');
			if (@$USERPREFS['blacklists']['action'] == 'delete') {
				$mailaccess->delete(implode(',', $msgIDs), $errorMsg);
				$summaryMsg[] = count($msgIDs) . lang(' message(s) were deleted due to blacklists');
			} else {
				$mailaccess->moveMsg(implode(',', $msgIDs), $USERPREFS['blacklists']['move_folder']);
				$summaryMsg[] = count($msgIDs) . lang(' message(s) were moved due to blacklists');
			}
		}
	}

/**
* Normal list routine for mailbox
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		/**
        * Get list of subscribed folders
        */
		if ($mailaccess->capabilities('folders')) {
		
			$mailaccess->checkKeyFolders();

			list($folders, $folderTree) = $mailaccess->getSubscribedFolders();

			// FIXME Check for whether current folder is subscribed folder?
			for ($i=0; $i<count($folders); $i++) {
				// Remove name from unselectable mailboxes
				if ($folders[$i]['noselect'] == TRUE) {
					$folders[$i]['name'] = '';
				}
				//Make current mbox selected
				if (@!$tpl_is_search) {
					$folders[$i]['selected'] = ($folders[$i]['name'] == $SESSION['email']['mbox'] ? 'selected="selected"' : '');
				}
			}
			
			if (@$tpl_is_search) {
				array_unshift($folders, array('name' => '', 'noselect' => '', 'name_htmlsafe' => '', 'name_urlsafe' => '', 'text' => ''));
			}
		}

		/**
        * Need initing...
        */
		$summary    = array();
		$summaryMsg = array();
		$msg_id     = (@$_GET['msg_id'] > 0) ? $_GET['msg_id'] : false;

		/**
        * Blacklists
        */
		if (    $mailaccess->capabilities('folders')
		    AND strcasecmp($SESSION['email']['mbox'], 'INBOX') == 0
			AND @$USERPREFS['blacklists']['apply'] == 'always'
			AND @$HOSTINFO['allow_blacklists']) {

			// Apply to given message only?
			if ($msg_id) {
				runBlacklistsAction($msg_id);
			} else {
				applyBlacklists();
			}
		}

		/**
        * Rules
        */
		if (    $mailaccess->capabilities('folders')
		   AND strcasecmp($SESSION['email']['mbox'], 'INBOX') == 0
		   AND !empty($USERPREFS['rules'])
		   AND (@$USERPREFS['settings']['apply_rules_always']
				OR (@$USERPREFS['settings']['apply_rules_login'] AND @$SESSION['login']['first_view']) OR !empty($_GET['filter'])) ) {

			if (isset($SESSION['login']['first_view'])) {
				unset($SESSION['login']['first_view']);
			}

			$do_rules = true;

			// Check first if we only apply to unread messages. If so check if there
			// any unread messages. If not, there's no point applying rules.
			if (@$USERPREFS['settings']['rules_only_unseen']) {
				$mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, 'UNSEEN', $num_msgs);
				$do_rules = ($num_msgs == 0) ? false : true;
				$search_prepend[] = 'UNSEEN';
			}

			// Check if we only apply to UNSEEN messages. If so check if there
			// any unread messages. If not, there's no point applying rules.
			if ($do_rules AND @$USERPREFS['settings']['rules_only_recent']) {
				$mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, 'RECENT', $num_msgs);
				$do_rules = ($num_msgs == 0) ? false : true;
				$search_prepend[] = 'RECENT';
			}

			$search_prepend = !empty($search_prepend) ? implode(' ', $search_prepend) . ' ' : '';

			// To rule, or not to rule....?
			if ($do_rules) {

				/**
                * Apply blacklists first (only if the apply setting is "when rules are applied")
                */
				if (@$HOSTINFO['allow_blacklists'] AND @$USERPREFS['blacklists']['apply'] == 'withrules') {

					// Apply to given message only?
					if ($msg_id) {
						runBlacklistsAction($msg_id);
					} else {
						applyBlacklists();
					}
				}

				// Loop thru all the rules
				foreach (@$USERPREFS['rules'] as $rule) {
					$search_string = array();
					$criteria      = array();

					// Generate search string
					if (!empty($rule['from']))    $criteria[] = 'from';
					if (!empty($rule['to']))      $criteria[] = 'to';
					if (!empty($rule['cc']))      $criteria[] = 'cc';
					if (!empty($rule['subject'])) $criteria[] = 'subject';
					if (!empty($rule['body']))    $criteria[] = 'body';

					/**
                    * Search criteria are ORed
                    */
					if(@$rule['match'] == 'any') {
						$msg_ids  = array();
						$num_msgs = 0;
						foreach ($criteria as $crit) {
							$search_string = strtr($rule[$crit], array('"' => '\"', '\\' => '\\\\'));
							$search_string = strtoupper($crit) . ' "' . $search_string . '"';
							$msg_ids   = array_merge($msg_ids, $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, $search_prepend . $search_string, $search_num_msgs));
							$num_msgs += $search_num_msgs;
						}

					/**
                    * Search criteria are ANDed
                    */
					} else {
						for ($i=0; $i<count(@$criteria); $i++) {
							$string = strtr($rule[$criteria[$i]], array('"' => '\"', '\\' => '\\\\'));
							$search_string[] = strtoupper($criteria[$i]) . ' "' . $string . '"';
						}
						$search_string = implode(' ', $search_string);
						$msg_ids = $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, $search_prepend . $search_string, $num_msgs);
					}

					/**
                    * Invert selection?
                    */
					if (@$rule['invert']) {
						$allMsgIds = $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, 'ALL', $num_all_msgs);
						$msg_ids   = vwebmail_array_diff($allMsgIds, $msg_ids); // Defined at top of this file
						$num_msgs  = count($msg_ids);
					}

					// Perform the actions
					if ($num_msgs > 0) {
						for ($i=0; $i<count($rule['actions']); $i++) {
							switch (substr($rule['actions'][$i], 0, 4)) {
								case 'move':
								case 'copy':
									$action   = substr($rule['actions'][$i], 0, 4);
									$function = ($action == 'copy' ? 'copyMsg' : 'moveMsg');

									$folder = substr($rule['actions'][$i], strpos($rule['actions'][$i], ':') + 1);
									if (!$mailaccess->folderExists($folder)) {
										if ($mailaccess->isValidMailbox($folder)) {
											$mailaccess->createFolder($folder);
											$mailaccess->subscribeFolder($folder);
										} else {
											break;
										}
									}

									if (strcasecmp($folder, 'INBOX') != 0) {
										if (eval('return $mailaccess->' . $function . '(implode(",", $msg_ids), $folder);')) {
											@$summary[$action][$folder] += count($msg_ids);
										}
									}
									break;

								case 'mark':
									$mailaccess->setflag(implode(',', $msg_ids), 'read');
									@$summary['mark'] += count($msg_ids);
									break;

								case 'flag':
									$mailaccess->setflag(implode(',', $msg_ids), 'flagged');
									@$summary['flag'] += count($msg_ids);
									break;

								case 'dele':
									$mailaccess->delete(implode(',', $msg_ids), $message);
									@$summary['dele'] += count($msg_ids);
									break;

								default:
									// LOG
							}
						}
					}
				}
			} // End if($do_rules)
		}

		/**
        * Create the summary message of what happened
		* This can be sourced from either rules or blacklist
		* results
        */
		if (!empty($summary) OR !empty($summaryMsg)) {
			foreach ($summary as $action => $value) {
				switch ($action) {
					case 'move':
					case 'copy':
						foreach ($value as $folder => $count) {
							$text = ($action == 'move' ? lang('message(s) were moved to') : lang('message(s) were copied to'));
							$summaryMsg[] = sprintf('%s %s %s', $count, $text, $folder);
						}
						break;

					case 'mark':
						$summaryMsg[] = $value . ' ' . lang('message(s) were marked as read');
						break;

					case 'flag':
						$summaryMsg[] = $value . ' ' . lang('message(s) were flagged');
						break;

					case 'dele':
						$summaryMsg[] = $value . ' ' . lang('message(s) were deleted');
						break;
				}
			}
			
			$error_msg = implode(',<br /> ', $summaryMsg);
		}
		
		if (!empty($_GET['filter'])) {
			common::redirect('redirect.php?to=email.list.php', isset($error_msg) ? $error_msg : null);
		}

		/**
        * Continue with showing the list
        */
		$_msg_ids = $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, !empty($SESSION['search']['string']) ? $SESSION['search']['string'] : 'ALL', $num_msgs);

		/**
		* Make sure the start point is valid.
		*/
		if (!isset($start_msg))     $start_msg = 1;
		if ($start_msg > $num_msgs) $start_msg = $num_msgs - $show_per_page + 1;
		if ($start_msg < 1)         $start_msg = 1;

		$msg_ids  = array_slice($_msg_ids, $start_msg - 1, $show_per_page);

		if ($num_msgs > 0) {

			$SESSION['email']['message_ids'] = array();
			for ($i=0; $i<count($_msg_ids); $i++) {
				$SESSION['email']['message_ids'][] = array('mailbox' => $SESSION['email']['mbox'], 'msg_id' => $_msg_ids[$i]);
			}

			/**
			* Populate the mail_list array. Store the $msg_ids
			* in the session so that email.view.message.php
			* can garner the next and back msg ids.
			*/
			// Default for older versions
			$unread_mail = isset($USERPREFS['settings']['unread_mail']) ? $USERPREFS['settings']['unread_mail'] : 'bold';

			for ($i=0; $i<count($msg_ids); $i++) {
				$mail_list[$i] = $mailaccess->getMsgSummary($msg_ids[$i]);
				$mail_list[$i]['bold']      = ($mail_list[$i]['unread'] AND strpos($unread_mail, 'bold')   !== FALSE) ? 'bold' : 'normal';
				$mail_list[$i]['style']     = ($mail_list[$i]['unread'] AND strpos($unread_mail, 'italic') !== FALSE) ? 'italic' : 'normal';
				$mail_list[$i]['js_msg_id'] = md5($msg_ids[$i] . $SESSION['email']['mbox']);
				$mail_list[$i]['mbox']      = $SESSION['email']['mbox'];
				$mail_list[$i]['mbox_url']  = urlencode($SESSION['email']['mbox']);

				// Build the link for the listing page
				if (!empty($mail_list[$i]['draft'])) {
					$mail_list[$i]['link'] = sprintf('email.reply.redirect.php?%s&action=opendraft&msg_id=%s&mbox=%s',
					                                 VWEBMAILSESSION,
					                                 $mail_list[$i]['msg_id'],
													 $mail_list[$i]['mbox_url']);
				} else {
					$mail_list[$i]['link'] = sprintf('email.view.message.php?%s&msg_id=%s&mbox=%s',
					                                 VWEBMAILSESSION,
													 $mail_list[$i]['msg_id'],
													 $mail_list[$i]['mbox_url']);
				}

				/**
	            * If we're in the sent items folder, 
				* replace the email/name entries with
				* to_email and to_name.
	            */
				if ('inbox' != strtolower($SESSION['email']['mbox']) && $SESSION['email']['mbox'] == @$USERPREFS['settings']['sent_items_folder']) {
					$mail_list[$i]['email']         = $mail_list[$i]['to_email'];
					$mail_list[$i]['name']          = $mail_list[$i]['to_name'];
					$mail_list[$i]['email_urlsafe'] = $mail_list[$i]['to_urlsafe'];
				}
			}

			
			/**
            * Since we now use a subloop, the mail_list
			* becomes the subloop data with outside
			* data of nothing (outside data used for
			* headings in multiple folder search).
            */
			$from_header = 'inbox' != strtolower($SESSION['email']['mbox']) && $SESSION['email']['mbox'] == @$USERPREFS['settings']['sent_items_folder'] ? lang('To') : lang('From');
			$mboxname    = preg_replace('/^' . preg_quote($SESSION['email']['fold'], '/') . '/', '', $SESSION['email']['mbox']);
			$mail_list   = array(array('select_all_gif' => TRUE, 'mailbox_title' => htmlspecialchars($mboxname), 'spacer' => '', 'spacer' => '', 'from_header' => $from_header, 'msgs' =>$mail_list));


		/**
		* No message
		*/
		} else {
			$message     = lang('No messages!');
			$from_header = 'inbox' != strtolower($SESSION['email']['mbox']) && $SESSION['email']['mbox'] == @$USERPREFS['settings']['sent_items_folder'] ? lang('To') : lang('From');
			$mboxname    = preg_replace('/^' . preg_quote($SESSION['email']['fold'], '/') . '/', '', $SESSION['email']['mbox']);
			$mail_list   = array(array('select_all_gif' => TRUE, 'mailbox_title' => htmlspecialchars($mboxname), 'spacer' => '', 'from_header' => $from_header, 'msgs' => array()));
		}

		$SESSION['email']['num_msgs'] = $num_msgs;

		/**
        * Show rules link if we're in the inbox
        */
		if (strcasecmp($SESSION['email']['mbox'], 'INBOX') == 0 AND substr($SESSION['email']['type'], 0, 4) == 'imap') {
			$tpl_show_rules_link = true;
		}

	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}
?>