<?php
/**
* Filename.......: config.checks.inc
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/05 00:38:03 $
* CVS Revision...: $Revision: 1.7 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* Are short tags enabled?
*/
	$short_tags_error = (strtolower(ini_get('short_open_tag')) == 'off' OR !ini_get('short_open_tag'));

/**
* file_uploads enabled ?
*/
	$file_uploads_error = (strtolower(ini_get('file_uploads')) == 'off' OR !ini_get('file_uploads'));

/**
 * Config succesfully parsed?
 */

	$config_error = $config->isError();

/**
 * local.config.xml writable?
 * Test only if file exists.
 */
	if (file_exists($CONFIG['conf_dir'] . 'local.config.xml')) {
		$config_warning = is_writable($CONFIG['conf_dir'] . 'local.config.xml');
	} else {
		$config_warning = null;
	}

/**
* Directories
*/
	$logdir_error  = !is_writeable($CONFIG['log_dir']);
	$tmpdir_error  = !is_writeable($CONFIG['tmp_dir']);
	$datadir_error = !is_writeable($CONFIG['data_dir']);

/**
* Version
*/
	preg_match('/([3-6])\.([0-9])\.([0-9])/', phpversion(), $matches);
	$version = (int)($matches[1] . $matches[2] . $matches[3]);
	
	$version_error = ( $version < 410);

/**
* imap extension
*/
	$imap_error = !extension_loaded('imap');

/**
* Did we fail... or not...
*/
	if ($config_error OR $version_error OR $imap_error OR $logdir_error OR $tmpdir_error OR $datadir_error OR $short_tags_error OR $file_uploads_error OR $config_warning) {

		$config_error_font = $config_error ? '#ff0000' : '#009900';
		$config_error_text = $config_error ? $config->errors[0] : 'Ok';
		
		if ($config_warning !== null) {
			$config_warning_font = $config_warning ? '#ff0000' : '#009900';
			$config_warning_text = $config_warning ? 'Writeable!' : 'Secured';
		} else {
			$config_warning_font = 'black';
			$config_warning_text = 'Not available';
		}
		
		$version_font = $version_error ? '#ff0000' : '#009900';
		$version_text = phpversion();

		$extension_font = $imap_error ? '#ff0000' : '#009900';
		$extension_text = $imap_error ? 'Not loaded!' : 'Loaded';

		$logdir_font = $logdir_error ? '#ff0000' : '#009900';
		$logdir_text = $logdir_error ? 'Not writeable!' : 'Ok';

		$tmpdir_font = $tmpdir_error ? '#ff0000' : '#009900';
		$tmpdir_text = $tmpdir_error ? 'Not writeable!' : 'Ok';

		$datadir_font = $datadir_error ? '#ff0000' : '#009900';
		$datadir_text = $datadir_error ? 'Not writeable!' : 'Ok';

		$short_tags_font = $short_tags_error ? '#ff0000' : '#009900';
		$short_tags_text = $short_tags_error ? 'Not enabled!' : 'Ok';

		$file_uploads_font = $file_uploads_error ? '#ff0000' : '#009900';
		$file_uploads_text = $file_uploads_error ? 'Not enabled!' : 'Ok';

/**
* HTML
*/

?>
<html>
<head>
	<title>Configuration errors!</title>
	<style type="text/css">
	<!--
		BODY,TD {font-family: Arial, Verdana, Helvetica, Sans-Serif}
	// -->
	</style>
</head>
<body>

<table border="0" align="CENTER" height="100%">
	<tr>
		<td height="50%">&nbsp;</td>
	</tr>

	<tr>
		<td align="CENTER"><h2>Configuration error</h2></td>
	</tr>

	<tr>
		<td>
			Unfortunately this application needs the imap extension <br /> loaded and the version of php to be at least 4.1.0 to run.<br />
			Other configuration parameters may also be faulty.
		</td>
	</tr>

	<tr><td>&nbsp;</td></tr>

	<tr>
		<td>
			<ul>
				<li>Parsing config file: <font color="<?=$config_error_font?>"><?=$config_error_text?></font></li>
				<li>Config file local.config.xml: <font color="<?=$config_warning_font?>"><?=$config_warning_text?></font></li>
				<li>IMAP Extension loaded: <font color="<?=$extension_font?>"><?=$extension_text?></font></li>
				<li>PHP Version: <font color="<?=$version_font?>"><?=$version_text?></font></li>
				<li>Log directory writeable: <font color="<?=$logdir_font?>"><?=$logdir_text?></font></li>
				<li>Temp directory writeable: <font color="<?=$tmpdir_font?>"><?=$tmpdir_text?></font></li>
				<li>Userdata directory writeable: <font color="<?=$datadir_font?>"><?=$datadir_text?></font></li>
				<li>Short tags enabled: <font color="<?=$short_tags_font?>"><?=$short_tags_text?></font></li>
				<li>File uploads enabled: <font color="<?=$file_uploads_font?>"><?=$file_uploads_text?></font></li>
			</ul>
		</td>
	</tr>

	<tr>
		<td height="50%">&nbsp;</td>
	</tr>
</table>
<?php
		exit();
	}
?>