<?php
/**
* Filename.......: common.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/07 11:13:05 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* Base class containing common functions
*/
class common
{

	/**
    * Checks for an error message in the 
	* session, and unsets it if it's there.
	*
	* @param string $error_msg Variable to store the error message in (passed by reference)
	* @param string $no_error  Text to store in $error_msg if there is no error message in the session
    */
	function errorMsg(&$error_msg, $no_error = '')
	{
		global $SESSION;

		if (isset($SESSION['common']['error_msg'])) {
			$error_msg = $SESSION['common']['error_msg'];
			unset($SESSION['common']['error_msg']);
		} else {
			$error_msg = $no_error;
		}
	}
	
	/**
    * Redirect function issues a Location:
	* header and exits. Optionally sets an 
	* error message in the session.
	*
	* @param string $to        Where to redirect to
	* @param string $error_msg Any error message to add to the session
    */
	function redirect($to, $error_msg = null)
	{
		global $SESSION, $CONFIG;

		if (isset($error_msg)) {
			$SESSION['common']['error_msg'] = $error_msg;
		}

		header('Location: ' . common::url($to));
		exit;
	}

	/**
    * Returns an absolute URI to the requested
	* file. Defaults to self
	*
	* @param  string $file File/URL to get absolute url to
	* @return string       Full URL
    */
	function url($file = null)
	{
		global $CONFIG;
		include_once($CONFIG['pear_dir'] . 'Net/URL.php');

		$url = new Net_URL($file);
		
		// Ensure "vwebmailsession" is first querystring item
		if (!isset($GLOBALS['HTTP_COOKIE_VARS']['vwebmailsession'])) {
			$qs = array();
			foreach ($url->querystring as $name => $value) {
				$qs[$name] = $value;
			}
	
			$url->querystring = array();
			$url->addQueryString('vwebmailsession', session_id());
	
			foreach ($qs as $name => $value) {
				$url->addQueryString($name, $value, true);
			}
		}

		if (function_exists('hook_rewriteURL'))	// For backward compatability with old local.hooks.php
			return hook_rewriteURL($url->getURL());
		else 
			return $url->getURL();
	}
	
	/**
    * Returns best guess at client ip address
	* based on:
	*           CLIENT_IP
	*           HTTP_X_FORWARDED_FOR
	*           REMOTE_ADDR
	* In that order.
	*
	* @return string IP address
    */
	function getClientIP()
	{
		global $_SERVER;
		static $ip_address;
		
		if (@!$ip_address) {
			$ip_address = !empty($_SERVER['CLIENT_IP']) ? $_SERVER['CLIENT_IP'] : '';
			$ip_address = !empty($_SERVER['HTTP_X_FORWARDED_FOR']) && empty($ip_address)? $_SERVER['HTTP_X_FORWARDED_FOR'] : $ip_address;
			$ip_address = !empty($_SERVER['REMOTE_ADDR']) && empty($ip_address)? $_SERVER['REMOTE_ADDR'] : $ip_address;
		}

		return $ip_address;
	}
}


    /**
    * Decodes a header according to rfc2047
    */
    function decode_header($input)
    {
        // Remove white space between encoded-words
        $input = preg_replace('/(=\?[^?]+\?(Q|B)\?[^?]*\?=)( |' . "\t|" . "\r\n" . ')+=\?/', '\1=?', $input);
    
        // For each encoded-word...
        while (preg_match('/(=\?([^?]+)\?(Q|B)\?([^?]*)\?=)/i', $input, $matches)) {
    
            $encoded  = $matches[1];
            $charset  = $matches[2];
            $encoding = $matches[3];
            $text     = $matches[4];
        
            switch (strtolower($encoding)) {
                case 'b':
                    $text = base64_decode($text);
                    break;
        
                case 'q':
                    $text = str_replace('_', ' ', $text);
                    preg_match_all('/=([a-f0-9]{2})/i', $text, $matches);
                    foreach ($matches[1] as $value) {
                        $text = str_replace('='.$value, chr(hexdec($value)), $text);
                    }
                    break;
            }
        
            $input = str_replace($encoded, $text, $input);
        }
    
        return $input;
    }
    
    /**
    * Decodes mime data
    */
    function decode_body($body, $encoding)
    {
        global $CONFIG;
        switch (trim($encoding)) {
            case '7bit':             return $body;                break;
            case '8bit':             return $body;                break;
            case 'binary':           return $body;                break;
            case 'base64':           return base64_decode($body); break;
            // FIXME Don't use imap_qprint()
            case 'quoted-printable': return imap_qprint($body);   break;
            case 'other':            return $body;                break;
            default:                 return $body;                break;
        }
    }
?>