<?php
/**
* Filename.......: mailserver.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/01 10:27:28 $
* CVS Revision...: $Revision: 1.4 $
* Copyright......: 2001-2004 Richard Heyes
*/

class auth_mailserver extends auth
{
	/**
    * Errors
	* @var array
    */
	var $errors;

	/**
    * Constructor
    */
	function auth_mailserver()
	{
		$this->errors = array();
	}

	/**
    * Function to authenticate a user. This
	* will try to open a connection to an imap
	* or pop3 server.
    */
	function authenticate($params)
	{
		global $SESSION;

		$username = @$params['username'];
		$password = @$params['password'];
		$mailsrvr = @$params['mailsrvr'];
		$srvrtype = @$params['srvrtype'];
		$srvrport = @$params['srvrport'];

		$options = (strpos($srvrtype, "pop3") === false) ? OP_HALFOPEN : 0;
		if ($imp = @imap_open(sprintf('{%s:%s/%s}', $mailsrvr, $srvrport, $srvrtype), $username, $password, $options)) {
			imap_close($imp);
			$SESSION['login']['logged_in']  = true;
			$SESSION['login']['username']   = $username;
			$SESSION['login']['ip_address'] = common::getClientIP();
			return true;
		} else {
			foreach ((array)imap_errors() as $err) {

				global $LANG;

                /**
                  * Why is this here? So the lang() parser picks them up:
                  *
                  * $lang['IMAP_Login aborted']
                  */

				// Try to translate IMAP errors.
				$translation = $lang["IMAP_$err"];
				$this->errors[] = empty($translation) ? $err : $translation;
				$GLOBALS['logger']->log(sprintf('Login error: %s', $err), LOG_ERR);
			}
			@imap_close($imp);
			return false;
		}
	}

	/**
    * Returns any errors
    */
	function getErrors()
	{
		return $this->errors[count($this->errors) - 1];
	}

}
?>