<?php
/**
* Filename.......: auth.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

class auth
{
	/**
    * This factory method returns an appropriate
	* object based on what storage method
	* is being used.
    */
	function &factory($driver)
	{
		global $CONFIG;
		
		if (file_exists($CONFIG['includes'] . 'auth/' . $driver . '.php')) {
			include_once($CONFIG['includes'] . 'auth/' . $driver . '.php');
			$obj_name = 'auth_' . $driver;
			return new $obj_name();

		} else {
			return false;
		}
	}

	/**
    * Function to check whether someone is
	* logged in or not. Checks the data held
	* in the session
    */
	function is_logged_in()
	{
		global $SESSION;
	
		return (isset($SESSION['login']['logged_in']) AND $SESSION['login']['logged_in'] == true);
	}

	/**
    * Function to check the login status,
	* and if not logged in  redirect them
	* to a page, and set the session redirect_to
	* variable.
    */
	function check_login($login_page, $redirect_to)
	{
		global $SESSION, $LANG;

		if (!auth::is_logged_in()) {
			$SESSION['login']['redirect_to'] = $redirect_to;
			common::redirect($login_page);
		}
	}
}
?>