<?php
/**
* Filename.......: preferences.rules.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Logged in?
*/
	auth::check_login('login.php', 'preferences.personal.php');

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Saving preferences
*/
	if (!empty($_GET['saveprefs'])) {
		$USERPREFS['settings']['apply_rules_always'] = (!empty($_POST['apply_rules']) AND $_POST['apply_rules'] == 'always');
		$USERPREFS['settings']['apply_rules_login']  = (!empty($_POST['apply_rules']) AND $_POST['apply_rules'] == 'login');
		$USERPREFS['settings']['apply_rules_never']  = (!empty($_POST['apply_rules']) AND $_POST['apply_rules'] == 'never');
		$USERPREFS['settings']['rules_only_unseen']  = !empty($_POST['rules_only_unseen']);
		$USERPREFS['settings']['rules_only_recent']  = !empty($_POST['rules_only_recent']);

		savePrefs();

		common::redirect('redirect.php?to=preferences.rules.php', lang('Preferences saved'));
	}

/**
* Deleting/moving rules
*/
	// Delete
	if (isset($_GET['delete']) AND $_GET['delete'] !== 'none' AND isset($USERPREFS['rules'][(int)$_GET['delete']])) {
		unset($USERPREFS['rules'][(int)$_GET['delete']]);
		$USERPREFS['rules'] = array_values($USERPREFS['rules']);
		savePrefs();
		common::redirect('redirect.php?to=preferences.rules.php');

	// Move up
	} elseif (isset($_GET['moveup']) AND isset($USERPREFS['rules'][(int)$_GET['moveup']])) {

		$USERPREFS['rules'] = array_swap($USERPREFS['rules'], (int)$_GET['moveup'], (int)$_GET['moveup'] - 1);
		savePrefs();
		common::redirect('redirect.php?to=preferences.rules.php');

	// Move down
	} elseif (isset($_GET['movedown']) AND isset($USERPREFS['rules'][(int)$_GET['movedown']])) {

		$USERPREFS['rules'] = array_swap($USERPREFS['rules'], (int)$_GET['movedown'], (int)$_GET['movedown'] + 1);
		savePrefs();
		common::redirect('redirect.php?to=preferences.rules.php');
	}


/**
* Has form been submitted?
*/
	if (!empty($_POST)) {

		// Verify form has been filled in correctly
		if (!empty($_POST['from']))    $criteria[] = 'from';
		if (!empty($_POST['to']))      $criteria[] = 'to';
		if (!empty($_POST['cc']))      $criteria[] = 'cc';
		if (!empty($_POST['subject'])) $criteria[] = 'subject';
		if (!empty($_POST['body']))    $criteria[] = 'body';

		$SESSION['rules']['new_rule']['from']    = @$_POST['from'];
		$SESSION['rules']['new_rule']['to']      = @$_POST['to'];
		$SESSION['rules']['new_rule']['cc']      = @$_POST['cc'];
		$SESSION['rules']['new_rule']['subject'] = @$_POST['subject'];
		$SESSION['rules']['new_rule']['body']    = @$_POST['body'];
		$SESSION['rules']['new_rule']['match']   = @$_POST['match'];
		$SESSION['rules']['new_rule']['invert']  = @$_POST['invert'];
		$SESSION['rules']['new_rule']['actions'] = @$_POST['actions'];
		$SESSION['rules']['new_rule']['desc']    = @$_POST['description'];
		
		if (!isset($criteria)) {
			common::redirect('redirect.php?to=preferences.rules.php', lang('Please specify at least one criteria to match'));

		} elseif (!isset($_POST['actions']) OR empty($_POST['actions'])) {
			common::redirect('redirect.php?to=preferences.rules.php', lang('Please specify at least one action to perform'));
		}

		/**
        * Build description
        */
		switch ($_POST['match']) {
			case 'any':
				$SESSION['rules']['new_rule']['desc'] = lang('Match any of') . ' ';
				break;

			case 'all':
			default:
				$SESSION['rules']['new_rule']['desc'] = lang('Match all of') . ' ';
				break;
		}

		// lang('from')
		// lang('to')
		// lang('cc')
		// lang('body')
		// lang('subject')
		for ($i=0; $i<count($criteria); $i++) {
			$matches[] = '<i>&quot;' . $_POST[$criteria[$i]] . '&quot;</i> ' . lang('in') . ' <i>' . lang($criteria[$i]) . '</i>';
		}
		$SESSION['rules']['new_rule']['desc'] .= implode(', ', $matches) . ' ' . lang('and then') . ' ';

		for($i=0; $i<count($_POST['actions']); $i++){
			switch(substr($_POST['actions'][$i], 0, 4)){
				case 'copy':
					$folder = substr($_POST['actions'][$i], strpos($_POST['actions'][$i], ':') + 1);
					if (!$mailaccess->isValidMailbox($folder)) {
						common::redirect('redirect.php?to=preferences.rules.php', lang('Invalid mailbox name supplied'));
					}
					$actions[] = '<i>' . lang('Copy to') . ' ' . preg_replace('/^' . preg_quote($SESSION['email']['fold'], '/') . '/', '', $folder . '</i>');
					break;

				case 'move':
					$folder = substr($_POST['actions'][$i], strpos($_POST['actions'][$i], ':') + 1);
					if (!$mailaccess->isValidMailbox($folder)) {
						common::redirect('redirect.php?to=preferences.rules.php', lang('Invalid mailbox name supplied'));
					}
					$actions[] = '<i>' . lang('Move to') . ' ' . preg_replace('/^' . preg_quote($SESSION['email']['fold'], '/') . '/', '', $folder . '</i>');
					break;

				case 'mark':
					$actions[] = '<i>' . lang('Mark as read') . '</i>';
					break;

				case 'flag':
					$actions[] = '<i>' . lang('Flag message') . '</i>';
					break;

				case 'dele':
					$actions[] = '<i>' . lang('Delete message') . '</i>';
					break;
			}
		}

		$SESSION['rules']['new_rule']['desc'] .= implode(' ' . lang('and') . ' ', $actions);

		/**
        * Update or addition?
        */

		$index = (!empty($_POST['current_rules']) OR @$_POST['current_rules'] === '0') ? $_POST['current_rules'] : count(@$USERPREFS['rules']);

		$USERPREFS['rules'][$index] = $SESSION['rules']['new_rule'];
		unset($SESSION['rules']['new_rule']);

		savePrefs();

		common::redirect('redirect.php?to=preferences.rules.php');
	}

/**
* Form not submitted...
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		/**
        ** Get list of subscribed folders
        */
		if ($mailaccess->capabilities('folders')) {

			list($folders, $folderTree) = $mailaccess->getSubscribedFolders();
			for ($i=0; $i<count($folders); $i++) {
				// Remove name from unselectable mailboxes
				if ($folders[$i]['noselect'] == TRUE) {
					$folders[$i]['name'] = '';
				}
			}
			array_unshift($folders, array('name' => '', 'name_htmlsafe' => '', 'name_urlsafe' => '', 'text' => ''));
		}

	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}

/**
* Template stuff
*/
	$tpl_prefix_len = strlen($SESSION['email']['fold']);
	$rules = is_array(@$USERPREFS['rules']) ? $USERPREFS['rules'] : array();

	for ($i=0; $i<count($rules); $i++) {
		$rules[$i]['from']    = javascript::escapeString($rules[$i]['from']);
		$rules[$i]['to']      = javascript::escapeString($rules[$i]['to']);
		$rules[$i]['cc']      = javascript::escapeString($rules[$i]['cc']);
		$rules[$i]['subject'] = javascript::escapeString($rules[$i]['subject']);
		$rules[$i]['body']    = javascript::escapeString($rules[$i]['body']);
		$rules[$i]['desc']    = javascript::escapeString($rules[$i]['desc']);
		$rules[$i]['match']   = javascript::escapeString(@$rules[$i]['match']);
		$rules[$i]['invert']  = javascript::escapeString(@$rules[$i]['invert']);
	}

	// Set preferences
	$form_apply_rules_always_checked = @$USERPREFS['settings']['apply_rules_always'] ? 'checked="checked"' : '';
	$form_apply_rules_login_checked  = @$USERPREFS['settings']['apply_rules_login']  ? 'checked="checked"' : '';
	$form_apply_rules_never_checked  = @$USERPREFS['settings']['apply_rules_never']  ? 'checked="checked"' : '';
	$form_rules_only_unseen_checked  = @$USERPREFS['settings']['rules_only_unseen']  ? 'checked="checked"' : '';
	$form_rules_only_recent_checked  = @$USERPREFS['settings']['rules_only_recent']  ? 'checked="checked"' : '';

	$template = 'preferences.rules.html';
	include($CONFIG['includes'].'template.wrapper.php');

?>