<?php
/**
* Filename.......: preferences.personal.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/03 18:31:39 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Logged in?
*/
	auth::check_login('login.php', 'preferences.personal.php');

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Create addressbook and get list of addresses
*/
	$ab = new addressbook();

/**
* New identity?
*/
	if (!empty($_GET['newid'])) {
		$USERPREFS['identities'][count(@$USERPREFS['identities']) + 1] = array(	'id_name'           => strip_tags($_GET['newid']),
																				'name'              => '',
																				'email_address'     => '',
																				'reply_address'     => ''
																			  );
		savePrefs();
		common::redirect('redirect.php?to=' . urlencode('preferences.personal.php?identity=' . count(@$USERPREFS['identities'])));
	}

/**
* Delete identity?
*/
	if (!empty($_GET['deleteid']) AND isset($USERPREFS['identities'][$_GET['deleteid']])) {
		unset($USERPREFS['identities'][$_GET['deleteid']]);
		savePrefs();
		common::redirect('redirect.php?to=preferences.personal.php');
	}

/**
* Can user set email address?
*/
	$changeable_email = (bool)@$HOSTINFO['allow_changeable_email'];

/**
* Form submitted?
*/
	if(!empty($_POST)){

		// Determine redirect
		if (!empty($_POST['identity'])) {
			$redirect = 'redirect.php?to=' . urlencode('preferences.personal.php?identity=' . $_POST['identity']);
		} else {
			$redirect = 'redirect.php?to=preferences.personal.php';
		}

		identities::setProperty(@$_POST['identity'], 'name', @$_POST['name']);
		if ($changeable_email) {
			identities::setProperty(@$_POST['identity'], 'email_address', @$_POST['email_address']);
			identities::setProperty(@$_POST['identity'], 'reply_address', @$_POST['reply_address']);
		}
		
		if (!empty($_POST['include_vcard']) AND empty($_POST['vcard_id'])) {
			common::redirect($redirect, lang('Invalid addressbook entry specified'));
		} else {
			$USERPREFS['settings']['include_vcard'] = @$_POST['include_vcard'];
			$USERPREFS['settings']['vcard_id'] = @$_POST['vcard_id'];
		}

		$USERPREFS['settings']['signature']         = @$_POST['signature'];
		$USERPREFS['settings']['sig_reply_forward'] = (bool)@$_POST['sig_reply_forward'];
	
		// Save the preferences
		$result = savePrefs();

		common::redirect($redirect, $result ? lang('Preferences saved') : '');
	}

/**
* Get the current values from $USERPREFS
*/
	$form_name                = @htmlspecialchars(identities::getProperty(@$_GET['identity'], 'name'));
	$form_email_address       = @htmlspecialchars(identities::getProperty(@$_GET['identity'], 'email_address'));
	$form_reply_address       = @htmlspecialchars(identities::getProperty(@$_GET['identity'], 'reply_address'));

	$form_signature           = htmlspecialchars($USERPREFS['settings']['signature']);
	$form_sig_reply_forward   = @$USERPREFS['settings']['sig_reply_forward'] ? 'checked="checked"' : '';
	$form_include_vcard       = @$USERPREFS['settings']['include_vcard'] ? 'checked="checked"' : '';

	/**
    * Create list of identities
    */
	$identities = identities::getIdentityList(@$_GET['identity']);
	$currentid  = @$_GET['identity'];
	
	/**
    * Handle addresses for vcard thing
    */
	$allAddresses = $ab->getAllAddresses(true, @$USERPREFS['settings']['vcard_id']);
	if (empty($allAddresses)) {
		$allAddresses = array(array('uid' => 0, 'text' => lang('No addresses!'), 'selected' => ''));
	}

/**
* Template stuff
*/
	$template = 'preferences.personal.html';
	include($CONFIG['includes'].'template.wrapper.php');

?>