<?php
/**
* Filename.......: preferences.folders.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision&
* Copyright......: 2001-2004 Richard Heyes 
*/

	include('config.php');

/**
* Logged in?
*/
	auth::check_login('login.php', 'preferences.email.php');

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Form submitted?
*/
	if (!empty($_POST)) {

		foreach (array('sent_items_folder', 'draft_items_folder', 'deleted_items_folder') as $folder) {
			if ($mailaccess->isValidMailbox($_POST[$folder])) {
				$USERPREFS['settings'][$folder] = $_POST[$folder];
			} else {
				if ($folder == 'sent_items_folder') {
					$error = lang('The folder you selected for sent mail was invalid');
				} elseif ($folder == 'draft_items_folder') {
					$error = lang('The folder you selected for draft mail was invalid');
				} else {
					$error = lang('The folder you selected for deleted mail was invalid');
				}
				common::redirect('redirect.php?to=preferences.folders.php', $error);
			}
		}

		$USERPREFS['settings']['show_folder_stats']     = @(bool)$_POST['show_folder_stats'];
		$USERPREFS['settings']['empty_deleted_on_exit'] = @(bool)$_POST['empty_deleted_on_exit'];
		$USERPREFS['settings']['delete_items_older']    = @(int)$_POST['delete_items_older'];
		$USERPREFS['settings']['auto_subscribe_new']    = @(bool)$_POST['auto_subscribe_new'];
		$USERPREFS['settings']['use_autohide']          = @(bool)$_POST['use_autohide'];
		$USERPREFS['settings']['use_folder_frame']      = @(bool)$_POST['use_folder_frame'];
		$USERPREFS['settings']['folder_frame_width']    = max(100, @(int)$_POST['folder_frame_width']);

		// Save the preferences
		$result = savePrefs();

		common::redirect('redirect.php?to=preferences.folders.php', $result ? lang('Preferences saved') : '');
	}

/**
* Get folder details for display
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		if ($mailaccess->capabilities('folders')) {

			list($all_folders, $folderTree) = $mailaccess->getAllFolders();

			for ($i=0; $i<count($all_folders);$i++) {
				if ($all_folders[$i]['noselect'] == true) {
					$all_folders[$i]['name'] = '';
				}

				$sent_selected = (isset($USERPREFS['settings']['sent_items_folder'])
				                    AND $all_folders[$i]['name'] == $USERPREFS['settings']['sent_items_folder']) ? 'selected="selected"' : '';
				$draft_selected = (isset($USERPREFS['settings']['draft_items_folder'])
				                      AND $all_folders[$i]['name'] == $USERPREFS['settings']['draft_items_folder']) ? 'selected="selected"' : '';
				$deleted_selected = (isset($USERPREFS['settings']['deleted_items_folder'])
				                       AND $all_folders[$i]['name'] == $USERPREFS['settings']['deleted_items_folder']) ? 'selected="selected"' : '';

				$all_folders[$i]['sent_selected'] = $sent_selected;
				$all_folders[$i]['draft_selected'] = $draft_selected;
				$all_folders[$i]['deleted_selected'] = $deleted_selected;
			}

		/**
        * No folders...
        */
		} else {
			common::redirect('index.php', lang('This account type does not support folders'));
		}

	/**
    * Connect() failed
    */
	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}

/**
* Other prefs
*/
	$form_show_folder_stats     = @$USERPREFS['settings']['show_folder_stats']     ? 'checked="checked"' : '';
	$form_empty_deleted_checked = @$USERPREFS['settings']['empty_deleted_on_exit'] ? 'checked="checked"' : '';
	$form_delete_items_older    = @(int)$USERPREFS['settings']['delete_items_older'];
	$form_auto_subscribe_new    = @$USERPREFS['settings']['auto_subscribe_new']    ? 'checked="checked"' : '';
	$form_use_autohide          = @$USERPREFS['settings']['use_autohide']          ? 'checked="checked"' : '';
	$form_use_folder_frame      = @$USERPREFS['settings']['use_folder_frame']      ? 'checked="checked"' : '';
	$form_folder_frame_width    = @(int)$USERPREFS['settings']['folder_frame_width'];

/**
* Template stuff
*/
	$template = 'preferences.folders.html';
	include($CONFIG['includes'].'template.wrapper.php');

?>