<?php
/**
* Filename.......: preferences.email.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Logged in?
*/
	auth::check_login('login.php', 'preferences.email.php');

/**
* Is this even enabled ?
*/
	if (@!$HOSTINFO['allow_fetchmail']) {
		$logger->log(sprintf('User (%s) tried to access email.poll.php when access not permitted, from: (%s)', $SESSION['email']['user'], common::getClientIP()), PEAR_LOG_WARNING);
		die('Access not permitted');
	}

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Form submitted?
*/
	if (!empty($_POST)) {
		switch (@$_POST['action']) {
			case 'new_account':
				if (!empty($_POST['account_name'])) {
					foreach (@(array)$USERPREFS['mail_accounts'] as $account) {
						if (strcasecmp($account['name'], $_POST['account_name']) == 0) {
							common::redirect('redirect.php?to=preferences.fetchmail.php', lang('A mail account already exists with that name!'));
						}
					}
					
					$USERPREFS['mail_accounts'][] = array('name' => $_POST['account_name'], 'port' => 143, 'type' => 'imap', 'folder' => 'INBOX');
					savePrefs();
				}
				common::redirect('redirect.php?to=' . urlencode('preferences.fetchmail.php?account=' . (count($USERPREFS['mail_accounts']) - 1)));
				break;

			case 'delete_account':
				if (!empty($_POST['account_name'])) {
					foreach ($USERPREFS['mail_accounts'] as $id => $account) {
						if (strcasecmp($account['name'], $_POST['account_name']) == 0) {
							unset($USERPREFS['mail_accounts'][$id]);
							sort($USERPREFS['mail_accounts']);
							savePrefs();
							common::redirect('redirect.php?to=preferences.fetchmail.php', lang('Account deleted'));
						}
					}
					common::redirect('redirect.php?to=preferences.fetchmail.php');
				}
				break;

			case 'save_changes':
				if (!empty($_POST['account_name'])) {
					// Find the correct array index
					foreach (@(array)$USERPREFS['mail_accounts'] as $id => $account) {
						if (strcasecmp($account['name'], $_POST['account_name']) == 0) {
							break;
						}
					}
					$USERPREFS['mail_accounts'][$id]['username'] = @$_POST['username'];
					if (!empty($_POST['password'])) {
						$USERPREFS['mail_accounts'][$id]['password'] = base64_encode(@$_POST['password']);
					}
					
					if (!$mailaccess->isValidMailbox(@$_POST['deliver_to'])) {
						common::redirect('redirect.php?to=' . urlencode('preferences.fetchmail.php?account=' . (int)@$_GET['account']), lang('Invalid mailbox name supplied'));
					}
					
					$USERPREFS['mail_accounts'][$id]['server']          = @$_POST['server'];
					$USERPREFS['mail_accounts'][$id]['port']            = @$_POST['port'];
					$USERPREFS['mail_accounts'][$id]['type']            = @$_POST['type'];
					$USERPREFS['mail_accounts'][$id]['folder']          = !empty($_POST['folder']) ? $_POST['folder'] : 'INBOX';
					$USERPREFS['mail_accounts'][$id]['deliver_to']      = @$_POST['deliver_to'];
					$USERPREFS['mail_accounts'][$id]['leave_on_server'] = @(bool)$_POST['leave_on_server'];
					savePrefs();

					common::redirect('redirect.php?to=' . urlencode('preferences.fetchmail.php?account=' . $id), lang('Changes saved'));

				} else {
					common::redirect('redirect.php?to=preferences.fetchmail.php', lang('Please select an account!'));
				}
				break;
		}
	}

/**
* Get the current values from $USERPREFS
* (Must have folders!)
*/
	if($mailaccess->capabilities('folders')){
		if($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])){

			list($all_folders, $folderTree) = $mailaccess->getAllFolders();

			for($i=0; $i<count($all_folders);$i++){
				if($all_folders[$i]['noselect'] == TRUE){
					$all_folders[$i]['name'] = '';
				}
			}
		} else {
			$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
			common::redirect('preferences.php', lang('Failed to connect to account!'));
		}
	}else{
		common::redirect('preferences.php', lang('This account type does not support folders'));
	}

	$noAccounts = count(@$USERPREFS['mail_accounts']) == 0;
	// Friendlier tpl variable
	$mail_accounts = !$noAccounts ? $USERPREFS['mail_accounts'] : array();

	if (isset($_GET['account'])) {
		$accountID = $_GET['account'];
	}

/**
* Template stuff
*/
	$template = 'preferences.fetchmail.html';
	include($CONFIG['includes'].'template.wrapper.php');
?>
