<?php
/**
* Filename.......: preferences.email.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/28 17:44:17 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
** Logged in?
*/
	auth::check_login('login.php', 'preferences.email.php');

/**
** Remove any error message from the
** session and set the error_msg var for
** the template.
*/
	common::errorMsg($error_msg);

/**
** Form submitted?
*/
	if (!empty($_POST)) {
	
		$USERPREFS['settings']['show_per_page']     = max(5, (int)$_POST['show_per_page']);
		$USERPREFS['settings']['autorefresh_list']  = (int)$_POST['autorefresh_list'];
		$USERPREFS['settings']['unread_mail']       = $_POST['unread_mail'];

		$USERPREFS['settings']['show_html']         = isset($_POST['show_html']) ? true : false;
		$USERPREFS['settings']['send_mdns']         = isset($_POST['send_mdns']) ? true : false;

		$USERPREFS['settings']['outgoing_wrap']     = max(10, (int)$_POST['outgoing_wrap']);
		$USERPREFS['settings']['reply_indent_char'] = $_POST['reply_indent_char'];
		$USERPREFS['settings']['view_msg_delete']   = $_POST['view_msg_delete'] == 'next'  ? 'next'  : ($_POST['view_msg_delete'] == 'prev' ? 'prev' : 'index');

		$USERPREFS['settings']['defaultEditor']     = $_POST['default_editor'];

		// Save the preferences
		$result = savePrefs();

		common::redirect('redirect.php?to=preferences.email.php', $result ? lang('Preferences saved') : '');
	}

/**
** Get the current values from $USERPREFS
*/
	$form_show_per_page   = $USERPREFS['settings']['show_per_page'];
	${'form_autorefresh_list_'.(int)@$USERPREFS['settings']['autorefresh_list']} = 'selected="selected"';
	${'form_unread_mail_' . @$USERPREFS['settings']['unread_mail']} = 'selected="selected"';

	$form_show_html       = ($USERPREFS['settings']['show_html'] == true) ? 'checked="checked"' : '';
	$form_send_mdns       = (@$USERPREFS['settings']['send_mdns'] == true) ? 'checked="checked"' : '';

	$form_outgoing_wrap     = htmlspecialchars($USERPREFS['settings']['outgoing_wrap']);
	$form_reply_indent_char = htmlspecialchars($USERPREFS['settings']['reply_indent_char']);
	${'form_view_msg_delete_'.@(string)$USERPREFS['settings']['view_msg_delete']} = 'selected="selected"';

	if (@!$HOSTINFO['allow_html_email']) {
		$form_show_html       = 'disabled="disabled"';
		$form_strip_html_tags = 'disabled="disabled" checked="checked"';
	}

	$form_default_editor_html = ($USERPREFS['settings']['defaultEditor'] == 'html') ? ' checked="checked"' : '';
	$form_default_editor_text = ($USERPREFS['settings']['defaultEditor'] != 'html') ? ' checked="checked"' : '';

/**
** Template stuff
*/
	$template = 'preferences.email.html';
	include($CONFIG['includes'].'template.wrapper.php');
?>