<?php
/**
* Filename.......: preferences.blacklists.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/04 12:11:22 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
** Logged in?
*/
	auth::check_login('login.php', 'preferences.blacklists.php');

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Are blacklists enabled in the config file?
*/
	if (!@$HOSTINFO['allow_blacklists'] AND $mailaccess->capabilities('folders')) {
		common::redirect('preferences.php');
	}

/**
* Any querystring action ?
*/
	if (!empty($_GET['action']) AND !empty($_GET['value'])) {
		switch ($_GET['action']) {
			/**
            * Sender
            */
			case 'blocksender':
				require_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

				if (is_array($_GET['value'])) {
					$count = 0;
					foreach ($_GET['value'] as $value) {
						$addresslist = Mail_RFC822::parseAddressList($value, null, false, false);
						$email = $addresslist[0]->mailbox . '@' . $addresslist[0]->host;
						if (!empty($addresslist[0]->mailbox) AND !@in_array($email, $USERPREFS['blacklists']['senders'])) {
							$USERPREFS['blacklists']['senders'][] = $email;
							$count++;
						}
					}
					$errorMsg = $count . lang(' address(es) have been added to the sender blacklist');
				} else {

					$addresslist = Mail_RFC822::parseAddressList($_GET['value'], null, false, false);
					$email = $addresslist[0]->mailbox . '@' . $addresslist[0]->host;
					if (!empty($addresslist[0]->mailbox) AND !@in_array($email, $USERPREFS['blacklists']['senders'])) {
						$USERPREFS['blacklists']['senders'][] = $email;
						$errorMsg = $email . lang(' was added to the sender blacklist');
					} else {
						$errorMsg = $email . lang(' was not added to the sender blacklist');
					}
				}
				break;

			/**
            * Recipient
            */
			case 'blockrecipient':
				require_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

				if (is_array($_GET['value'])) {
					$count = 0;
					foreach ($_GET['value'] as $value) {
						$addresslist = Mail_RFC822::parseAddressList($value, null, false, false);
						$email = $addresslist[0]->mailbox . '@' . $addresslist[0]->host;
						if (!empty($addresslist[0]->mailbox) AND !@in_array($email, $USERPREFS['blacklists']['recipients'])) {
							$USERPREFS['blacklists']['recipients'][] = $email;
							$count++;
						}
					}
					$errorMsg = $count . lang(' address(es) have been added to the recipient blacklist');
				} else {
					$addresslist = Mail_RFC822::parseAddressList($_GET['value'], null, false, false);
					$email = $addresslist[0]->mailbox . '@' . $addresslist[0]->host;
					if (!empty($addresslist[0]->mailbox) AND !@in_array($email, $USERPREFS['blacklists']['recipients'])) {
						$USERPREFS['blacklists']['recipients'][] = $email;
						$errorMsg = $email . lang(' was added to the recipient blacklist');
					} else {
						$errorMsg = $email . lang(' was not added to the recipient blacklist (already present?)');
					}
				}
				break;

			/**
            * Subject
            */
			case 'blocksubject':
				if (is_array($_GET['value'])) {
					$count = 0;
					foreach ($_GET['value'] as $value) {
						if (!@in_array($value, $USERPREFS['blacklists']['subjects'])) {
							$USERPREFS['blacklists']['subjects'][] = $value;
							$count++;
						}
					}
					$errorMsg = $count . lang(' subject(s) have been added to the subject blacklist');
				} else {
					if (!@in_array($_GET['value'], $USERPREFS['blacklists']['subjects'])) {
						$USERPREFS['blacklists']['subjects'][] = $_GET['value'];
						$errorMsg = lang('Subject was added to blacklist');
					} else {
						$errorMsg = lang('Subject was not added to blacklist (already present?)');
					}
				}
				break;
		}

		// Determine redirection destination
		if (@$_GET['msg_id'] > 0) {
			// Apply blacklist action immediately to given message when message id is available
			common::redirect('email.list.php?filter=1&msg_id=' . $_GET['msg_id'], $errorMsg);
		} elseif (@$_GET['from'] == 'listing') {
			common::redirect('email.list.php', $errorMsg);
		} else {
			common::redirect($_SERVER['HTTP_REFERER'], $errorMsg);
		}
	}

/**
** Form submitted?
*/
	if (!empty($_POST)) {

		// The lists	
		$USERPREFS['blacklists']['senders']    = !empty($_POST['senders'])    ? preg_split('/\r?\n/', $_POST['senders'], -1, PREG_SPLIT_NO_EMPTY) : array();
		$USERPREFS['blacklists']['recipients'] = !empty($_POST['recipients']) ? preg_split('/\r?\n/', $_POST['recipients'], -1, PREG_SPLIT_NO_EMPTY) : array();
		$USERPREFS['blacklists']['bodies']     = !empty($_POST['bodies'])     ? preg_split('/\r?\n/', $_POST['bodies'], -1, PREG_SPLIT_NO_EMPTY) : array();
		$USERPREFS['blacklists']['subjects']   = !empty($_POST['subjects'])   ? preg_split('/\r?\n/', $_POST['subjects'], -1, PREG_SPLIT_NO_EMPTY) : array();
		
		// The options
		$USERPREFS['blacklists']['apply']       = !empty($_POST['apply'])  ? $_POST['apply'] : 'always';
		$USERPREFS['blacklists']['action']      = !empty($_POST['action']) ? $_POST['action'] : 'delete';
		$USERPREFS['blacklists']['move_folder'] = !empty($_POST['folder']) ? $_POST['folder'] : 'INBOX';
		
		// Save the preferences
		$result = savePrefs();

		common::redirect('redirect.php?to=preferences.blacklists.php', $result ? lang('Preferences saved') : '');
	}

/**
* Get folder information
*/
	if($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])){

		list($all_folders, ) = $mailaccess->getAllFolders();
		for($i=0; $i<count($all_folders);$i++){
			if($all_folders[$i]['noselect'] == true){
				$all_folders[$i]['name'] = '';
			}
			
			if ($all_folders[$i]['name'] == @$USERPREFS['blacklists']['move_folder']) {
				$all_folders[$i]['selected'] = 'selected="selected"';
			}
		}
	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		common::redirect('preferences.php', lang('Failed to connect to account!'));
	}


/**
* Get the current values from $USERPREFS
*/
	$form_blocked_senders    = htmlspecialchars(implode("\r\n", @(array)$USERPREFS['blacklists']['senders']));
	$form_blocked_recipients = htmlspecialchars(implode("\r\n", @(array)$USERPREFS['blacklists']['recipients']));
	$form_blocked_bodies     = htmlspecialchars(implode("\r\n", @(array)$USERPREFS['blacklists']['bodies']));
	$form_blocked_subjects   = htmlspecialchars(implode("\r\n", @(array)$USERPREFS['blacklists']['subjects']));
	
	${'form_apply_blacklists_' . (!empty($USERPREFS['blacklists']['apply']) ? $USERPREFS['blacklists']['apply'] : 'always')} = 'checked="checked"';
	${'form_action_blacklists_' . (!empty($USERPREFS['blacklists']['action']) ? $USERPREFS['blacklists']['action'] : 'delete')} = 'checked="checked"';

/**
* Template stuff
*/
	$template = 'preferences.blacklists.html';
	include($CONFIG['includes'].'template.wrapper.php');
?>