<?php
/**
* Filename.......: login.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/04/05 15:18:41 $
* CVS Revision...: $Revision: 1.7 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Create the $SERVERS array
*/
	$SERVERS = $config->getValue('servers/server', 'array');

/**
* Check Login
*/
	if (auth::is_logged_in()) {
		common::redirect('index.php');
	}

/**
* If form has been posted do this...
*/
	if (!empty($_POST)) {

		/**
        * Check for username and password
        */
		$username = isset($_POST['username']) ? $_POST['username'] : '';
		$password = isset($_POST['password']) ? $_POST['password'] : '';

		/**
        * Username lookup hook
        */
		if (function_exists('hook_usernameLookup')) {
			list($username, $password) = hook_usernameLookup($username, $password);
		}

		/**
        * Check for template option.
        */
		$template = isset($_POST['template']) ? $_POST['template'] : $SESSION['common']['default_tpl_set'];

		$template = $_POST['template'];
		if (file_exists($CONFIG['tpl_dir'] . $template)) {
			$SESSION['common']['tpl_set'] = $template;
		}

		/**
        * Now check the login details.
        */
		if ($config->getValue('general/servers_strict') AND !isset($_POST['server_id'])) {
			common::redirect('redirect.php?to=login.php', lang('No server id was specified!'));

		} elseif ($config->getValue('general/servers_strict') AND !isset($SERVERS[$_POST['server_id']]['hostname'])) {
			common::redirect('redirect.php?to=login.php', lang('Invalid server id specified'));

		} elseif ($config->getValue('general/servers_strict')) {
			$mail_server      = $SERVERS[$_POST['server_id']]['hostname'];
			$mail_server_port = $SERVERS[$_POST['server_id']]['port'];
			$mail_server_type = $SERVERS[$_POST['server_id']]['type'];
			$mail_server_fold = $SERVERS[$_POST['server_id']]['folder_prefix'];
			$mail_server_capa = $SERVERS[$_POST['server_id']]['capabilities'];

		} else {
			$mail_server      = isset($_POST['mail_server'])      ? $_POST['mail_server']      : $SERVERS[0]['hostname'];
			$mail_server_port = isset($_POST['mail_server_port']) ? $_POST['mail_server_port'] : $SERVERS[0]['port'];
			$mail_server_type = isset($_POST['mail_server_type']) ? $_POST['mail_server_type'] : $SERVERS[0]['type'];
			$mail_server_fold = isset($_POST['mail_server_fold']) ? $_POST['mail_server_fold'] : $SERVERS[0]['folder_prefix'];
			$mail_server_capa = $SERVERS[0]['capabilities'];
		}

		$auth = &auth::factory('mailserver');

		$params['username'] = $username;
		$params['password'] = $password;
		$params['mailsrvr'] = $mail_server;
		$params['srvrport'] = $mail_server_port;
		$params['srvrtype'] = $mail_server_type;

		if ($auth->authenticate($params)) {
			
			$logger->log(sprintf('User logged in (%s) from (%s)', $username, common::getClientIP()));

			if (isset($SESSION['login']['mail_server']))      unset($SESSION['login']['mail_server']);
			if (isset($SESSION['login']['mail_server_port'])) unset($SESSION['login']['mail_server_port']);
			if (isset($SESSION['login']['mail_server_type'])) unset($SESSION['login']['mail_server_type']);
			if (isset($SESSION['login']['mail_server_fold'])) unset($SESSION['login']['mail_server_fold']);

			$SESSION['email']['srvr'] = $mail_server;
			$SESSION['email']['port'] = $mail_server_port;
			$SESSION['email']['type'] = $mail_server_type;
			$SESSION['email']['user'] = $username;
			$SESSION['email']['pass'] = base64_encode($password);
			$SESSION['email']['mbox'] = 'INBOX';
			$SESSION['email']['fold'] = $mail_server_fold;
			$SESSION['email']['capa'] = $mail_server_capa;

			$SESSION['email']['smtp_srvr'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['hostname']) ? $SERVERS[@(int)$_POST['server_id']]['smtp']['hostname'] : null;
			$SESSION['email']['smtp_port'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['port'])     ? $SERVERS[@(int)$_POST['server_id']]['smtp']['port'] : 25;
			$SESSION['email']['smtp_helo'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['helo'])     ? $SERVERS[@(int)$_POST['server_id']]['smtp']['helo'] : $_SERVER['SERVER_NAME'];
			$SESSION['email']['smtp_auth'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['enabled'])  ? $SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['enabled'] : false;
			$SESSION['email']['smtp_user'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['username']) ? $SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['username'] : $username;
			$SESSION['email']['smtp_pass'] = !empty($SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['password']) ? base64_encode($SERVERS[@(int)$_POST['server_id']]['smtp']['authentication']['password']) : base64_encode($password);
			
			$SESSION['email']['use_uids']  = isset($SERVERS[@(int)$_POST['server_id']]['use_uids']) ? $SERVERS[@(int)$_POST['server_id']]['use_uids'] : true;
			$SESSION['email']['extended_listing'] = isset($SERVERS[@(int)$_POST['server_id']]['extended_listing']) ? $SERVERS[@(int)$_POST['server_id']]['extended_listing'] : true;

			// Load up this users preferences
			$SESSION['userprefs'] = loadPrefs($username);

			// If allow_changeable_email is off, set the email in userprefs
			if (!$HOSTINFO['allow_changeable_email']) {
				$domain = !empty($SERVERS[@(int)$_POST['server_id']]['domain']) ? $SERVERS[@(int)$_POST['server_id']]['domain'] : $SESSION['email']['srvr'];
				$SESSION['userprefs']['settings']['email_address'] = @$HOSTINFO['username_is_email'] ? $SESSION['email']['user'] : $SESSION['email']['user'] . '@' . $domain;
			}
			
			// If email pref is blank, call the blank email hook function
			if (empty($SESSION['userprefs']['settings']['email_address']) AND function_exists('hook_emailLookup')) {
				$SESSION['userprefs']['settings']['email_address'] = hook_emailLookup($SESSION['email']['user']);
			}

			// Set lang file variable in session
			$SESSION['common']['lang'] = isset($_POST['language']) ? $_POST['language'] : $config->getValue('general/default_lang');
			$SESSION['common']['lang'] = @$USERPREFS['settings']['lang_always'] == true ? $USERPREFS['settings']['lang'] : $SESSION['common']['lang'];

			// Perform Deleted Items clean up
			if ((int)$SESSION['userprefs']['settings']['delete_items_older'] > 0) {
				include($CONFIG['includes'] . 'clear.deleted.php');
			}

			// Set first view so rules will run
			$SESSION['login']['first_view'] = true;

 			if (isset($SESSION['login']['redirect_to'])) {
				$redirect_to = $SESSION['login']['redirect_to'];
 				unset($SESSION['login']['redirect_to']);
				$url = @$SESSION['userprefs']['settings']['use_folder_frame'] ? 'frameset.php?rframe=' . urlencode(common::url($redirect_to)) : $redirect_to;
 			} else {
				$url = @$SESSION['userprefs']['settings']['use_folder_frame'] ? 'frameset.php?rframe=' . urlencode(common::url('index.php')) : 'index.php';
 			}

			common::redirect($url);

		} else {

			// Store details so user doesn't have to retype
			$SESSION['login']['mail_server']      = $mail_server;
			$SESSION['login']['mail_server_port'] = $mail_server_port;
			$SESSION['login']['mail_server_type'] = $mail_server_type;
			$SESSION['login']['mail_server_fold'] = $mail_server_fold;

			if (!empty($_POST['server_id'])) {
				$SESSION['login']['server_id'] = $_POST['server_id'];
			}

			common::redirect('redirect.php?to=login.php', lang('Username/password not recognised!') . '<br />' . $auth->getErrors());
		}
	}

/**
* Check for error_msg variable.
*/
	common::errorMsg($error_msg);

/**
* Get list of all templates, and the 
* default set to use.
*/
	/**
	* Get default.
	*/
	if(!isset($SESSION['common']['tpl_set'])){

		$default_tpl_set = '';
		if(!empty($HOSTINFO['default_tpl_set'])){
			$default_tpl_set = $HOSTINFO['default_tpl_set'];
			$SESSION['common']['default_tpl_set'] = $default_tpl_set;
		}else{
			$msg = 'Could not retrieve default template setting';
			die($msg);
		}
	}else{
		$default_tpl_set = $SESSION['common']['tpl_set'];
	}

/**
* Perform configuration checks and show
* error template if any fail
*/
	if($CONFIG['config_checks']){
		include($CONFIG['includes'] . 'config.checks.php');
	}

	/**
	* Get list of all template sets. And format
	* into a "loopable" variable ($template_sets)
	*/
	foreach($HOSTINFO['templates']['template_set'] as $value){
		$selected = ($value['folder'] == $default_tpl_set) ? 'SELECTED' : '';
		$template_sets[] = array('dirname' => $value['folder'], 'label' => $value['description'], 'selected' => $selected);
	}

	if(!isset($template_sets)){
		$msg = 'Could not retrieve list of templates';
		die($msg);
	}

	/**
    * Get list of languages. Needs formating
	* into usable array.
    */
	foreach($config->getValue('/v-webmail/languages/language') as $key => $value) {
		// The English language file does not have a language file.
		$languageCode = "";
		if (empty($value['filename'])) {
			// Default language
			$languageCode = "en";
		} else {
			$languageCode = str_replace('.php', '', str_replace('lang.', '', $value['filename']));
		}
		$selected = ($languageCode == $config->getValue('general/default_lang')) ? ' selected="selected" ' : '';
		$languages[] = array('code' => $languageCode, 'description' => $value['description'], 'selected' => $selected);
	}

/**
* Finally, template stuff.
*/
	$mail_server      = isset($SESSION['login']['mail_server'])      ? $SESSION['login']['mail_server']      : $SERVERS[0]['hostname'];
	$mail_server_port = isset($SESSION['login']['mail_server_port']) ? $SESSION['login']['mail_server_port'] : $SERVERS[0]['port'];
	$mail_server_type = isset($SESSION['login']['mail_server_type']) ? $SESSION['login']['mail_server_type'] : $SERVERS[0]['type'];
	$mail_server_fold = isset($SESSION['login']['mail_server_fold']) ? $SESSION['login']['mail_server_fold'] : $SERVERS[0]['folder_prefix'];

	$tpl_default_mail_server      = $mail_server;
	$tpl_default_mail_server_port = $mail_server_port;
	$tpl_default_mail_server_fold = $mail_server_fold;

	// Protocol default
	$tpl_mail_server_type_imap         = ($mail_server_type == 'imap'                     ? 'selected="selected"' : '');
	$tpl_mail_server_type_imap_notls   = ($mail_server_type == 'imap/notls'               ? 'selected="selected"' : '');
	$tpl_mail_server_type_imap_ssl     = ($mail_server_type == 'imap/ssl'                 ? 'selected="selected"' : '');
	$tpl_mail_server_type_imap_ssl_nvc = ($mail_server_type == 'imap/ssl/novalidate-cert' ? 'selected="selected"' : '');

	$tpl_mail_server_type_pop3         = ($mail_server_type == 'pop3'                     ? 'selected="selected"' : '');
	$tpl_mail_server_type_pop3_notls   = ($mail_server_type == 'pop3/notls'               ? 'selected="selected"' : '');
	$tpl_mail_server_type_pop3_ssl     = ($mail_server_type == 'pop3/ssl'                 ? 'selected="selected"' : '');
	$tpl_mail_server_type_pop3_ssl_nvc = ($mail_server_type == 'pop3/ssl/novalidate-cert' ? 'selected="selected"' : '');

	$template = 'login.html';
	include($CONFIG['includes'].'template.wrapper.php');
?>
