
formObj = null;

/**
 * Add function to onload event.
 * Example: addEvent(window, 'load', startOnLoadFunction);
 *
 * @param el  The element
 * @param ev  Event name (load, resize, etc...)
 * @param fn  Reference to function to call.
 */
function addEvent(el, ev, fn){
	// IE
	if (window.attachEvent) {
		el.attachEvent('on' + ev, fn);
	}
	else if (el.addEventListener) {
		el.addEventListener(ev, fn, false);
	}
}

/**
* Shows a particular fieldset
*/
function showFieldset(fieldset)
{
	if (document.getElementById) {

		// Hide all fieldsets
		document.getElementById('fieldset_general').style.display   = 'none';
		document.getElementById('fieldset_servers').style.display   = 'none';
		document.getElementById('fieldset_vhosts').style.display    = 'none';
		document.getElementById('fieldset_languages').style.display = 'none';

		// Show appropriate fieldset
		document.getElementById(fieldset).style.display = 'block';

	}
}

/**
* These functions handle the servers listbox buttons
*/
function serversServerRemove_onclick()
{
}

function serversServerNew_onclick()
{
	formObj.elements['servers/server'].selectedIndex = null;

	// Clear the input elements

}

/**
* Handles when the prefs storage radios are clicked
*/
function preferencesStorage_onclick(srcObject)
{
	if (srcObject.value == 'file') {
		enablePrefsStorageDBFields(false);
	} else {
		enablePrefsStorageDBFields(true);
	}
}

/**
* Either enables the prefs storage database fields
* or disables them based on the supplied argument.
* (true for enabled, false for disabled).
*/
function enablePrefsStorageDBFields(newState)
{
	formObj.elements['general/prefs_storage/hostname'].disabled = !newState;
	formObj.elements['general/prefs_storage/username'].disabled = !newState;
	formObj.elements['general/prefs_storage/password'].disabled = !newState;
	formObj.elements['general/prefs_storage/database'].disabled = !newState;
	formObj.elements['general/prefs_storage/table'].disabled    = !newState;

	// And disable the table too to make the text look "disabled"
	document.getElementById('prefsStorageDBTable').disabled = !newState;
}

/**
* Called when selected index changes in the servers list
*/
function serversList_onchange(selectObj)
{
	// Set all the appropriate properties
	var elements      = formObj.elements;
	var serverDetails = selectObj.options[selectObj.selectedIndex].value.split(':');

	elements['servers/server/description'].value = serverDetails[0];
	elements['servers/server/hostname'].value = serverDetails[1];
	elements['servers/server/port'].value = serverDetails[2];

	// type is special
	var typeOptions = elements['servers/server/type'].options;

	for (var i=0; i<typeOptions.length; ++i) {
		if (typeOptions[i].value == serverDetails[3]) {
			elements['servers/server/type'].selectedIndex = i;
			break;
		}
	}

	elements['servers/server/domain'].value = serverDetails[4];
	elements['servers/server/extended_listing'].checked = Boolean(Number(serverDetails[5]));
	elements['servers/server/use_uids'].checked = Boolean(Number(serverDetails[6]));
	elements['servers/server/smtp/enabled'].checked = Boolean(Number(serverDetails[7]));
	elements['servers/server/smtp/hostname'].value = serverDetails[8];
	elements['servers/server/smtp/port'].value = serverDetails[9];
	elements['servers/server/smtp/helo'].value = serverDetails[10];
	elements['servers/server/smtp/authentication/enabled'].value = serverDetails[11];
	elements['servers/server/smtp/authentication/username'].value = serverDetails[12];
	elements['servers/server/smtp/authentication/password'].value = serverDetails[13];

	formObj.serversServerAdd.value = 'Update';
	formObj.serversServerRemove.disabled = false;

	// Fire the onclick event to correctly enable/disable the SMTP inputs
	serversServerUseSMTP_onclick(formObj.elements['servers/server/smtp/enabled']);
}

/**
* Called when the Add/Update button is clicked
*/
function serversServerAdd_onclick()
{
	if (formObj.serversServerAdd.value == 'Update') {
		var optionObj = formObj.elements['servers/server'].options[formObj.elements['servers/server'].selectedIndex];

		var value = [formObj.elements['servers/server/description'].value,
					 formObj.elements['servers/server/hostname'].value,
					 formObj.elements['servers/server/port'].value,
					 formObj.elements['servers/server/type'].options[formObj.elements['servers/server/type'].selectedIndex].value,
					 formObj.elements['servers/server/domain'].value,
					 formObj.elements['servers/server/extended_listing'].checked ? 1 : 0,
					 formObj.elements['servers/server/use_uids'].checked ? 1 : 0,
					 formObj.elements['servers/server/smtp/enabled'].checked ? 1 : 0,
					 formObj.elements['servers/server/smtp/hostname'].value,
					 formObj.elements['servers/server/smtp/port'].value,
					 formObj.elements['servers/server/smtp/helo'].value,
					 formObj.elements['servers/server/smtp/authentication/enabled'].checked ? 1 : 0,
					 formObj.elements['servers/server/smtp/authentication/username'].value,
					 formObj.elements['servers/server/smtp/authentication/password'].value];

		optionObj.value = value.join(':');
		optionObj.text  = value[0];

		// Clear servers input fields
		clearServersFields();

		// Unset the selected option in the list
		formObj.elements['servers/server'].selectedIndex = formObj.elements['servers/server'].options.length;

		// Set the Add/Update button to "Add"
		formObj.serversServerAdd.value = 'Add';
	}
}

/**
* Clears all the servers input fields
*/
function clearServersFields()
{
	formObj.elements['servers/server/description'].value = '';
	formObj.elements['servers/server/hostname'].value = '';
	formObj.elements['servers/server/port'].value = '143';
	formObj.elements['servers/server/type'].selectedIndex = 0
	formObj.elements['servers/server/domain'].value = '';
	formObj.elements['servers/server/extended_listing'].checked = false;
	formObj.elements['servers/server/use_uids'].checked = false;
	formObj.elements['servers/server/smtp/enabled'].checked = false;
	formObj.elements['servers/server/smtp/hostname'].value = '';
	formObj.elements['servers/server/smtp/port'].value = '25';
	formObj.elements['servers/server/smtp/helo'].value = '';
	formObj.elements['servers/server/smtp/authentication/enabled'].checked = false;
	formObj.elements['servers/server/smtp/authentication/username'].value = '';
	formObj.elements['servers/server/smtp/authentication/password'].value = '';

	// Fire the onclick event to correctly enable/disable the SMTP inputs
	serversServerUseSMTP_onclick(formObj.elements['servers/server/smtp/enabled']);
}

/**
* Handles the onclick event for the "Use SMTP" button
*/
function serversServerUseSMTP_onclick(checkboxObj)
{
	// Enable the form elements
	formObj.elements['servers/server/smtp/hostname'].disabled = !checkboxObj.checked;
	formObj.elements['servers/server/smtp/port'].disabled = !checkboxObj.checked;
	formObj.elements['servers/server/smtp/helo'].disabled = !checkboxObj.checked;
	formObj.elements['servers/server/smtp/authentication/enabled'].disabled = !checkboxObj.checked;

	// Enable the table
	document.getElementById('serversServerSMTPTable').disabled = !checkboxObj.checked
}

// Show server fieldset.
function firstStart() {

	formObj = document.forms['configForm']

	// Check which prefs storage radio button is checked and disabled
	// db fields accordingly
	if (formObj.elements['general/prefs_storage/type'][0].checked != true) {
		enablePrefsStorageDBFields(true);
	} else {
		enablePrefsStorageDBFields(false);
	}

	showFieldset('fieldset_servers');
}
