<?php
/**
* Filename.......: email.view.message.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/04 12:55:13 $
* CVS Revision...: $Revision: 1.6 $
* Copyright......: 2001-2004 Richard Heyes
*/

    include('config.php');
    include_once($CONFIG['pear_dir'] . 'Net/URL.php');

/**
** Check Login
*/
    auth::check_login('login.php', 'email.list.php');

/**
* Error msg
*/
    common::errorMsg($error_msg);

/**
** Check for message id.
*/
    if (!isset($_GET['msg_id']) OR $_GET['msg_id'] < 1) {
        common::redirect('email.list.php', lang('Error: No msg id passed to view page'));
    }

/**
** Check for mbox
*/
    if (!empty($_GET['mbox'])) {
        $SESSION['email']['mbox'] = $_GET['mbox'];
    }

/**
* Valid mailbox ?
*/
    if (!empty($_GET['mbox']) AND !$mailaccess->isValidMailbox($_GET['mbox'])) {
        common::redirect('redirect.php?to=email.list.php?mbox=INBOX', lang('Invalid mailbox name supplied'));
    }

/**
** Print view?
*/
    $printview = !empty($_GET['printview']) ? true : false;

/**
** Function makes links out of from/to/cc/bcc
** headers.
*/

    function parse_header_recipients($data, $header_name_lc, $msg_id)
    {
        global $CONFIG, $SESSION;
        include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

        if (!PEAR::isError($addresses = Mail_RFC822::parseAddressList($data, 'localhost', null, false, 50))
             && is_object($addresses[0])
             && !empty($addresses[0]->mailbox)) {

            foreach ($addresses as $address) {
                $emails = !empty($address->groupname) ? $address->addresses : array($address);
                foreach ($emails as $email) {
                    $personal = !empty($email->personal) ? $email->personal . ' <%s>' : '%s';
                    $mailbox  = !empty($email->host) ? $email->mailbox . '@' . $email->host : $email->mailbox;
        
                    $tmp = sprintf($personal, $mailbox);

                    $blockAction = in($header_name_lc, 'to', 'cc') ? 'blockrecipient' : 'blocksender';

                    $links[] = sprintf('<a href="email.compose.php?' . VWEBMAILSESSION . '&to=%s" title="%s %s">%s</a>
                                        <a href="addressbook.php?' . VWEBMAILSESSION . '&add_address=%s" title="%s">%s</a>
                                        <a href="preferences.blacklists.php?' . VWEBMAILSESSION . '&action=%s&value=%s&msg_id=%s" title="%s" %s><img src="images/v-webmail/block.gif" width="12" height="12" border="0" alt="%s" /></a>',
                                       urlencode($tmp),
                                       lang('Send mail to'),
                                       $mailbox,
                                       htmlspecialchars($tmp),
                                       urlencode($tmp),
                                       javascript::escapeString(lang('Adds this address to the addressbook')),
                                       lang('<img src="images/v-webmail/contact.gif" border="0" width="15" height="14" />'),
                                       $blockAction,
                                       urlencode($tmp),
                                       $msg_id,
                                       javascript::escapeString(lang('Adds this address to the blacklist')),
                                       'onclick="return confirm(\'' . javascript::escapeString(lang('Are you sure you wish to block this address?')) . '\')"',
                                       lang('Block this address'));

                    // If blacklists are disabled, remove the block link
                    // Todo: FIXME Shouldn't be added in the first place.
                    if (@!$GLOBALS['HOSTINFO']['allow_blacklists'] OR !$GLOBALS['mailaccess']->capabilities('folders')) {
                        $links[count($links) - 1] = preg_replace('/<a href="preferences.blacklists.php.+<\/a>/U', '', $links[count($links) - 1]);
                    }
                }
            }
        } else {
            $links[] = 'Unable to parse address list: ' . htmlspecialchars($data);
        }

        if (Mail_RFC822::approximateCount($data) > 50) {
            $links[] = ' (View all headers to see full address list)';
        }

        return implode(', ', $links);
    }

    /**
    * This function converts urls to clickable links
    */
    function convertUrls($body)
    {
        global $USERPREFS;

        if (preg_match_all('/((https?:\/\/|ftp:\/\/|news:\/\/|telnet:\/\/|mailto:)[^<>()\s]+)/i', $body, $matches)) {

            /**
            * If last char is 
            */
            $chars = array('.', ']', ',', '"');
            foreach ($matches[1] as $value) {
                if (in_array(substr($value, -1), $chars)) {
                    $value = substr($value, 0, -1);
                }
                $urls[] = $value;
            }
            $urls = array_unique($urls);

            /**
            * Sort the urls on length in descending
            * order so that urls which are seperate,
            * but also part of another greater url,
            * do not screw up.
            */
            usort($urls, create_function('$a, $b', 'return strlen($b) - strlen($a);'));

            foreach ($urls as $value) {
                $body = str_replace($value, '[link]'.md5($value).'[/link]', $body);
            }

            foreach ($urls as $value) {
                $body = str_replace(md5($value), $value, $body);
            }
        }

        $body = htmlspecialchars($body);
        $body = preg_replace('/^(&gt;.*)$/m', '<span class="quoted">\1</span>', $body);
        if (strpos($body, "\n-- ") !== false) {
            $body = preg_replace('/^--\s+$/m', '<span class="signature">-- ', $body, 1) . '</span>';
        }
        $body = preg_replace('/\[link\]mailto:(.+)\[\/link\]/U', '<a href="email.compose.php?' . VWEBMAILSESSION . '&to=\1">mailto:\1</a>', $body);
        $body = preg_replace('/\[link\](.+)\[\/link\]/U', '<a href="\1" target="_blank">\1</a>', $body);

        return $body;
    }

    /**
    * Remove unsafe tags from html
    */
    function stripUnsafeTags($body)
    {
        global $HOSTINFO;

        if (@$HOSTINFO['strip_unsafe_tags']) {
            $body = preg_replace('/<style[^>]*>.*<\/style>/Usi', '<pre><-- Removed STYLE section --></pre>', $body);
            $body = preg_replace('/<script[^>]*>.*<\/script>/Usi', '<pre><-- Removed SCRIPT section --></pre>', $body);
            $body = preg_replace('/<embed[^>]*>.*<\/embed>/Usi', '<pre><-- Removed EMBED section --></pre>', $body);
            $body = preg_replace('/<iframe[^>]*>.*<\/iframe>/Usi', '<pre><-- Removed IFRAME section --></pre>', $body);
            $body = preg_replace('/<meta[^>]*>/Usi', '<pre><-- Removed META tag --></pre>', $body);
            $body = preg_replace('/<object[^>]*>.*<\/object>/Usi', '<pre><-- Removed OBJECT section --></pre>', $body);
        }

        // Strip external images
        if (@$HOSTINFO['remove_external_images']) {
            $body = preg_replace('/<img[^>]*src="?((http|ftp):\/\/.+)"?[^>]*>/Usi', '<pre><-- Removed external image --></pre>', $body);
            $body = preg_replace('/(<[^>]+)background="?((http|ftp):\/\/.+)"?(>|( [^>]*>))/Usi', '\1 !REMOVED_BG_IMAGE \4', $body);
        }
        
        return $body;
    }
    
    /**
    * This function sends a MDN when called
    */
    function sendMDN($recipient, $parsedHeaders)
    {
        global $CONFIG, $HOSTINFO, $USERPREFS, $SESSION;

        $subject = strlen($parsedHeaders['subject']) > 60 ? substr($parsedHeaders['subject'], 0, 60) . '...' : $parsedHeaders['subject'];
        $from    = $parsedHeaders['from'];
        $final_r = Mail_RFC822::parseAddressList($parsedHeaders['to'], $_SERVER['SERVER_NAME'], false, false);
        
        if (is_array($final_r) AND is_object($final_r[0])) {
            $final_r = $final_r[0]->mailbox . '@' . $final_r[0]->host;
        } else {
            $final_r = 'unknown@' . $_SERVER['SERVER_NAME'];
        }

        $body = '--=_01234567890123456789' . "\r\n" .
                'Content-Type: text/plain'  . "\r\n" . "\r\n" .

                'Your message:'  . "\r\n" .
                '    From.....: ' . $from . "\r\n" .
                '    Subject..: ' . $subject . "\r\n" .
                ' was read on ' . date('d/m/Y') . ' at ' . date('H:i') . "\r\n" .
                '--=_01234567890123456789' . "\r\n" .
                'Content-Type: message/disposition-notification' . "\r\n" . "\r\n" .

                'Reporting-UA: ' . $_SERVER['SERVER_NAME'] . '; ' . $CONFIG['app_name'] . ' ' . $CONFIG['app_ver'] . "\r\n" .
                'Final-Recipient: rfc822;' . $final_r . "\r\n" .
                (!empty($parsedHeaders['message-id']) ? 'Original-Message-Id: ' . $parsedHeaders['message-id'] . "\r\n" : '') .
                'Disposition: automatic-action/MDN-sent-automatically; displayed' . "\r\n" .
                '--=_01234567890123456789--';

        $headers[] = 'From: ' . $USERPREFS['settings']['email_address'];
        $headers[] = 'Content-Type: multipart/report; boundary="=_01234567890123456789"; report-type=disposition-notification';
        $headers[] = 'Mime-Version: 1.0';

        /**
        * Determine the method we're using to send the mdn
        */
        if (!empty($SESSION['email']['smtp_srvr'])){

            include_once($CONFIG['includes'] . 'smtp.php');

            $params['host'] = $SESSION['email']['smtp_srvr'];
            $params['port'] = $SESSION['email']['smtp_port'];
            $params['helo'] = $SESSION['email']['smtp_helo'];
            $params['auth'] = $SESSION['email']['smtp_auth'];
            $params['user'] = $SESSION['email']['smtp_user'];
            $params['pass'] = $SESSION['email']['smtp_pass'];

            $smtp = &smtp::connect($params);
            if($smtp->status !== SMTP_STATUS_CONNECTED){
                return false;
            }

            $headers[] = 'To: ' . $recipient;
            $headers[] = 'Subject: Read: ' . $subject;

            $send_params['from']         = '';
            $send_params['recipients'][] = $recipient;
            $send_params['headers']      = $headers;
            $send_params['body']         = $body;

            $result = $smtp->send($send_params);

        } else {

            // Send
            $result = mail($recipient, 'Read: ' . $subject, $body, implode("\r\n", $headers));
        }
        
        if (@$result) {
            $USERPREFS['sent_mdn'][] = $parsedHeaders['message-id'];
            savePrefs();
        }
    }

/**
** Remove cached summary information
*/
    mailaccess::cacheRemove($_GET['msg_id'] . ':' . $SESSION['email']['mbox']);

/**
** Determine if we're supposed to be showing
** an attached message.
*/
    if (isset($_GET['attached'])) {
        if (!isset($_GET['encoding'])) $error = true;
        if (!isset($_GET['msg_id']))   $error = true;
        if (!isset($_GET['mime_id']))  $error = true;
    
        if (@$error === true) {
            die('Incorrect arguments passed');
        }

        $attached_msg = true;
        $mime_id      = $_GET['mime_id'];
        $msg_id       = $_GET['msg_id'];
        $encoding     = $_GET['encoding'];

    } else {

        $attached_msg = false;
        $mime_id      = null;
        $msg_id       = $_GET['msg_id'];
        $encoding     = null;
    }

/**
** Get details of the message.
*/
    if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

        /**
        * Check the message exists
        */
        if (!@$mailaccess->headerinfo($msg_id)) {
            common::redirect('email.list.php', lang('No such msg'));
        }

        /**
        * Decode the email
        */
        $structure    = $mailaccess->fetchStructure($msg_id);
        $mime_numbers = &$mailaccess->assignMimeNumbers($structure);

        if ($attached_msg) {
            $structure = $mime_numbers[$mime_id]->parts[0];
        }
        $message       = &$mailaccess->parseStructure($structure, new stdClass);
        $parsedheaders = $mailaccess->getParsedHeaders($msg_id, $mime_id);

        if (isset($_GET['show_all_headers']) AND $_GET['show_all_headers'] == 1) {

            /**
            ** Show all headers
            */
            foreach ($parsedheaders as $header_name => $header_value) {
                $name = str_replace('-', ' ', $header_name);
                $name = ucwords($name);
                $name = str_replace(' ', '-', $name);

                $header_value = (array)$header_value;
                for ($i=0; $i<count($header_value); $i++) {
                    $headers[] = array('name' => lang($name) ? lang($name) : $name,
                                       'data' => htmlspecialchars(decode_header($header_value[$i]))
                                      );
                }
            }

        } else {

            /**
            ** Show normal headers
            */
            $headerinfo = $mailaccess->getMsgSummary($msg_id);
            foreach (array('Date', 'From', 'To', 'Cc', 'Subject', 'Importance', 'Sensitivity') as $header_name) {

                $header_name_lc = strtolower($header_name);

                if (!empty($parsedheaders[$header_name_lc])) {

                    $parsedheaders[$header_name_lc] = is_array($parsedheaders[$header_name_lc]) ? implode(', ', $parsedheaders[$header_name_lc]) : $parsedheaders[$header_name_lc];
                    $header_value = decode_header($parsedheaders[$header_name_lc]);

                    if ('Sensitivity' == $header_name) {
                        $tpl_sensitive = true;

                        switch (strtolower($header_value)) {
                            case 'normal':
                                continue;
                                break;

                            case 'personal':
                                $header_value = lang('Personal');
                                break;

                            case 'private':
                                $header_value = lang('Private');
                                break;

                            case 'company-confidential':
                                $header_value = lang('Confidential');
                                break;
                            default:

                        }
                    }

                    // Normal Importance - skip
                    if ('Importance' == $header_name AND 'normal' == strtolower($parsedheaders[$header_name_lc])) {
                        continue;
                    } elseif ('Importance' == $header_name) {
                        switch (strtolower($header_value)) {
                            case 'low':
                                $header_value = lang('Low');
                                break;

                            case 'high':
                                $header_value = lang('High');
                                break;
                        }
                    }

                    if (in_array($header_name_lc, array('to', 'cc', 'from'))) {
                        $header_value = parse_header_recipients($header_value, $header_name_lc, $msg_id);

                    } elseif ('date' == $header_name_lc) {
                        $headers[] = array('name' => lang('Date'), 'data' => $headerinfo['date']);
                        continue;

                    } elseif ('subject' == $header_name_lc) {
                        if ($HOSTINFO['allow_blacklists'] AND $mailaccess->capabilities('folders')) {
                            $data = htmlspecialchars($header_value) . ' <a href="preferences.blacklists.php?' . VWEBMAILSESSION . '&action=blocksubject&value=' . urlencode($header_value) . '" title="' . javascript::escapeString(lang('Adds this subject to the blacklist')) . '" onclick="return confirm(\'' . javascript::escapeString(lang('Are you sure you wish to block this subject?')) . '\')"><img src="images/v-webmail/block.gif" width="12" height="12" border="0" alt="' . lang('Block this subject') . '" /></a>';
                        } else {
                            $data = htmlspecialchars($header_value);
                        }

                        $headers[] = array('name' => lang('Subject'), 'data' => $data);
                        continue;
                    
                    } else {
                        $header_value = htmlspecialchars($header_value);
                    }
                    // lang('From')
                    // lang('To')
                    // lang('Sensitivity')
                    // lang('Received')
                    // lang('X-Mailer')
                    // lang('Reply-To')
                    // lang('Date')
                    // lang('Importance')
                    $headers[] = array('name' => lang($header_name) ? lang($header_name) : $header_name, 'data' => $header_value);

                } elseif ($header_name_lc == 'subject') {
                    $headers[] = array('name' => lang('Subject') ? lang('Subject') : $header_name, 'data' => lang('[no subject]'));
                }
            }
        }

        /**
        ** List headers ?
        */

        // List-Post
        if (!empty($parsedheaders['list-post']) AND preg_match('/<mailto:(.*)>/Ui', $parsedheaders['list-post'])) {
            $tpl_list_reply = true;
        }

        // List-Unsubscribe
        if (!empty($parsedheaders['list-unsubscribe']) AND preg_match('/<mailto:(.*)>/Ui', $parsedheaders['list-unsubscribe'])) {
            $tpl_list_reply_mailto = true;
        } elseif (!empty($parsedheaders['list-unsubscribe']) AND preg_match('/<http:\/\/(.*)>/Ui', $parsedheaders['list-unsubscribe'], $matches)) {
            $tpl_list_reply_http      = true;
            $tpl_list_reply_http_link = 'http://' . $matches[1];
        }

        /**
        * Message Disposition Notification
        */
        if (@$USERPREFS['settings']['send_mdns']
            AND !empty($parsedheaders['disposition-notification-to'])
            AND !empty($parsedheaders['message-id'])
            AND !in_array($parsedheaders['message-id'], @(array)$USERPREFS['sent_mdn'])) {

            include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

            $mdnRecipient = Mail_RFC822::parseAddressList($parsedheaders['disposition-notification-to']);

            if (is_array($mdnRecipient) AND is_object($mdnRecipient[0])) {
                sendMDN($mdnRecipient[0]->mailbox . '@' . $mdnRecipient[0]->host, $parsedheaders);
            }
        }


/**
* Populate the $message from $structure
*/
        /**
        * If there is html present then check
        * for any related items and process
        * accordingly.
        */
        $html = !empty($message->body_html);
        $text = !empty($message->body_plain);

        $showHtml = (($USERPREFS['settings']['show_html'] OR @$_GET['showHtml']) AND @$HOSTINFO['allow_html_email'] AND @!$_GET['showText']);
        $htmlLink = ($html AND !$showHtml AND @$HOSTINFO['allow_html_email'] AND @!$_GET['showHtml']);
        $textLink = ($showHtml AND $html);
        $textHtmlLink = new Net_URL();
        $textHtmlLink->removeQueryString('showHtml');
        $textHtmlLink->removeQueryString('showText');
        $textHtmlLink = $textHtmlLink->getURL();
        

        if ($showHtml AND $html) {
            if (!empty($message->related)) {
                // Replace the cid:'s with a link to email.view.related.php
                for ($i=0; $i<count($message->related); $i++) {
                    $related = $message->related[$i];
                    $link    = sprintf('./email.view.related.php?%s&encoding=%s&msg_id=%s&mime_id=%s&size=%s&c_type=%s',
                                        VWEBMAILSESSION,
                                        $related['encoding'],
                                        $msg_id,
                                        $related['mime_id'],
                                        $related['size'],
                                        urlencode($related['c_type'])
                                        );
                    $message->body_html = preg_replace('#cid:' . $related['c_id'] . '#i',  $link, $message->body_html);
                }
            }

            // Find the body tag, take the attributes from it and then remove it.
            if (preg_match('/<body([^>]*)>/i', $message->body_html, $matches)) {

                $attributes = implode(' ', preg_split('/\s+/', trim($matches[1])));

                // Check for external background images
                if ($HOSTINFO['remove_external_images'] AND preg_match('/background="?(?:http|ftp):\/\//i', $attributes)) {
                    $attributes = preg_replace('/background="?[^\s]+/si', '', $attributes);
                }

                // Check for background color attribute
                if (preg_match('/bgcolor="?(([^\s"]|[a-z0-9#])+)/i', $attributes, $bgcolorMatches)) {
                    $styleBgcolor = 'style="background-color: ' . $bgcolorMatches[1] . '"';
                }

                $start_pos = strpos($message->body_html, $matches[0])+strlen($matches[0]);
                $end_pos   = strpos(strtolower($message->body_html), '</body');

                $message->body_html = substr($message->body_html,$start_pos, $end_pos-$start_pos);
            }

        }

        /**
        ** Determine which to print, html or text.
        */
        switch (true) {
            case ($html AND $showHtml):
                require_once($CONFIG['includes'] . 'HTML_Safe.php');
                $parser =& new HTML_Safe();
                $body   =  wordwrap($message->body_html, 80, "\r\n", 1);
                $body   =  $parser->parse($body);
                break;

            case ($html AND !$text):
                $body      = preg_replace('/<br>/i', "\r\n", $message->body_html);
                $body      = strip_tags($body);
                $body      = wordwrap($body, 80, "\r\n", 1);
                $pre_start = '<pre>';
                $pre_end   = '</pre>';
                $body      = convertUrls($body); // htmlspecialchars() done here
                break;

            case $text:
                $body      = wordwrap($message->body_plain, 80, "\r\n", 1);
                $pre_start = '<pre>';
                $pre_end   = '</pre>';
                $body      = convertUrls($body); // htmlspecialchars() done here
                break;

            default:
                $body = '&nbsp;';
        }

        if(trim($body) == ''){
            $body = '&nbsp;';
        }



        /**
        * HANDLE ATTACHMENTS
        */
        // Combine embedded objects with attachments if no html
        if (!$showHtml AND !empty($message->related) AND !empty($message->attachments)) {
            $message->attachments = array_merge($message->attachments, $message->related);
        
        } else if(!$showHtml AND !empty($message->related)) {
            $message->attachments = $message->related;
        }

        if (!$printview AND !empty($message->attachments)) {
            foreach ($message->attachments as $i => $attachment) {

                /**
                * Filename
                */
                if (isset($attachment['description']))    $filename = $attachment['description'];
                if (isset($attachment['name']))           $filename = $attachment['name'];
                if (isset($attachment['filename']))       $filename = $attachment['filename'];
                if (!isset($filename) OR $filename == '') $filename = lang('Unknown');
                
                /**
                * Filesize.
                */
                if ($attachment['size'] > 1048576) {
                    $size = round($attachment['size'] / 1048576.0, 1) . 'Mb';

                } elseif ($attachment['size'] > 1024) {
                    $size = round($attachment['size'] / 1024.0, 1) . 'Kb';

                } else {
                    $size = $attachment['size'] . 'b';
                }

                /**
                * Determine links href and onlick attribs
                */
                // Default download and "view as text" links
                $dl_link   = sprintf('<a href="email.attachment.php?%s&encoding=%s&msg_id=%s&mime_id=%s&size=%s&c_type=%s&filename=%s&action=dl">%s</a>',
                                     VWEBMAILSESSION,
                                     $attachment['encoding'],
                                     $msg_id,
                                     $attachment['mime_id'],
                                     $attachment['size'],
                                     urlencode($attachment['c_type']),
                                     urlencode($filename),
                                     lang('Download'));

                $text_link = sprintf('<a href="#" onclick="window.open(\'email.attachment.php?%s&encoding=%s&msg_id=%s&mime_id=%s&size=%s&c_type=%s&filename=%s&action=view\', \'%s\', \'menubar,scrollbars,resizable,width=696,height=500\'); return false">%s</a>',
                                     VWEBMAILSESSION,
                                     $attachment['encoding'],
                                     $msg_id,
                                     $attachment['mime_id'],
                                     $attachment['size'],
                                     urlencode('text/plain'),
                                     urlencode($filename . '.txt'), // Try to force it to be shown as text
                                     md5(microtime()),
                                     lang('View as text'));

                switch (true) {
                    // Opens using email.view.message.php in a new window
                    case $attachment['c_type'] == 'message/rfc822':
                        // Suppress showing message/rfc822
                        $attachment['c_type'] = '';
                        $attachment_headers = $mailaccess->getParsedHeaders($msg_id, $attachment['mime_id']);
                        $filename .= ': <i>(' . (!empty($attachment_headers['subject']) ? $attachment_headers['subject'] : lang('[no subject]')) . ')</i>';
                        $view_link = sprintf('<a href="#" onclick="window.open(\'email.view.message.php?%s&action=view&attached=1&encoding=%s&msg_id=%s&mime_id=%s\', \'%s\', \'menubar,scrollbars,resizable,width=696,height=500\'); return false">%s</a>',
                                             VWEBMAILSESSION,
                                             $attachment['encoding'],
                                             $msg_id,
                                             $attachment['mime_id'],
                                             md5(microtime()),
                                             lang('View'));
                        $dl_link   = '';
                        break;

                    // View link has hard coded text/plain content type
                    case $attachment['c_type'] == 'text/rfc822-headers':
                    case $attachment['c_type'] == 'message/delivery-status':
                    case $attachment['c_type'] == 'message/disposition-notification':
                        $view_link = sprintf('<a href="#" onclick="window.open(\'email.attachment.php?%s&encoding=%s&msg_id=%s&mime_id=%s&c_type=text/plain&size=%s&filename=%s&action=view\', \'%s\', \'menubar,scrollbars,resizable,width=696,height=500\')">%s</a>',
                                             VWEBMAILSESSION,
                                             $attachment['encoding'],
                                             $msg_id,
                                             $attachment['mime_id'],
                                             $attachment['size'],
                                             urlencode($filename),
                                             md5(microtime()),
                                             lang('View'));
                        break;

                    // Special V-webmail exported addressbook attachment
                    case $attachment['c_type'] == 'application/vnd.v-webmail.addressbook':
                        $dl_link   = '';
                        $text_link = '';
                        $attachment['c_type'] = ''; // Make this blank so it doesn't appear on view page
                        $filename = 'V-webmail Addressbook';
                        $view_link = sprintf('<a href="addressbook.import.php?%s&action=process_import&type=attachment&msg_id=%s&mime_id=%s&encoding=%s&ctype=%s">%s</a>',
                                             VWEBMAILSESSION,
                                             $msg_id,
                                             $attachment['mime_id'],
                                             $attachment['encoding'],
                                             urlencode('application/vnd.v-webmail.addressbook'),
                                             lang('Import'));
                        break;

                    // vCard attachment
                    case $attachment['c_type'] == 'text/x-vcard':
                        $dl_link   = '';
                        $view_link = sprintf('<a href="addressbook.import.php?%s&action=process_import&type=attachment&msg_id=%s&mime_id=%s&encoding=%s&ctype=%s">%s</a>',
                                             VWEBMAILSESSION,
                                             $msg_id,
                                             $attachment['mime_id'],
                                             $attachment['encoding'],
                                             urlencode($attachment['c_type']),
                                             lang('Add to addressbook'));
                        $attachment['c_type'] = '';
                        break;

                    // View link opens in new window
                    case substr($attachment['c_type'], 0, 5) == 'image':
                    case substr($attachment['c_type'], 0, 4) == 'text':
                    case $attachment['c_type'] == 'application/x-shockwave-flash':
                        $view_link = sprintf('<a href="#" onclick="window.open(\'email.attachment.php?%s&encoding=%s&msg_id=%s&mime_id=%s&size=%s&c_type=%s&filename=%s&action=view\', \'%s\', \'menubar,scrollbars,resizable,width=696,height=500\')">%s</a>',
                                             VWEBMAILSESSION,
                                             $attachment['encoding'],
                                             $msg_id,
                                             $attachment['mime_id'],
                                             $attachment['size'],
                                             urlencode($attachment['c_type']),
                                             urlencode($filename),
                                             md5(microtime()),
                                             lang('View'));
                        break;

                    // Up to the client as to what happens with view link.
                    default:
                        $view_link = sprintf('<a href="email.attachment.php?%s&encoding=%s&msg_id=%s&mime_id=%s&size=%s&c_type=%s&filename=%s&action=view">%s</a>',
                                             VWEBMAILSESSION,
                                             $attachment['encoding'],
                                             $msg_id,
                                             $attachment['mime_id'],
                                             $attachment['size'],
                                             urlencode($attachment['c_type']),
                                             urlencode($filename),
                                             lang('View'));
                        break;
                }

                /**
                * Create data for template subloop
                */
                $attachments[] = array(
                                        'filename'	=> $filename,
                                        'c_type'	=> $attachment['c_type'],
                                        'text_link' => $text_link,
                                        'view_link'	=> $view_link,
                                        'dl_link'	=> $dl_link,
                                        'size'		=> $size
                                      );
            } // End foreach

            $headers[] = array('name'			=> lang('Attachments'),
                               'data'			=> '',
                               'attachments'	=> $attachments
                              );
        }


/**
* Connection to server failed.
*/

    }else{
        $logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
        die(lang('Failed to connect to account!'));
    }


/**
* This determines the next and previous
* message numbers for the links.
*/

    if (!empty($_GET['message_ids_idx'])) {
        $message_ids_idx = $_GET['message_ids_idx'];
    } else {
        for ($i=0; $i<count($SESSION['email']['message_ids']); $i++) {
            if (!empty($_GET['mbox']) AND $SESSION['email']['message_ids'][$i]['mailbox'] == $_GET['mbox'] AND $SESSION['email']['message_ids'][$i]['msg_id'] == $_GET['msg_id']) {
                $message_ids_idx = $i;
                break;
            } elseif ($SESSION['email']['message_ids'][$i]['mailbox'] == $SESSION['email']['mbox'] AND $SESSION['email']['message_ids'][$i]['msg_id'] == $_GET['msg_id']) {
                $message_ids_idx = $i;
                break;
            }
        }
        if (!isset($message_ids_idx)) {
            $message_ids_idx = 0;
        }
    }

    $back_link_message_ids_idx = !empty($SESSION['email']['message_ids'][$message_ids_idx - 1]) ? $message_ids_idx - 1 : '';
    $next_link_message_ids_idx = !empty($SESSION['email']['message_ids'][$message_ids_idx + 1]) ? $message_ids_idx + 1 : '';

    $back_link_msg_id = !empty($SESSION['email']['message_ids'][$message_ids_idx - 1]) ? $SESSION['email']['message_ids'][$message_ids_idx - 1]['msg_id'] : '';
    $next_link_msg_id = !empty($SESSION['email']['message_ids'][$message_ids_idx + 1]) ? $SESSION['email']['message_ids'][$message_ids_idx + 1]['msg_id'] : '';

    $back_link_mbox = !empty($SESSION['email']['message_ids'][$message_ids_idx - 1]) ? urlencode($SESSION['email']['message_ids'][$message_ids_idx - 1]['mailbox']) : '';
    $next_link_mbox = !empty($SESSION['email']['message_ids'][$message_ids_idx + 1]) ? urlencode($SESSION['email']['message_ids'][$message_ids_idx + 1]['mailbox']) : '';

/**
* Template vars
*/
    if (isset($headers['subject'])) {
        $tpl_title  = 'Message: '.$headers['subject'];
    }
    $tpl_mbox     = $SESSION['email']['mbox'];
    $tpl_mbox_url = urlencode($SESSION['email']['mbox']);
    $tpl_mime_id  = $mime_id;
    $tpl_msg_id   = $msg_id;

    $url = new Net_URL();

    if (@$url->querystring['show_all_headers']) {
        $tpl_all_hdrs = $url->getURL();
    } else {
        $url->addQueryString('show_all_headers', '1');
        $tpl_all_hdrs = $url->getURL();
    }
    
    $url->removeQueryString('show_all_headers');
    $tpl_nor_hdrs = $url->getURL();

/**
* Template stuff.
*/
    $template = 'email.view.message.html';
    include($CONFIG['includes'].'template.wrapper.php');
?>
