<?php
/**
* Filename.......: email.search.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Check Login
*/
	auth::check_login('login.php', 'email.search.php');

/*
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Form submitted?
*/
	$received_on     = false;
	$received_before = false;
	$received_since  = false;

	if (!empty($_POST)) {

		if (!empty($_POST['from']))    $criteria[] = 'from';
		if (!empty($_POST['to']))      $criteria[] = 'to';
		if (!empty($_POST['cc']))      $criteria[] = 'cc';
		if (!empty($_POST['subject'])) $criteria[] = 'subject';
		if (!empty($_POST['body']))    $criteria[] = 'body';

		if (!empty($_POST['received_on_year']) OR !empty($_POST['received_on_month']) OR !empty($_POST['received_on_day'])) $received_on = true;
		if (!empty($_POST['received_before_year']) OR !empty($_POST['received_before_month']) OR !empty($_POST['received_before_day'])) $received_before = true;
		if (!empty($_POST['received_since_year']) OR !empty($_POST['received_since_month']) OR !empty($_POST['received_since_day'])) $received_since = true;

		if ($received_on)     $criteria[] = 'received_on';
		if ($received_before) $criteria[] = 'received_before';
		if ($received_since)  $criteria[] = 'received_since';

		if (!empty($_POST['folders'])) {
			$folders = $_POST['folders'];

			// Check folders are valid
			foreach ($folders as $folder) {
				if (!$mailaccess->isValidMailbox($folder)) {
					common::redirect('redirect.php?to=email.search.php', lang('Invalid mailbox name supplied'));
				}
			}
		} else {
			$folders[] = 'INBOX';
		}
// Potential OR code:
//		if(!empty($_POST['match']))   $match = ($_POST['match'] == 'any' ? 'any' : 'all'); else $match = 'all';

		/**
        * Finished checking input, build search string
        */
		
		for ($i=0; $i<count(@$criteria); $i++) {
			switch ($criteria[$i]) {
				case 'from':
				case 'to':
				case 'cc':
				case 'subject':
				case 'body':
					$string = strtr($_POST[$criteria[$i]], array('"' => '\"', '\\' => '\\\\'));
					$search_string[] = strtoupper($criteria[$i]) . ' "' . $string . '"';
					break;

				case 'received_on':
				case 'received_before':
				case 'received_since':
					$keyword = substr($criteria[$i], strrpos($criteria[$i], '_') + 1);
					$year    = !empty($_POST['received_' . $keyword . '_year'])  ? $_POST['received_' . $keyword . '_year'] : date('Y');
					$month   = !empty($_POST['received_' . $keyword . '_month']) ? date('M', mktime(0,0,0,$_POST['received_' . $keyword . '_month'],1,date('Y'))) : date('M');
					$date    = !empty($_POST['received_' . $keyword . '_day'])  ? $_POST['received_' . $keyword . '_day'] : '1';

					$search_string[] = strtoupper($keyword) . ' ' . $date . '-' . $month . '-' . $year;
					break;
			}
		}
		$SESSION['search']['string']   = implode(' ', $search_string);
		$SESSION['search']['folders']  = $folders;
		$SESSION['email']['start_msg'] = 1;

		/**
        * Redirect
        */
		common::redirect('email.list.php?sm=1');
	}

/**
* Form not submitted...
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		if ($mailaccess->capabilities('folders')) {

			list ($folders, $folderTree) = $mailaccess->getSubscribedFolders();
			for ($i=0; $i<count($folders); $i++) {
				// If folder supplied on querystring, highlight that
				if (!empty($_GET['mbox'])) {
					if (strcasecmp($folders[$i]['name'], @$_GET['mbox']) == 0) {
						$folders[$i]['selected'] = 'selected="selected"';
					} else {
						$folders[$i]['selected'] = '';
					}
				// Otherwise highlight the inbox
				} else {
					if (strcasecmp($folders[$i]['name'], 'INBOX') == 0) {
						$folders[$i]['selected'] = 'selected="selected"';
					} else {
						$folders[$i]['selected'] = '';
					}
				}
			}
		}
	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
	}

/**
* Template
*/
	for ($i = 0; $i < 31; null) {
		$date_select[$i] = array('date' => ++$i, 'selected' => '');
	}
	array_unshift($date_select, array('date' => ''));

	$template = 'email.search.html';
	include($CONFIG['includes'] . 'template.wrapper.php');
?>