<?php
/**
* Filename.......: email.reply.redirect.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/06 09:48:21 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Login check
*/
	auth::check_login('login.php', 'email.list.php');

/**
* Some functions specific to this script
*/

	/**
    * Returns the body for a reply-to,
	* reply-to-all and forward
    */

	function _get_body($strip_sig = true)
	{
		global $CONFIG, $USERPREFS, $message, $SESSION, $parsedheaders;

		// return value as HTML?
		$html = false;
		$htmlEditor = !isset($SESSION['email_compose']['htmlEditor']) ? @($USERPREFS['settings']['defaultEditor'] == 'html') : $SESSION['email_compose']['htmlEditor'];
		if (!empty($htmlEditor)) {
        	$html = true;
        }

		if (!empty($message->body_plain)) {
			$body = $message->body_plain;
		} elseif(!empty($message->body_html)) {
			$body = strip_tags($message->body_html);
		}

		// Snip anything after a sigsep
		$body = preg_replace('/^((.*)\r?\n)?-- \r?\n.*$/Us', '\2', $body);

		// Prefix text with >
		$body = preg_replace('/^(.)/m', $USERPREFS['settings']['reply_indent_char'] . ' \1', wordwrap($body, 80));

		// Parse From: header
		if (!empty($parsedheaders['from'])) {
			include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');
			$from_addresses = Mail_RFC822::parseAddressList($parsedheaders['from'], $SESSION['email']['smtp_helo'], null, null, 50);
	
			// Add xxx quoted...
			if (count($from_addresses) > 1) {
				$personal = !empty($from_addresses[0]->personal) ? '"'.$from_addresses[0]->personal.'" ' : '';
				$quote = $personal.'<'.$from_addresses[0]->mailbox.'@'.$from_addresses[0]->host.'>';
			} else {
				$quote = $parsedheaders['from'];
			}
		} else {
			$quote = '';
		}
		
		$body = $quote . ' ' . lang('wrote:') . "\r\n\r\n" . $body;

		// Replace invalid characters by html entities and newlines by HTML breaks.
        if ($html) {
        	$body = htmlspecialchars($body);
        	// Don't lose the newlines, that's why we don't use PHP's nl2br function.
			$body = preg_replace('/(\r?\n)/', '<br />\1', $body);
		}

		return $body;
	}

	/**
    * Returns list-post address (from List-Post:
	* header).
    */
	function _get_list_post()
	{
		global $parsedheaders;

		if (!empty($parsedheaders['list-post']) AND preg_match('/^<mailto:(.*)>/Ui', $parsedheaders['list-post'], $matches)) {
			$ret = $matches[1];
		} else {
			$ret = _get_to();
		}
		
		return $ret;
	}

	/**
    * Returns Subject, Body and unsubscribe
	* address based on List-Unsubscribe header
    */
	function  _get_list_unsubscribe()
	{
		global $CONFIG, $parsedheaders;

		if (!empty($parsedheaders['list-unsubscribe']) AND preg_match('/^<(mailto:.*)>/Ui', $parsedheaders['list-unsubscribe'], $matches)) {
			include_once($CONFIG['pear_dir'] . 'Net/URL.php');
			$url = &new Net_URL($matches[1]);

			$email   = $url->path;
			$subject = !empty($url->querystring['subject']) ? $url->querystring['subject'] : 'UNSUBSCRIBE';
			$body    = !empty($url->querystring['body'])    ? $url->querystring['body']    : 'UNSUBSCRIBE';

		} else {
			$email   = _get_to();
			$subject = 'UNSUBSCRIBE';
			$body    = 'UNSUBSCRIBE';
		}
		
		return array($email, $subject, $body);
	}

	/**
    * Returns a To: header for reply-to and
	* reply-to-all
    */
	function _get_to($reply_all = FALSE)
	{
		global $CONFIG, $SESSION, $USERPREFS, $parsedheaders;

		include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

		$email_address = isset($USERPREFS['settings']['email_address']) ? $USERPREFS['settings']['email_address'] : $SESSION['email']['user'].'@'.$SESSION['email']['srvr'];
		$email_address = Mail_RFC822::parseAddressList($email_address, $SESSION['email']['srvr'], null, null, 50);
		$email_address = $email_address[0];

		$from_header = isset($parsedheaders['from']) ? $parsedheaders['from'] : '';
		$from_addresses = Mail_RFC822::parseAddressList($from_header, $SESSION['email']['smtp_helo'], null, null, 50);

		if (isset($parsedheaders['reply-to'])) {
			$to[] = $parsedheaders['reply-to'];
	
		} elseif (count($from_addresses) > 1 AND isset($parsedheaders['sender']) AND !$reply_all) {
			$to[] = $parsedheaders['sender'];
	
		} elseif (count($from_addresses) > 1) {
			if (!$reply_all) {
				if (preg_match('/^".+"$/', $to_addresses[$i]->personal)) {
					$to_addresses[$i]->personal = substr($to_addresses[$i]->personal, 1, -1);
				}
				$personal = !empty($from_addresses[0]->personal) ? '"'.$from_addresses[0]->personal.'" ' : '';
				$to[]     = $personal.'<'.$from_addresses[0]->mailbox.'@'.$from_addresses[0]->host.'>';
			} else {
				for ($i=0, $cnt = count($from_addresses); $i<$cnt; $i++) {
					if (preg_match('/^".+"$/', $to_addresses[$i]->personal)) {
						$to_addresses[$i]->personal = substr($to_addresses[$i]->personal, 1, -1);
					}
					$personal = !empty($from_addresses[$i]->personal) ? '"'.$from_addresses[$i]->personal.'" ' : '';
					$to[]     = sprintf('%s<%s@%s>', $personal, $from_addresses[$i]->mailbox, $from_addresses[$i]->host);
				}
			}

		} else {
			if (!$reply_all) {
				$to[] = $from_header;
			} else {
				$to[] = $from_header;
			}
		}

		if ($reply_all) {
			if (isset($parsedheaders['to'])) {

				$to_addresses = Mail_RFC822::parseAddressList($parsedheaders['to'], $SESSION['email']['smtp_helo'], null, null, 50);

				for ($i=0, $cnt = count($to_addresses); $i<$cnt; $i++) {
					if ($to_addresses[$i]->mailbox.'@'.$to_addresses[$i]->host == $email_address) {
						continue;
					}
					if (preg_match('/^".+"$/', $to_addresses[$i]->personal)) {
						$to_addresses[$i]->personal = substr($to_addresses[$i]->personal, 1, -1);
					}
					$personal = !empty($to_addresses[$i]->personal) ? '"'.$to_addresses[$i]->personal.'" ' : '';
					$to[]     = $personal.'<'.$to_addresses[$i]->mailbox.'@'.$to_addresses[$i]->host.'>';		
				}
			}
		}

		return implode(', ', $to);
	}

	/**
    * Returns the Cc: header for reply-to-all
    */
	function _get_cc()
	{
		global $CONFIG, $SESSION, $parsedheaders;

		if (!empty($parsedheaders['cc'])) {
			include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');
			$cc_addresses = Mail_RFC822::parseAddressList($parsedheaders['cc'], $SESSION['email']['smtp_helo'], null, null, 50);
			for ($i=0, $cnt = count($cc_addresses); $i<$cnt; $i++) {
				if (preg_match('/^".+"$/', $cc_addresses[$i]->personal)) {
					$cc_addresses[$i]->personal = substr($cc_addresses[$i]->personal, 1, -1);
				}
				$personal = !empty($cc_addresses[$i]->personal) ? '"'.$cc_addresses[$i]->personal.'" ' : '';
				$cc[]     = $personal.'<'.$cc_addresses[$i]->mailbox.'@'.$cc_addresses[$i]->host.'>';		
			}

			return implode(', ', $cc);
		}
	}

	/*
    * Returns the Subejct: header for a
	* reply-to, reply-to-all, or forward
    */
	function _get_subject($pretext = 'Re: ')
	{
		global $parsedheaders;

		$subject = isset($parsedheaders['subject']) ? $parsedheaders['subject'] : '';

		// Stip Re: or Fw: or Aw:
		while (preg_match('/^\s*(re:|aw:|fw:)\s*/i', $subject)) {
			$subject = preg_replace('/^\s*(re:|aw:|fw:)\s*/i', '', $subject);
		}

		$subject = $pretext . $subject;
		return $subject;
	}

	/*
    * Returns some headers gotten from the
	* mail we're replying to. Namely,
	* In-Reply-To: and References:
    */
	function _get_headers()
	{
		global $parsedheaders;

		$headers = array();
		if (isset($parsedheaders['message-id'])) {
			$message_id = $parsedheaders['message-id'];
			$headers['In-Reply-To'] = $message_id;
			$headers['References']  = isset($parsedheaders['references']) ? rtrim($parsedheaders['references']).' '.$parsedheaders['message-id'] : $message_id;
		}

		return $headers;
	}
	
	/**
    * Returns attachments details. Attachment data will
	* already have been written to a file.
    */
	function _get_attachments()
	{
		global $message, $CONFIG, $msg_id, $mailaccess;
		$files = array();

		if (!empty($message->attachments)) {
			foreach ($message->attachments as $attachment) {
				if (!empty($attachment['description'])) {
					$desc = $attachment['description'];

				} elseif (!empty($attachment['filename'])) {
					$desc = $attachment['filename'];

				} elseif (!empty($attachment['name'])) {
					$desc = $attachment['name'];

				} else {
					$desc = 'Uknown';
				}
				$filename = File::getTempFile($CONFIG['tmp_dir']);
				if ($bytes = File::write($filename, decode_body($mailaccess->getPart($msg_id, $attachment['mime_id']), $attachment['encoding'])) ) {
					$files[] = array(
									 'tmp_name' => $filename,
									 'size'     => $bytes,
									 'c_type'   => $attachment['c_type'],
									 'filename' => $desc,
									 'encoding' => $attachment['encoding']
									);
				}
			}
		}
		
		return $files;
	}


/*
* Check for required inputs
*/
	$error = false;
	if (empty($_GET['action'])) {
		$error = true;
		$error_msg = lang('Invalid or no action supplied');
	}

	if (empty($_GET['msg_id'])) {
		$error = true;
		$error_msg = lang('Invalid or no msg_id supplied');
	}

/*
* Perform an action if no error
*/
	if (!$error) {

		$msg_id  = $_GET['msg_id'];
		$mime_id = isset($_GET['mime_id']) ? $_GET['mime_id'] : null;
		$folder  = !empty($_GET['mbox']) ? $_GET['mbox'] : $SESSION['email']['mbox'];

		/*
		* Get details of the message.
		*/
		if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $folder)) {

			$structure    = $mailaccess->fetchStructure($msg_id);
			$mime_numbers = &$mailaccess->assignMimeNumbers($structure);
	
			if (!empty($mime_id)) {
				$structure = $mime_numbers[$mime_id]->parts[0];
			}

			$message       = $mailaccess->parseStructure($structure, new stdClass);
			$parsedheaders = $mailaccess->getParsedHeaders($msg_id, $mime_id, true);

			if ($_GET['action'] !== 'forward-attach') {

				// Ensure To and Cc are not arrays:
				if (@is_array($parsedheaders['to'])) {
					$parsedheaders['to'] = implode(', ', $parsedheaders['to']);
				}

				if (@is_array($parsedheaders['cc'])) {
					$parsedheaders['cc'] = implode(', ', $parsedheaders['cc']);
				}
			}

			
			/*
            * Which action to perform?
            */
			$redirect_to = 'email.compose.php';
			$headers = $mailaccess->headerinfo($msg_id);

			switch ($_GET['action']) {
		
				case 'reply':
					$SESSION['email_compose']['headers']  = _get_headers();
					$SESSION['email_compose']['subject']  = _get_subject();
					$SESSION['email_compose']['to']       = _get_to();
					$SESSION['email_compose']['text']     = _get_body();
					$SESSION['email_compose']['is_reply'] = array('msg_id' => $msg_id, 'folder' => $folder);
					break;

				case 'reply-all':
					$SESSION['email_compose']['headers']  = _get_headers();
					$SESSION['email_compose']['subject']  = _get_subject();
					$SESSION['email_compose']['to']       = _get_to(true);
					$SESSION['email_compose']['cc']       = _get_cc();
					$SESSION['email_compose']['text']     = _get_body();
					$SESSION['email_compose']['is_reply'] = array('msg_id' => $msg_id, 'folder' => $folder);
					break;

				case 'reply-list':
					$SESSION['email_compose']['headers']  = _get_headers();
					$SESSION['email_compose']['subject']  = _get_subject();
					$SESSION['email_compose']['to']       = _get_list_post();
					$SESSION['email_compose']['text']     = _get_body();
					$SESSION['email_compose']['is_reply'] = array('msg_id' => $msg_id, 'folder' => $folder);
					break;

				case 'unsubscribe':
					list($to, $subject, $body) = _get_list_unsubscribe();
					$SESSION['email_compose']['to']      = $to;
					$SESSION['email_compose']['subject'] = $subject;
					$SESSION['email_compose']['text']    = $body;
					break;

				case 'forward':
					include_once($CONFIG['pear_dir'] . 'File.php');
					$SESSION['email_compose']['subject']    = _get_subject('Fw: ');
					$SESSION['email_compose']['text']       = _get_body(FALSE);
					$SESSION['email_compose']['files']      = _get_attachments();
					$SESSION['email_compose']['is_forward'] = array('msg_id' => $msg_id, 'folder' => $folder);
					break;

				case 'forward-attach':
					$email = $mailaccess->getEntireMail($msg_id, $mime_id);

					// Write email to tmp file
					include_once($CONFIG['pear_dir'] . 'File.php');
					$filename = File::getTempFile($CONFIG['tmp_dir']);
					if (File::write($filename, $email)) {

						$SESSION['email_compose']['subject'] = _get_subject('Fw: ');
						$SESSION['email_compose']['files'][] = array(
																		'tmp_name' => $filename,
																		'size'     => strlen($email),
																		'c_type'   => 'message/rfc822',
																		'filename' => 'Attached message',
																		'encoding' => '7bit'
																	);
					}
					// FIXME Error msg?
					break;

				case 'opendraft':
					include_once($CONFIG['pear_dir'] . 'File.php');

					$SESSION['email_compose']['signature_appended'] = true;
					$SESSION['email_compose']['is_draft'] = array('msg_id' => $msg_id, 'mbox' => @$_GET['mbox']);
					$SESSION['email_compose']['subject']  = @$parsedheaders['subject'];
					$SESSION['email_compose']['from']     = @$parsedheaders['from'];
					$SESSION['email_compose']['replyto']  = @$parsedheaders['reply-to'];
					$SESSION['email_compose']['to']       = @$parsedheaders['to'];
					$SESSION['email_compose']['cc']       = @$parsedheaders['cc'];
					$SESSION['email_compose']['text']     = !empty($message->body_plain) ? $message->body_plain : strip_tags($message->body_html);
					$SESSION['email_compose']['identity'] = @$parsedheaders['x-vwebmail-identity'];
					$SESSION['email_compose']['files']    = _get_attachments();
					break;

				default:
					$redirect_to = 'email.list.php';
					$SESSION['common']['error_msg'] = lang('Invalid or no action supplied');
					break;
			}

		/*
        * Connection mail server failed
        */
		} else {
			$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
			$SESSION['common']['error_msg'] = lang('Error: Could not connect to email server');
			$redirect_to = 'email.list.php';
		}

	} else {

		$redirect_to = 'email.list.php';
		$SESSION['common']['error_msg'] = $error_msg;
	}

/*
* Redirect
*/
	common::redirect($redirect_to);
?>