<?php
/**
* Filename.......: email.poll.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Is access allowed ?
*/
	if (@!$HOSTINFO['allow_fetchmail']) {
		$logger->log(sprintf('User (%s) tried to access email.poll.php when access not permitted, from: (%s)', $SESSION['email']['user'], common::getClientIP()), PEAR_LOG_WARNING);
		die('Access not permitted');
	}

/**
* Form submitted, lets poll...
*/
	if (!empty($_POST)) {
		if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {
			foreach (@(array)$_POST['accounts'] as $account_id) {
				$account = $USERPREFS['mail_accounts'][$account_id];
	
				$remote_account = mailaccess::factory('imapext');
				if (@$remote_account->connect($account['server'], $account['username'], base64_decode($account['password']), $account['port'], $account['type'], $account['folder'])) {
	
					$msg_ids = $remote_account->getMsgIds(SORTDATE, 0, 1, 0, 'ALL', &$num_msgs);
					if (!empty($msg_ids)) {
						$appended = 0;
						for ($i=0; $i<count($msg_ids); $i++) {
							$message = $remote_account->getEntireMail($msg_ids[$i]);
							if ($mailaccess->append($message, $account['deliver_to'])) {
								$appended++;
								if (!$account['leave_on_server']) {
									$remote_account->delete($msg_ids[$i], $error_msg, true);
								}
							}
						}
						$results[$account['name']] = $appended . ' ' . lang('message(s) downloaded');
					} else {
						$results[$account['name']] = lang('No messages!');
					}
				} else {
					$results[$account['name']] = lang('Failed to connect to account!');
				}
			}
		} else {
			$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
			$results[lang('Local account')] = lang('Failed to connect to account!');
		}
	}

/**
* Template
*/
	// Friendly name for the accounts
	$noAccounts = !(bool)count($USERPREFS['mail_accounts']);
	$accounts   = $USERPREFS['mail_accounts'];

	$template = 'email.poll.html';
	include($CONFIG['includes'] . 'template.wrapper.php')
?>