<?php
/**
 * Filename.......: email.list.php
 * Project........: V-webmail
 * Last Modified..: $Date: 2006/02/26 19:49:42 $
 * CVS Revision...: $Revision: 1.3 $
 * Copyright......: 2001-2004 Richard Heyes
 */

	include('config.php');

/*
 * Check Login
 */
	auth::check_login('login.php', 'email.list.php');

/*
 * Get the order_by and ascdesc variables
 * either from the query string or session
 * or defaults.
 */
	if (isset($_GET['order_by'])) {
		$SESSION['email']['order_by'] = $_GET['order_by'];
		$order_by = $_GET['order_by'];

	} else if (isset($SESSION['email']['order_by'])) {
		$order_by = $SESSION['email']['order_by'];

	} else {
		$SESSION['email']['order_by'] = 'arrival';
		$order_by = 'arrival';
	}

	if (isset($_GET['ascdesc'])) {
		$SESSION['email']['ascdesc'] = $_GET['ascdesc'];
		$ascdesc = $_GET['ascdesc'];

	} else if (isset($SESSION['email']['ascdesc'])) {
		$ascdesc = $SESSION['email']['ascdesc'];

	} else {
		$SESSION['email']['ascdesc'] = 1;
		$ascdesc = 1;
	}
	
/*
 * If the start point is to be altered
 * then set that up.
 */

	if(isset($_GET['sm'])){
		$SESSION['email']['start_msg'] =& $_GET['sm'];
		if((int)$SESSION['email']['start_msg'] < 1)
			$SESSION['email']['start_msg'] = 1;
	}

/*
 * Change of folder?
 */

	if(isset($_GET['mbox']) AND !empty($_GET['mbox'])){
		$SESSION['email']['mbox'] = $_GET['mbox'];
		$SESSION['email']['start_msg'] = 1;

		if (isset($SESSION['search'])) {
			unset($SESSION['search']);
		}

		if (isset($SESSION['quicksearch'])) {
			unset($SESSION['quicksearch']);
		}
	}

/*
 * Remove any error message from the
 * session and set the error_msg var for
 * the template.
 */

	common::errorMsg($error_msg);

/*
 * Read the session variables if we need to.
 */

	if(isset($SESSION['email']['start_msg'])) $start_msg = $SESSION['email']['start_msg'];

	if(!isset($show_per_page)) $show_per_page = max($USERPREFS['settings']['show_per_page'], 5);
	if(!isset($start_msg))     $start_msg     = 1;

	$SESSION['email']['start_msg'] = $start_msg;


/*
 * If we're supposed to clear the cache,
 * do that and redirect back to the list
 */

	if(!empty($_GET['clear_cache'])){
		mailaccess::cacheClear();
		common::redirect('redirect.php?to=email.list.php');
	}

/**
 * Valid mailbox ?
 */
	if (!empty($_GET['mbox']) AND !$mailaccess->isValidMailbox($_GET['mbox'])) {
		common::redirect('redirect.php?to=email.list.php?mbox=INBOX', lang('Invalid mailbox name supplied'));
	}

/*
 * List the current mailbox or search ?
 */
    if (!empty($SESSION['quicksearch'])) {
		$SESSION['search'] = array();
		include($CONFIG['includes'] . 'email.list.quicksearch.php');

	} else if(!empty($SESSION['search'])){
		include($CONFIG['includes'] . 'email.list.search.php');

	} else {
		include($CONFIG['includes'] . 'email.list.normal.php');
	}

/*
 * Template stuff. Sets up variables and
 * calls the tpl engine.
 */

	/*
     * Autorefresh?
     */
	if (!@$tpl_is_search AND @$USERPREFS['settings']['autorefresh_list'] > 0) {
		header('Refresh: ' . $USERPREFS['settings']['autorefresh_list']);
	}

	/*
	 * Back and next links and Message numbers
	 * that appear at top.
	 */
	$msg_start_num = $start_msg;
	$msg_end_num   =  min($start_msg + $show_per_page -  1, $num_msgs);
	$total_msgs    = $num_msgs;
	$total_pages   = ceil($total_msgs/$show_per_page);

	// Create page links
	if ($total_pages > 1) {
		// Create page links
		for ($i=1; $i<=$total_pages; $i++) {
			$sm              = (($i - 1) * $show_per_page) + 1;
			$startMessages[] = $sm;
			$page_links[$i]    = sprintf('<a href="email.list.php?sm=%s">%s</a>', $sm, $i);
		}
		
		// Limit to 10 page numbers shown if there are more
		$currentPage = floor(($start_msg - 1) / $show_per_page) + 1;
		if ($total_pages > 9) {
			$page_links = array_slice($page_links, max(0, $currentPage - 6), 10);
		}

		// Previous page link
		if ($currentPage > 1) {
			array_unshift($page_links, '<a href="email.list.php?sm=' . ((($currentPage - 2) * $show_per_page) + 1) . '">&lt;&lt;</a>');
		}

		// Next page link
		if ($currentPage < $total_pages) {
			$page_links[] = '<a href="email.list.php?sm=' . (($currentPage * $show_per_page) + 1) . '">&gt;&gt;</a>';
		}

		$page_links = '(' . implode(' ', $page_links) . ' ) <a href="javascript: void(pageJump())">' . lang('Jump to page...') . '</a>';

	} else {
		$page_links = '';
	}

	// Create next link
	if ($msg_end_num < $total_msgs) {
		$next_link = '<nobr><a href="email.list.php?' . VWEBMAILSESSION . '&sm='.($start_msg+$show_per_page).'">'.lang('Next').'<img src="images/v-webmail/tri.gif" alt="&gt;&gt;" align="center" width="10" height="10" border="0" /></a></nobr>';
	} else {
		$next_link = '';
	}

	// Create back link
	if ($msg_start_num > 1 AND $num_msgs > 0) {
		$sm = max($msg_start_num - $show_per_page, 1);
		$back_link = '<nobr><a href="email.list.php?' . VWEBMAILSESSION . '&sm='.$sm.'"><img src="images/v-webmail/tri-back.gif" alt="&lt;&lt;" align="center" width="10" height="10" border="0" />'.lang('Back').' </a></nobr>';
	} else {
		$back_link = '';
	}

	/*
	 * If there are no messages, reset the
	 * start number.
	 */
	if ($num_msgs == 0) {
		$msg_start_num = 0;
	}

	/**
	 * Create sort links
	 */
	$baseSortURL   = common::url('email.list.php?' . VWEBMAILSESSION);
	$sortImageAsc  = '<img src="images/v-webmail/orderbyasc.gif" width="12" height="12" border="0" />';
	$sortImageDesc = '<img src="images/v-webmail/orderbydesc.gif" width="12" height="12" border="0" />';

	$sortFromLink     = "$baseSortURL&order_by=from&ascdesc=1";
	$sortSubjectLink  = "$baseSortURL&order_by=subject&ascdesc=1";
	$sortToLink       = "$baseSortURL&order_by=to&ascdesc=1";
	$sortSizeLink     = "$baseSortURL&order_by=size&ascdesc=1";
	$sortDateLink     = "$baseSortURL&order_by=date&ascdesc=1";

	$sortFromImage    = '';
	$sortSubjectImage = '';
	$sortToImage      = '';
	$sortSizeImage    = '';
	$sortDateImage    = '';

	switch ($order_by) {
		case 'from':
			$sortFromImage = $ascdesc ? $sortImageDesc : $sortImageAsc;

			if ($ascdesc == 1) {
				$sortFromLink = "$baseSortURL&order_by=from&ascdesc=0";
			}
			break;

		case 'subject':
			$sortSubjectImage = $ascdesc ? $sortImageDesc : $sortImageAsc;

			if ($ascdesc == 1) {
				$sortSubjectLink = "$baseSortURL&order_by=subject&ascdesc=0";
			}
			break;

		case 'to':
			$sortToImage = $ascdesc ? $sortImageDesc : $sortImageAsc;

			if ($ascdesc == 1) {
				$sortToLink = "$baseSortURL&order_by=to&ascdesc=0";
			}
			break;

		case 'size':
			$sortSizeImage = $ascdesc ? $sortImageDesc : $sortImageAsc;

			if ($ascdesc == 1) {
				$sortSizeLink = "$baseSortURL&order_by=size&ascdesc=0";
			}
			break;

		case 'date':
			$sortDateImage = $ascdesc ? $sortImageDesc : $sortImageAsc;

			if ($ascdesc == 1) {
				$sortDateLink = "$baseSortURL&order_by=date&ascdesc=0";
			}
			break;
	}

/*
 * Some template stuff
 */
	$template = 'email.list.html';
	include($CONFIG['includes'].'template.wrapper.php');

?>
