<?php
/*
* Filename.......: email.folders.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/26 14:10:01 $
* CVS Revision...: $Revision: 1.4 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* This script also handles the left frame
* folder listing by passing the GET variable
* folder_frame=1
*/

	include('config.php');

/*
* Logged in?
*/
	auth::check_login('login.php', 'email.folders.php');

/*
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Awful hack to prevent code repetition
* and enable POST and GET queries, (GET
* queries coming from the left folder frame
* context menu stuff).
*/
	if (empty($_POST['action']) AND !empty($_GET['action']) AND !empty($_GET['folder_frame'])) {
		$_POST = $_GET;
	}

/*
* Connect to retreive folder list
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		if ($mailaccess->capabilities('folders')) {

			switch (@$_POST['action']) {

				case 'create':
					if (!empty($_POST['create_folder_name']) AND $mailaccess->isValidMailbox($SESSION['email']['fold'] . $_POST['create_folder_name'])) {

						$mailaccess->createFolder($SESSION['email']['fold'].$_POST['create_folder_name']);
						if (@$USERPREFS['settings']['auto_subscribe_new']) {
							$mailaccess->subscribeFolder($SESSION['email']['fold'].$_POST['create_folder_name']);
						}
					} else {
						common::redirect('redirect.php?to=email.folders.php', lang('Invalid mailbox name supplied'));
					}
					common::redirect('redirect.php?to=email.folders.php');
					break;

				case 'createsubfolder':
					$message  = null;
					$redirect = !empty($_GET['folder_frame']) ? urlencode('email.folders.php?folder_frame=1') : 'email.folders.php';

					if (!empty($_POST['createsubfolder_parent'])
					      AND !empty($_POST['createsubfolder_child'])
						  AND $mailaccess->isValidMailbox($_POST['createsubfolder_parent']) // Already has folder prefix
						  AND $mailaccess->isValidMailbox($SESSION['email']['fold'] . $_POST['createsubfolder_child'])) {

						$result = $mailaccess->createSubFolder($_POST['createsubfolder_parent'], $_POST['createsubfolder_child']);
						if ($result AND @$USERPREFS['settings']['auto_subscribe_new']) {
							$mailaccess->subscribeFolder($result);
						} else {
							$logger->log(sprintf('Failed to create subfolder: (%s)', $mailaccess->getErrors()), LOG_ERR);
							$message = lang('Failed to create new subfolder') . ' ' . $mailaccess->getErrors();
						}
					} else {
						common::redirect('redirect.php?to=' . $redirect, lang('Invalid mailbox name supplied'));
					}
					common::redirect('redirect.php?to=' . $redirect, $message);
					break;

				case 'delete':
					$message  = null;
					$redirect = !empty($_GET['folder_frame']) ? urlencode('email.folders.php?folder_frame=1') : 'email.folders.php';

					if (!empty($_POST['delete_folder'])
					      AND strcasecmp($_POST['delete_folder'], 'INBOX') != 0
						  AND $mailaccess->isValidMailbox($_POST['delete_folder'])) {

						$mailaccess->unsubscribeFolder($_POST['delete_folder']);
						if (!$mailaccess->deleteFolder($_POST['delete_folder'])) {
							$logger->log(sprintf('Failed to delete folder: (%s)', $mailaccess->getErrors()), LOG_ERR);
							$message = lang('Failed to delete folder') . ' ' . $mailaccess->getErrors();
						}
					} else {
						common::redirect('redirect.php?to=' . $redirect, lang('Invalid mailbox name supplied'));
					}

					common::redirect('redirect.php?to=' . $redirect, $message);
					break;

				case 'empty':
					$message  = null;
					$redirect = !empty($_GET['folder_frame']) ? urlencode('email.folders.php?folder_frame=1') : 'email.folders.php';

					if (!empty($_POST['empty_folder']) AND $mailaccess->isValidMailbox($_POST['empty_folder'])) {

						$count = $mailaccess->emptyFolder($_POST['empty_folder']);
						if ($count === false) {
							$logger->log(sprintf('Failed to empty folder: (%s)', $mailaccess->getErrors()), LOG_ERR);
							$message = lang('Failed to empty folder') . ' ' . $mailaccess->getErrors();
						} else {
							$message = $count . lang(' message(s) deleted');
						}
					} else {
						common::redirect('redirect.php?to=' . $redirect, lang('Invalid mailbox name supplied'));
					}

					common::redirect('redirect.php?to=' . $redirect, $message);
					break;

				case 'rename':
					$message  = null;
					$redirect = !empty($_GET['folder_frame']) ? urlencode('email.folders.php?folder_frame=1') : 'email.folders.php';

					if (!empty($_POST['rename_folder_from'])
					      AND !empty($_POST['rename_folder_to'])
						  AND strcasecmp($_POST['rename_folder_to'], 'INBOX') != 0
						  AND $mailaccess->isValidMailbox($_POST['rename_folder_from'])
						  AND $mailaccess->isValidMailbox($SESSION['email']['fold'] . $_POST['rename_folder_to'])) {

						$result = $mailaccess->renameFolder($_POST['rename_folder_from'], $SESSION['email']['fold'].$_POST['rename_folder_to']);
						$mailaccess->unsubscribeFolder($_POST['rename_folder_from']);
						if (!$result) {
							$logger->log(sprintf('Failed to rename folder: (%s)', $mailaccess->getErrors()), LOG_ERR);
							$message = lang('Failed to rename folder') . ' ' . $mailaccess->getErrors();
						}
					} else {
						common::redirect('redirect.php?to=' . $redirect, lang('Invalid mailbox name supplied'));
					}

					common::redirect('redirect.php?to=' . $redirect, $message);
					break;

				case 'markallread':
				case 'markallunread':
					$message = null;
					if (!empty($_POST['mbox']) AND $mailaccess->isValidMailbox($_POST['mbox'])) {
						$mailaccess->reconnect($_GET['mbox']);
						$mailaccess->setFlag('1:*', $_POST['action'] == 'markallread' ? 'read' : 'unread');
						common::redirect('email.folders.php?folder_frame=1');
					} else {
						common::redirect('email.folders.php?folder_frame=1', lang('Invalid mailbox name supplied'));
					}
					break;

				case 'save':

					// Unsubscribe from all folders
					list($all_folders, ) = $mailaccess->getAllFolders();
					foreach($all_folders as $folder){
						if($folder['noselect'] != TRUE){
							$mailaccess->unsubscribeFolder($folder['name']);
						}
					}

					// Subscribe to selected folders
					if (isset($_POST['subs_folders']) AND is_array($_POST['subs_folders'])) {
						foreach($_POST['subs_folders'] as $folder){
							if ($mailaccess->isValidMailbox($folder)) {
								$mailaccess->subscribeFolder($folder);
							} else {
								common::redirect('redirect.php?to=email.folders.php', lang('Invalid mailbox name supplied'));
							}
						}
					}
					common::redirect('redirect.php?to=email.folders.php');
					break;


				// Display folder list
				default:

					$mailaccess->checkKeyFolders();
					// Whether to get folder stats
					$stats  = (bool)(@$USERPREFS['settings']['show_folder_stats'] AND empty($_GET['folder_frame']));
					$unseen = !empty($_GET['folder_frame']);

					list($subscribed_folders, $folderTree_subscribed) = $mailaccess->getSubscribedFolders($stats, true, $unseen);
					$folderTree_subscribed_pres = new HTML_TreeMenu_DHTML($folderTree_subscribed, array('images' => 'images/TreeMenu', 'linkTarget' => 'main'));

					// Don't do this if we're showing left folder list
					if (empty($_GET['folder_frame'])) {

						list($all_folders, $folderTree) = $mailaccess->getAllFolders($stats);

						// Create list of subscribed folders usable with in_array()
						$subscribed_folders_flat = array();
						foreach ($subscribed_folders as $value) {
							if ($value['noselect'] != true) {
								$subscribed_folders_flat[] = $value['name'];
							}
						}

						$mailbox_totals['messages'] = 0;
						$mailbox_totals['unseen']   = 0;
						$mailbox_totals['size']     = 0;

						// Create the subs_folders array
						for ($i=0; $i<count($all_folders); $i++) {
							if ($stats) {
								$mailbox_totals['messages'] += $all_folders[$i]['messages'];
								$mailbox_totals['unseen']   += $all_folders[$i]['unseen'];
								$mailbox_totals['size']     += $all_folders[$i]['bytes'];
							}
							unset($arr);

							// Subs array
							$arr = $all_folders[$i];
							$arr['checked']  = in_array($all_folders[$i]['name'], $subscribed_folders_flat) ? 'checked' : '';
							/*
							// todo: what does this do?
							if ($all_folders[$i]['noselect'] === true) {
								$arr['image']    = '<img src="images/v-webmail/folder-icon.gif">';
								$arr['input']    = '';
								$arr['link']     = $arr['text'];
							} else {
							*/
								$arr['image']    = '';
								$arr['input']    = '<input type="checkbox" name="subs_folders[]" value="'.$arr['name_htmlsafe'].'" id="'.$arr['name_htmlsafe'].'" '.$arr['checked'].'>';
								$arr['link']     = '<a href="email.list.php?' . VWEBMAILSESSION . '&mbox=' . $arr['name_urlsafe'] . '&sm=1">' . $arr['text'] . '</A>';
								$arr['messages'] = $all_folders[$i]['messages'];
								$arr['unseen']   = $all_folders[$i]['unseen'];

							$arr['rename_prompt'] = htmlspecialchars(str_replace($SESSION['email']['fold'], '', $arr['name']));
	
							$subs_folders[] = $arr;
						}
						
						if ($mailbox_totals['size'] > 1048576) {
							$mailbox_totals['size'] = sprintf('%.2fMb', $mailbox_totals['size'] / 1048576.0);
						} elseif ($mailbox_totals['size'] > 1024) {
							$mailbox_totals['size'] = sprintf('%.1fKb', $mailbox_totals['size'] / 1024.0);
						} else {
							$mailbox_totals['size'] = sprintf('%.0fb', $mailbox_totals['size']);
						}
					} // End conditional for folder_frame
			} //End switch
		} else {
			common::redirect('index.php', lang('This account type does not support folders'));
		}

	/*
    * Connect() failed
    */
	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}

/*
* Template stuff
*/
	/**
    * If this is left folder frame, need to checke the autohide setting
    */
	if (!empty($_GET['folder_frame'])) {
		$autohide_checked = @$USERPREFS['settings']['use_autohide'] ? 'checked="checked"' : '';
	}

	/**
    * Autorefresh if:
	*  1. Extended stats are off
	*  2. C-client version is 2001+
	*  3. We're actually showing the left folder frame
    */
	if (!$stats AND $unseen AND $CONFIG['c-client'] >= 2001 AND @$USERPREFS['settings']['autorefresh_list']) {
		header('Refresh: ' . (int)$USERPREFS['settings']['autorefresh_list']);
	}
	
	$template = !empty($_GET['folder_frame']) ? 'folder.frame.html' : 'email.folders.html';
	include($CONFIG['includes'].'template.wrapper.php');
?>
