<?php
/**
* Filename.......: email.compose.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/25 17:12:14 $
* CVS Revision...: $Revision: 1.10 $
* Copyright......: 2001-2004 Richard Heyes
*/

    include('config.php');

/**
* Check Login
*/
    auth::check_login('login.php', 'email.compose.php'.(isset($_GET['to']) ? '?to='.$_GET['to'] : ''));

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
    common::errorMsg($error_msg);

/**
* Get the to: address from the query
* string if present.
*/
    if (!empty($_GET['to'])) {
        $SESSION['email_compose']['to'] = $_GET['to'];
    }

/**
* Get the desired group from query
* string if present
*/
    if (!empty($_GET['group'])) {
        $ab = new addressbook();
        if (!empty($ab->groups[$_GET['group']])) {

        	$addresses = array();
            foreach ($ab->getGroupMembers($_GET['group']) as $address) {
                $addresses[] = $address['text'];
            }
            $SESSION['email_compose']['to'] = implode(', ', $addresses);
            unset($addresses);
            unset($address);
            unset($ab);

        /**
        * Special group, All addresses
        */
        } elseif (@$_GET['group'] == lang('All addresses')) {

            $addresses = array();
            $all_addresses = $ab->getAllAddresses();
            foreach ($all_addresses as $address) {
                $addresses[] = $address['text'];
            }

            $SESSION['email_compose']['to'] = implode(', ', $addresses);
            unset($all_addresses);
            unset($addresses);
            unset($address);
        }
    }

/**
* Some functions specific to composing.
*/
    function store_input()
    {
        global $SESSION, $HOSTINFO, $USERPREFS;
        
        if (!$HOSTINFO['allow_changeable_email']) {
            $_POST['from']    = !empty($USERPREFS['settings']['name']) ? sprintf('"%s" <%s>', $USERPREFS['settings']['name'], $USERPREFS['settings']['email_address']) : $USERPREFS['settings']['email_address'];
        }

        $SESSION['email_compose']['from']     = $_POST['from'];
        $SESSION['email_compose']['replyto']  = $_POST['replyto'];
        $SESSION['email_compose']['to']       = $_POST['to'];
        $SESSION['email_compose']['cc']       = $_POST['cc'];
        $SESSION['email_compose']['bcc']      = $_POST['bcc'];
        $SESSION['email_compose']['subject']  = $_POST['subject'];
        $SESSION['email_compose']['text']     = $_POST['text'];
        $SESSION['email_compose']['identity'] = @$_POST['identity'];
    }

    function validate_address($input)
    {
        global $SESSION;

        // If blank, don't bother parsing
        if($input === ''){
            $return[0]->personal = '';
            $return[0]->comment  = array();
            $return[0]->mailbox  = '';
            $return[0]->host     = $SESSION['email']['srvr'];
            return $return;
        }

        $addresses = Mail_RFC822::parseAddressList($input, $SESSION['email']['srvr'], null, false);
		return (is_array($addresses) AND count($addresses) > 0 AND is_object($addresses[0])) ? $addresses : FALSE;
    }

    /**
    * Removes an old draft copy
    */
    function removeOldDraft($msgDetails)
    {
        global $mailaccess;

        if (!$mailaccess->isConnected()) {
            $mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $msgDetails['mbox']);
        } else {
            $mailaccess->reconnect($msgDetails['mbox']);
        }
        
        $mailaccess->delete($msgDetails['msg_id'], $message);
    }

    /**
    * Adds a X-Originating-IP header
    */
    function addIPHeader(&$mimeObj)
    {
        global $_SERVER;

        !empty($_SERVER['REMOTE_ADDR'])          ? $ips[] = $_SERVER['REMOTE_ADDR'] : null;
        !empty($_SERVER['HTTP_X_FORWARDED_FOR']) ? $ips[] = $_SERVER['HTTP_X_FORWARDED_FOR'] : null;
        !empty($_SERVER['CLIENT_IP'])            ? $ips[] = $_SERVER['CLIENT_IP'] : null;

        $mimeObj->setHeader('X-Originating-IP', '['.implode('], [', $ips).']');
    }

    /**
    * This function sorts out actual addresses from Mail_RFC822 output
    */
    function get_addresses($input)
    {
        $addresses = array();

        foreach ($input as $value) {
            if (is_object($value)) {
                if (isset($value->groupname)) {
                    $addresses = array_merge($addresses, get_addresses($value->addresses));
                } else {
                	if (!empty($value->personal)) {
                		$addresses[] = sprintf('%s <%s@%s>', $value->personal, $value->mailbox, $value->host);
                	} else {
                    	$addresses[] = sprintf('%s@%s', $value->mailbox, $value->host);
                    }
                }
            }
        }

        return $addresses;
    }

/**
* Form submitted?
*/

    /**
    * Canceled.
    */
    if (isset($_POST['action']) AND $_POST['action'] == 'cancel') {

        // FIXME Delete any attachments
        unset($SESSION['email_compose']);
        common::redirect('redirect.php?to=email.list.php');

    /**
    * Send message OR save draft
    */	
    } elseif (isset($_POST['action']) AND ($_POST['action'] == 'send' OR $_POST['action'] == 'save_draft')) {

        $error = false;
        $tmp   = &$SESSION['email_compose']['errors'];

        if (empty($_POST['from'])) {
            $error = true;
            $tmp['from'] = lang('Please enter a from address');
        }

        store_input();

        /**
        * Validate email addresses
        */
        include_once($CONFIG['pear_dir'] . 'Mail/RFC822.php');

        if (!($from_addresses    = validate_address($_POST['from'])))    { $error = true; $tmp['from']    = lang('Please enter a valid From: address');}
        if (!($replyto_addresses = validate_address($_POST['replyto']))) { $error = true; $tmp['replyto'] = lang('Please enter a valid Reply-To: address');}
        if (!($to_addresses      = validate_address($_POST['to'])))      { $error = true; $tmp['to']      = lang('Please enter a valid To: address');}
        if (!($cc_addresses      = validate_address($_POST['cc'])))      { $error = true; $tmp['cc']      = lang('Please enter a valid Cc: address');}
        if (!($bcc_addresses     = validate_address($_POST['bcc'])))     { $error = true; $tmp['bcc']     = lang('Please enter a valid Bcc: address');}

        unset($tmp); // This is a reference - unsetting will not lose the errors!

        /**
        * Must have at least one of to/cc/bcc
        */
        if (empty($_POST['to']) AND empty($_POST['cc']) AND empty($_POST['bcc']) AND $_POST['action'] != 'save_draft') {
            $error = true;
            $SESSION['common']['error_msg'] = lang('You must enter one or more recipients');
        }

        /**
        * No errors? Send the mail
        */
        if ($_POST['action'] == 'save_draft' OR $error === false) {

            /**
            * Include the object scripts, set them
            * up and send them.
            */
            include_once($CONFIG['includes'] . 'htmlMimeMail.php');
            $mimeObj =  new htmlMimeMail();

            if ($_POST['action'] != 'save_draft' AND !empty($SESSION['email']['smtp_srvr'])) {

                $params['host'] = $SESSION['email']['smtp_srvr'];
                $params['port'] = $SESSION['email']['smtp_port'];
                $params['helo'] = $SESSION['email']['smtp_helo'];
                $params['auth'] = $SESSION['email']['smtp_auth'];
                $params['user'] = $SESSION['email']['smtp_user'];
                $params['pass'] = base64_decode($SESSION['email']['smtp_pass']);

                $mimeObj->setSMTPParams($params['host'], $params['port'], $params['helo'], $params['auth'], $params['user'], $params['pass']);
                $mimeObj->setCrlf("\r\n");
            }

            $mimeObj->setCrlf("\n");

            /**
            * Set the X-Mailer header
            */
            if (!empty($HOSTINFO['x_mailer'])) {
                $xMailer = $HOSTINFO['x_mailer'];
            } else {
                $xMailer = sprintf('%s %s ( http://www.v-webmail.org/ )', $CONFIG['app_name'], $CONFIG['app_ver']);
            }
            $mimeObj->setHeader('X-Mailer', $xMailer);

            /**
            * Sort out the email addresses, headers
            */

            /**
            * Merge any existing headers into headers
            * This should be here so that they're overridden
            */
            if (!empty($SESSION['email_compose']['headers'])) {
                // Order of merge is important for Draft headers to be correctly overridden
                foreach ($SESSION['email_compose']['headers'] as $k => $v) {
                    $mimeObj->setHeader($k, $v);
                }
            }

            // Do we need a Sender: header?
            $_from_addresses = get_addresses($from_addresses);
            if (count($_from_addresses) > 1) {
                $mimeObj->setHeader('Sender', $_from_addresses[0]);
            }

            // Add the headers
            $mimeObj->setHeader('Date', date('r'));
            $mimeObj->setFrom($_POST['from']);

            if (!empty($_POST['cc'])) {
                $mimeObj->setCc($_POST['cc']);
            }

            if (!empty($_POST['bcc'])) {
                $mimeObj->setBcc($_POST['bcc']);
            }

            $mimeObj->setSubject($_POST['subject']);

            // Reply-To header?
            if (!empty($_POST['replyto'])) {
                $mimeObj->setHeader('Reply-To', $_POST['replyto']);
            }

            // Priority header
            switch (@$SESSION['email_compose']['priority']) {
                case 'low':
                    $mimeObj->setHeader('Importance', 'Low');
                    $mimeObj->setHeader('X-Priority', '5 (Lowest)');
                    break;

                case 'high':
                    $mimeObj->setHeader('Importance', 'High');
                    $mimeObj->setHeader('X-Priority', '1 (Highest)');
                    break;
            }

            // Sensitivity header
            switch (@$SESSION['email_compose']['sensitivity']) {
                case 'personal':
                    $mimeObj->setHeader('Sensitivity', 'Personal');
                    break;

                case 'private':
                    $mimeObj->setHeader('Sensitivity', 'Private');
                    break;

                case 'confidential':
                    $mimeObj->setHeader('Sensitivity', 'Company-Confidential');
                    break;
            }

            // Disposition notification header
            if (!empty($SESSION['email_compose']['read_rcpt'])) {
                $mimeObj->setHeader('Disposition-Notification-To', (!empty($SESSION['email_compose']['replyto']) ? $SESSION['email_compose']['replyto'] : $SESSION['email_compose']['from']));
            }

            // Username/server header
            if (@$HOSTINFO['add_username_server']) {
                $mimeObj->setHeader('X-Vwebmail-Auth', $SESSION['email']['user'].'@'.$SESSION['email']['srvr']);
            }

            // Add any attachments
            if (isset($SESSION['email_compose']['files'])) {
                foreach ($SESSION['email_compose']['files'] as $value) {
                    $mimeObj->addAttachment($mimeObj->getFile($value['tmp_name']), $value['filename'], $value['c_type'], (isset($value['encoding']) ? $value['encoding'] : 'base64'));
                }
            }

            // Originating IP header
            if (@$HOSTINFO['add_ip_header']) {
                addIPHeader($mimeObj);
            }

            // Build and send it after checking for any text to append
            $appendText = '';
            if ($_POST['action'] != 'save_draft' AND !empty($HOSTINFO['outgoing_append'])) {
                $filename =  $CONFIG['conf_dir'] . basename($HOSTINFO['outgoing_append']);
                if (file_exists($filename) && filesize($filename) > 0) {
                    $appendText = fread(fopen($filename, 'r'), filesize($filename));
                }
            }

            // Check which to set, HTML or text
            if (@$SESSION['email_compose']['htmlEditor']) {
                if (version_compare(phpversion(), "5.0.0", ">=")) {
                    $text = str_ireplace('<br>', CRLF, $SESSION['email_compose']['text']);
                } else {
                    $text = preg_replace('/<br\/?[^>]>/i', CRLF, $SESSION['email_compose']['text']);
                }
                $text = preg_replace('/<\/?p>/i', CRLF . CRLF, $text);
                $text = wordwrap(strip_tags($text), $USERPREFS['settings']['outgoing_wrap'], CRLF) . CRLF . $appendText;
                
                $mimeObj->setHTML($SESSION['email_compose']['text'], $text);

            } else {
                $mimeObj->setText(wordwrap($SESSION['email_compose']['text'], $USERPREFS['settings']['outgoing_wrap'], CRLF) . CRLF . $appendText);
            }


            $build_params = array();
            if (preg_match('/[\x80-\xFF]+/', $SESSION['email_compose']['text'])) {
                $build_params['text_encoding'] = 'quoted-printable';
                $build_params['text_charset']  = lang('ISO-8859-1');
            }

            if (!$mimeObj->buildMessage($build_params)) {
                common::redirect('email.compose.php', lang('Failed to build message'));
            }


            /*******************            SEND THE MAIL             *******************/

            
            /**
            * Save draft
            */
            if ($_POST['action'] == 'save_draft') {
                if (!empty($SESSION['email_compose']['identity'])) {
					$mimeObj->setHeader('X-Vwebmail-Identity', $SESSION['email_compose']['identity']);
                }
                
                $recipients = array();

                // Get the RCPT TO: addresses
                if ($SESSION['email_compose']['to']  != '') {
                    $recipients = get_addresses($to_addresses);

                }
                $mail_sent = true;

            /**
            * SMTP
            */
            } elseif (!empty($SESSION['email']['smtp_srvr'])) {
                $recipients = array();

                // Get the RCPT TO: addresses
                if ($SESSION['email_compose']['to']  != '') {
                    $recipients = get_addresses($to_addresses);
                }

                if (empty($SESSION['email_compose']['to']) AND empty($SESSION['email_compose']['cc'])) {
                    $mimeObj->setHeader('To', 'undisclosed-recipients:;');
                }

                $mail_sent = $mimeObj->send($recipients, 'smtp');

            /**
            * Regular use of mail() function
            */
            } elseif ($SESSION['email']['smtp_srvr'] == null) {

                $recipients = array();

                // Get the RCPT TO: addresses
                if ($SESSION['email_compose']['to']  != '') {
                    $recipients = get_addresses($to_addresses);

                } else if (empty($SESSION['email_compose']['to']) AND empty($SESSION['email_compose']['cc'])) {
                    $recipients[] = 'undisclosed-recipients:;';
                }

                // Send
                $mail_sent = $mimeObj->send($recipients);

            /**
            * Something's wrong
            */
            } else {
                $mail_sent = false;
            }

            /**
            * Append message to mailbox
            */
            if ($mailaccess->capabilities('folders') AND (!isset($SESSION['email_compose']['save_copy']) OR $SESSION['email_compose']['save_copy'])) {

                $message = $mimeObj->getRFC822($recipients);

                if ($_POST['action'] == 'save_draft') {
                    $folder  = $USERPREFS['settings']['draft_items_folder'] ? $USERPREFS['settings']['draft_items_folder'] : $SESSION['email']['fold'] . 'drafts';
                    $flags[] = '\\Draft';

                } elseif (!empty($SESSION['email_compose']['save_folder']) AND $mailaccess->isValidMailbox($SESSION['email_compose']['save_folder'])) {
                    $folder = $SESSION['email_compose']['save_folder'];
                    $flags  = null;

                } else {
                    $folder = null; // Defaults in $mailaccess->append() to sent-items folder
                    $flags  = null; // Defaults to \Seen
                }

                if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {
                    $appendResult = $mailaccess->append(preg_replace('/\r?\n/', "\r\n", $message), $folder, $flags);
                } else {
                    $logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
                }

            /**
            * Need to connect anyway
            */
            } else {
                $mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox']);
            }

            /**
            * Redirect
            */
            if ($mail_sent) {

                // Log it
                $logger->log(sprintf('Mail sent from (%s) to (%s)', @$SESSION['email_compose']['from'], @$SESSION['email_compose']['to']));

                if ($_POST['action'] == 'save_draft') {
                    if ($appendResult) {
                        if (!empty($SESSION['email_compose']['is_draft'])) {
                            removeOldDraft($SESSION['email_compose']['is_draft']);
                        }
                        common::redirect('redirect.php?to=email.list.php');
                    } else {
                        common::redirect('redirect.php?to=email.compose.php', lang('Failed to save changes'));
                    }

                } else {
                    /**
                    * If this is a reply to a mail we
                    * need to set the \Answered flag
                    */
                    if (!empty($SESSION['email_compose']['is_reply']) AND $mailaccess->capabilities('folders')) {
                        if ($SESSION['email_compose']['is_reply']['folder'] != $SESSION['email']['mbox']) {
                            $mailaccess->reconnect($SESSION['email_compose']['is_reply']['folder']);
                        }
                        $mailaccess->setflag($SESSION['email_compose']['is_reply']['msg_id'], 'answered');
                    }

                    // Remove any old draft
                    if (!empty($SESSION['email_compose']['is_draft'])) {
                        removeOldDraft($SESSION['email_compose']['is_draft']);
                    }

                    // Remove any attachment tmp files
                    if (!empty($SESSION['email_compose']['files'])) {
                        foreach ($SESSION['email_compose']['files'] as $attachment) {
                            if (file_exists($attachment['tmp_name'])) {
                                unlink($attachment['tmp_name']);
                            }
                        }
                    }

                    // Clear session
                    unset($SESSION['email_compose']);
                    common::redirect('redirect.php?to=email.list.php', lang('Message sent'));
                }

            } else {
                $errors = !empty($mimeObj->errors) ? implode('<br />', $mimeObj->errors) : '';
                $logger->log(sprintf('Error sending email: (%s)', $errors), LOG_ERR);
                common::redirect('redirect.php?to=email.compose.php', lang('Error sending message') . sprintf(': <br />%s', $errors));
            }

        /**
        * An error occurred, redirect to ourself
        */
        }else{
            common::redirect('redirect.php?to=email.compose.php');
        }

    /**
    * Possibly no action set ? Make sure it's not the options page
    * being saved!
    */
    } elseif (!empty($_POST) AND @!$_POST['action'] AND @!$_GET['show_options']) {
        store_input();
        common::redirect('redirect.php?to=email.compose.php');
    }


/**
* Template stuff. If show_options is passed as a GET parameter,
* the options template is shown and the script exits.
*/
    if (!empty($_GET['show_options'])) {
        if (!empty($_POST)) {
            // These are the storage statements for when the options are saved
            $SESSION['email_compose']['read_rcpt']   = @$_POST['read_rcpt'];
            $SESSION['email_compose']['priority']    = $_POST['priority'];
            $SESSION['email_compose']['sensitivity'] = $_POST['sensitivity'];
            $SESSION['email_compose']['save_copy']   = @(bool)$_POST['save_copy'];
            $SESSION['email_compose']['save_folder'] = @$_POST['save_copy'] ? $_POST['save_folder'] : '';

            die('<html><body><script type="text/javascript" language="javascript">window.close()</script></body></html>');
        }

        /**
        * Only show "Save a copy in ..." if folder capable
        */
        if ($mailaccess->capabilities('folders')) {
            if($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])){
    
                $save_folder = !empty($SESSION['email_compose']['save_folder']) ? $SESSION['email_compose']['save_folder'] : $USERPREFS['settings']['sent_items_folder'];

                list($folders, ) = $mailaccess->getSubscribedFolders();
                for ($i=0; $i<count($folders); $i++) {
                    if ($folders[$i]['name'] == $save_folder) {
                        $folders[$i]['selected'] = 'selected="selected"';
                        break;
                    }
                }
                $save_copy = (isset($SESSION['email_compose']['save_copy']) && $SESSION['email_compose']['save_copy'] == '0' ? '' : 'checked="checked"');
            } else {
                $logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
            }
        }

        $read_rcpt = @$SESSION['email_compose']['read_rcpt'] == '1' ? 'checked="checked"' : '';
        isset($SESSION['email_compose']['priority'])    ? ${'priority_'.strtolower($SESSION['email_compose']['priority'])} = 'selected="selected"' : $priority_normal = 'selected="selected"';
        isset($SESSION['email_compose']['sensitivity']) ? ${'sens_'.strtolower($SESSION['email_compose']['sensitivity'])}  = 'selected="selected"' : $sens_normal = 'selected="selected"';

        $template = 'email.compose.options.html';
        include($CONFIG['includes'] . 'template.wrapper.php');
        exit;
    }

    /**
    * Read all addressbook entries
    */
    $ab = &new addressbook();

    // And now get the addresses
    $addresses = array();
    if (!empty($ab->addresses)) {
        /**
        * Sort the addresses by surname
        */
        usort($ab->addresses, create_function('$a, $b', 'if (strcmp(@$a["surname"], @$b["surname"]) != 0) return strcmp($a["surname"], $b["surname"]); else return strcmp($a["email"], $b["email"]);'));

        foreach ($ab->addresses as $id => $values) {
            $address['email'] = $ab->createStringFromAddress($values);
            $address['name']  = $ab->getFullName($values) != '' ? $ab->getFullName($values) : $values['email'];

            // Necessary for 2/3rd emails
            $origName = $address['name'];

            // Javascript arrays
            $address['display_email'] = javascript::escapeString($address['email']);
            $address['display_name']  = javascript::escapeString($address['name']);

            $address['search_email'] = javascript::escapeString($values['email']);
            $address['search_fname'] = javascript::escapeString(@$values['forename']);
            $address['search_lname'] = javascript::escapeString(@$values['surname']);

            // Make these safe...
            $address['email'] = htmlspecialchars($address['email']);
            $address['name']  = htmlspecialchars($address['name']);
            
            $addresses[] = $address;
            
            /**
            * Add "other" email addresses if they exist
            * This is a lil' hackish
            */
            foreach (array('2', '3') as $num) {
                if (!empty($values['email_' . $num])) {
    
                    $values['email']          = $values['email_' . $num];
                    $address['email']         = $ab->createStringFromAddress($values);
                    $address['display_email'] = javascript::escapeString($address['email']);
                    $address['display_name']  = javascript::escapeString($origName . ' (' . $num . ')');
                    $address['search_email']  = javascript::escapeString($values['email']);
                    $address['email']         = htmlspecialchars($address['email']);
                    $address['name']          = htmlspecialchars($origName . ' (' . $num . ')');
    
                    $addresses[] = $address;
                }
            }
        }
    } else {
        $addresses = array();
    }

    /**
    * Addressbook groups
    */
    if (!empty($ab->groups)) {

        // Add the separator
        array_unshift($addresses, array('name' => '-----------------------------------', 'display_name' => '-----------------------------------'));

        $members = array();
        foreach ($ab->groups as $group_name => $group_uids) {
            $text = array();
            $members = $ab->getGroupMembers($group_name);
            foreach ($members as $group_member) {
                $text[] = $group_member['text'];
            }
            
            array_unshift($addresses, array('display_email' => javascript::escapeString(implode(', ', $text)),
                                            'display_name'  => javascript::escapeString(lang('(G)') . ' ' . $group_name),
                                            'email'         => htmlspecialchars(implode(', ', $text)),
                                            'name'          => htmlspecialchars(lang('(G)') . ' ' . $group_name),
                                            'search_fname'  => javascript::escapeString(lang('(G)')),
                                            'search_lname'  => javascript::escapeString($group_name)));
        }
    }

    // Add "All addresses" group
    $members = $ab->getGroupMembers('All addresses');
    if (!empty($members)) {

        // Add separator ?
        if (empty($ab->groups)) {
            array_unshift($addresses, array('name' => '-----------------------------------', 'display_name' => '-----------------------------------'));
        }

        $text = array();
        foreach ($members as $group_member) {
            $text[] = $group_member['text'];
        }
        array_unshift($addresses, array('display_email' => javascript::escapeString(implode(', ', $text)),
                                        'display_name'  => javascript::escapeString(lang('(G)') . ' ' . 'All addresses'),
                                        'email'         => htmlspecialchars(implode(', ', $text)),
                                        'name'          => htmlspecialchars(lang('(G)') . ' ' . 'All addresses'),
                                        'search_fname'  => javascript::escapeString(lang('(G)')),
                                        'search_lname'  => javascript::escapeString('All addresses')));
    }

    // Build an email address from the userprefs info
    if (!empty($USERPREFS['settings']['email_address'])) {
        $name          = !empty($USERPREFS['settings']['name']) ? '"'.$USERPREFS['settings']['name'].'" ' : '';
        $email_address = $name.'<'.$USERPREFS['settings']['email_address'].'>';
    }

    // Build an email address from the userprefs info
    if (!empty($USERPREFS['settings']['reply_address'])) {
        $reply_address = $USERPREFS['settings']['reply_address'];
    }

    /**
    * Get existing data from session
    */
    $from      = isset($SESSION['email_compose']['from'])       ? htmlspecialchars($SESSION['email_compose']['from'])    : (isset($email_address) ? htmlspecialchars($email_address) : '');
    $replyto   = isset($SESSION['email_compose']['replyto'])    ? htmlspecialchars($SESSION['email_compose']['replyto']) : (isset($reply_address) ? htmlspecialchars($reply_address) : '');
    $to        = isset($SESSION['email_compose']['to'])         ? htmlspecialchars($SESSION['email_compose']['to'])      : '';
    $cc        = isset($SESSION['email_compose']['cc'])         ? htmlspecialchars($SESSION['email_compose']['cc'])      : '';
    $bcc       = isset($SESSION['email_compose']['bcc'])        ? htmlspecialchars($SESSION['email_compose']['bcc'])     : '';
    $subject   = isset($SESSION['email_compose']['subject'])    ? htmlspecialchars($SESSION['email_compose']['subject']) : '';
    $text      = isset($SESSION['email_compose']['text'])       ? htmlspecialchars($SESSION['email_compose']['text'])    : '';

    /**
    * Add the vCard attachment if:
    *  o it's enabled in prefs
    *  o it hasn't already been attached
    */
    if (@$USERPREFS['settings']['include_vcard'] AND $USERPREFS['settings']['vcard_id'] AND !@$SESSION['email_compose']['vcard_attached']) {
        if ( ($vCard = $ab->createVcardFromUid($USERPREFS['settings']['vcard_id'])) !== false) {

            $fullname = $ab->getFullNameByUid($USERPREFS['settings']['vcard_id']);
    
            // Write vCard to file
            include_once($CONFIG['pear_dir'] . 'File.php');
            $filename = File::getTempFile($CONFIG['tmp_dir']);
            if (File::write($filename, $vCard)) {
    
                $SESSION['email_compose']['files'][] = array(
                                                                'tmp_name' => $filename,
                                                                'size'     => strlen($vCard),
                                                                'c_type'   => 'text/x-vcard',
                                                                'filename' => $fullname . '.vcf',
                                                                'encoding' => '7bit'
                                                            );
                $SESSION['email_compose']['vcard_attached'] = true;

            } else {
                $logger->log('Failed to write generated vCard to file in email.compose.php', LOG_ERR);
            }
        } else {
            $logger->log('Failed to generate vCard in email.compose.php', LOG_ERR);
        }
    }

    /**
    * Has signature been appended? Also
    * check "Don't apply signature on
    * replies/forwards" option
    */
    if (@$USERPREFS['settings']['sig_reply_forward'] AND (!empty($SESSION['email_compose']['is_reply']) OR !empty($SESSION['email_compose']['is_forward']))) {
        $nosig = true;
    } else {
        $nosig = false;
    }

    if (!@$SESSION['email_compose']['signature_appended'] AND $nosig == false) {
        $text .= $USERPREFS['settings']['signature'];
        $SESSION['email_compose']['text'] = @$SESSION['email_compose']['text'] . $USERPREFS['settings']['signature'];
        $SESSION['email_compose']['signature_appended'] = true;
    }

    /**
    * Get errors from session
    */
    if (isset($SESSION['email_compose']['errors'])) {

        $tmp = &$SESSION['email_compose']['errors'];

        $from_error    = isset($tmp['from'])    ? htmlspecialchars($tmp['from'])    : '';
        $replyto_error = isset($tmp['replyto']) ? htmlspecialchars($tmp['replyto']) : '';
        $to_error      = isset($tmp['to'])      ? htmlspecialchars($tmp['to'])      : '';
        $cc_error      = isset($tmp['cc'])      ? htmlspecialchars($tmp['cc'])      : '';
        $bcc_error     = isset($tmp['bcc'])     ? htmlspecialchars($tmp['bcc'])     : '';

        unset($tmp);
        unset($SESSION['email_compose']['errors']);
    }

/**
* Signature for add sig button
*/
    $tpl_signature = javascript::escapeString($USERPREFS['settings']['signature']);

/**
* Can change email address?
*/
    $changeable_email = $HOSTINFO['allow_changeable_email'];

/**
* Identities
*/
    if ($changeable_email AND $HOSTINFO['allow_identities']) {
        $identities = identities::getIdentityList(isset($SESSION['email_compose']['identity']) ? $SESSION['email_compose']['identity'] : @$_POST['identity']);
        foreach ($identities as $id => $identity) {
            $identities[$id]['from_address'] = trim(sprintf('%s <%s>', @$identity['name'], $identity['email_address']));
        }
        
        $identities[0] = array('id_name' => lang('Default identity'), 'from_address' => @$email_address, 'email_address' => $USERPREFS['settings']['email_address'], 'reply_address' => @(string)$reply_address);
        ksort($identities);
    }

/**
* Create HTML Editor This also handles the siuations of when
* a plain text box is required too.
*/
    include($CONFIG['includes'] . 'fckeditor.php');

    // Handle default if the pref isn't set (BC)
    $SESSION['email_compose']['htmlEditor'] = !isset($SESSION['email_compose']['htmlEditor']) ? @($USERPREFS['settings']['defaultEditor'] == 'html') : $SESSION['email_compose']['htmlEditor'];

    if (!empty($SESSION['email_compose']['htmlEditor'])) {
        $useHTMLEditor = true;
        $SESSION['email_compose']['htmlEditor'] = true;
    } else {
        $useHTMLEditor = false;
        $SESSION['email_compose']['htmlEditor'] = false;
    }

    $oFCKeditor             = new FCKeditor('text');
    $oFCKeditor->BasePath   = 'HTMLEditor/';
    $oFCKeditor->UseHTML    = $useHTMLEditor;
    $oFCKeditor->Width      = '100%';
    $oFCKeditor->Height     = '400';
    $oFCKeditor->ToolbarSet = 'V-webmail';
    $oFCKeditor->Value      = $text; // Text is what was always used for the body of the email
    $htmlEditorHTML         = $oFCKeditor->CreateHtml();

/**
* Get account info
*/
    $template = 'email.compose.html';
    include($CONFIG['includes'] . 'template.wrapper.php');

?>
