<?php
/**
* Filename.......: email.compose.attachments.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Check Login
*/
	auth::check_login('login.php', 'email.compose.php'.(isset($_GET['to']) ? '?to='.$_GET['to'] : ''));

/**
* Remove any error message from the
* session and set the error_msg var for
* the template.
*/
	common::errorMsg($error_msg);

/**
* Form was POSTed ?
*/
	if (!empty($_POST)) {
		switch (@$_POST['action']) {
			case 'add_attachment':
				if (!empty($_FILES['attachment']['tmp_name']) AND $_FILES['attachment']['tmp_name'] !== 'none') {

					foreach ($_FILES as $value) {
						include_once($CONFIG['pear_dir'] . 'File.php');
						$tmp_filename = File::getTempFile($CONFIG['tmp_dir']);
						if (copy($value['tmp_name'], $tmp_filename)) {
							chmod($tmp_filename, 0777);
							$SESSION['email_compose']['files'][] = array('tmp_name' => $tmp_filename,
																		 'filename' => $value['name'],
																		 'size'     => $value['size'],
																		 'c_type'   => $value['type']);
						} else {
							common::redirect('redirect.php?to=email.compose.attachments.php', lang('Failed to move uploaded file'));
						}
					}

				} else if (!empty($_FILES['attachment']['name'])) {
					pdd('e');
					$SESSION['common']['error_msg'] = lang('File uploaded was too large (limit is: 2Mb)');
				}

                common::redirect('redirect.php?to=email.compose.attachments.php');
				break;

			case 'remove_attachment':
				if (!empty($_POST['attachments'])) {
					foreach ($_POST['attachments'] as $attachment) {
		                @unlink($SESSION['email_compose']['files'][$attachment]['tmp_name']);
		                unset($SESSION['email_compose']['files'][$attachment]);
		            }

                    // Re-sort array
                    if (count($SESSION['email_compose']['files']) > 0) {
                        $SESSION['email_compose']['files'] = array_values($SESSION['email_compose']['files']);
                    }
		        }

                common::redirect('redirect.php?to=email.compose.attachments.php');
				break;

			default:
				common::redirect('redirect.php?to=email.compose.attachments.php', lang('Unknown action specified'));
		}
	}

/**
* Get list of existing attachments
*/
	if (!empty($SESSION['email_compose']['files'])) {
		for ($i=0; $i<count($SESSION['email_compose']['files']); $i++) {

			if (isset($SESSION['email_compose']['files'][$i])) {

				$attachments[$i] = array_merge($SESSION['email_compose']['files'][$i], array('id' => $i));
				// Format the size
				if ($attachments[$i]['size'] > 1048576) {
					$attachments[$i]['size'] = number_format(($attachments[$i]['size'] / 1048576), 2).' Mb';

				} elseif ($attachments[$i]['size'] > 1024) {
					$attachments[$i]['size'] = number_format(($attachments[$i]['size'] / 1024), 2).' Kb';

				} else {
					$attachments[$i]['size'] = $attachments[$i]['size'].' bytes';
				}
			}
		}
	} else {
		$attachments = array();
	}

/**
* Show template
*/
	$template = 'email.compose.attachments.html';
	include($CONFIG['includes'] . 'template.wrapper.php');
?>
