<?php
/**
* Filename.......: email.action.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/**
* Check login
*/
	auth::check_login('login.php', 'email.list.php');

/**
* Function to generate array of msg_ids
* in correct structure
*/
	function parse_msg_ids($msg_ids)
	{
		for ($i=0; $i<count($msg_ids); $i++) {
			$id     = substr($msg_ids[$i], 0, $pos = strpos($msg_ids[$i], ':'));
			$folder = substr($msg_ids[$i], $pos + 1);
			$ret[$folder][] = $id;
		}
		
		return $ret;
	}

/**
* Default redirect
*/
	$redirect_to = 'email.list.php';
	$message     = null;

/**
* This is a nasty hack to enable
* the delete option from email.view.message.php
* to work.
*/
	if (!empty($_GET['from']) AND $_GET['from'] == 'view_message') {
		$_POST['msg_ids'] = array($_GET['msg_id'] . ':' . $_GET['mbox']);
		$_POST['action']  = 'delete';
		$next_msg_id      = (int)$_GET['next_msg_id'];
		$prev_msg_id      = (int)$_GET['prev_msg_id'];
		$next_msg_mbox    = $_GET['next_msg_mbox'];
		$prev_msg_mbox    = $_GET['prev_msg_mbox'];

		// Remove the entry from the message_ids index in the session.
		$message_ids_idx = (int)$_GET['message_ids_idx'];
		if(isset($SESSION['email']['message_ids'][$message_ids_idx])){
			unset($SESSION['email']['message_ids'][$message_ids_idx]);
			$SESSION['email']['message_ids'] = array_values($SESSION['email']['message_ids']);
		}

		if(@$USERPREFS['settings']['view_msg_delete'] == 'next' AND $next_msg_id) $redirect_to = 'email.view.message.php?msg_id=' . $next_msg_id . '&mbox=' . $next_msg_mbox;
		if(@$USERPREFS['settings']['view_msg_delete'] == 'prev' AND $prev_msg_id) $redirect_to = 'email.view.message.php?msg_id=' . $prev_msg_id . '&mbox=' . $prev_msg_mbox;
		// If neither of the above are called, default takes precedence from above
	}

/**
* Begin
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

	

		// Handle quick search
		if (!empty($_POST['quicksearch']) AND $HOSTINFO['allow_quicksearch']) {
			// Lose any current quicksearch
			$SESSION['quicksearch'] = array();
			
			if ($_POST['quicksearch'] != '__RESET__') {
				// Store the search string
				$SESSION['quicksearch']['string']   = $_POST['quicksearch'];
				$SESSION['quicksearch']['criteria'] = preg_split('/\s+/', strtolower($_POST['quicksearch']), -1, PREG_SPLIT_NO_EMPTY);
			}

			// Redirect to email.quicksearch.php
			common::redirect('email.list.php');
		}
		


		// Other actions
		if (!empty($_POST['msg_ids']) AND is_array($_POST['msg_ids'])) {

			// Remove these entries from the cache
			for ($i=0; $i<count($_POST['msg_ids']); $i++) {
				mailaccess::cacheRemove($_POST['msg_ids'][$i]);
			}

			$_msg_ids = parse_msg_ids($_POST['msg_ids']);

			foreach ($_msg_ids as $folder => $msg_ids) {

				$mailaccess->reconnect($folder);

				$msg_ids = implode(',', $msg_ids);
				$deleted_folder = !empty($USERPREFS['settings']['deleted_items_folder']) ? $USERPREFS['settings']['deleted_items_folder'] : $SESSION['email']['fold'].'Deleted-items';

				switch ($_POST['action']) {
					case 'delete':
						$mailaccess->delete($msg_ids, $message);
						break;

					case 'move':
						if (!$mailaccess->capabilities('folders')) {
							$message = lang('This account type does not support folders');
							break;
						}

						if ($folder == $_POST['folder']) {
							$message = lang('Moving/copying messages to same folder is not permitted');
							break;
						}
	
						if (!$mailaccess->isValidMailbox($folder)) {
							common::redirect('redirect.php?email.list.php', lang('Invalid mailbox name supplied'));
						}

						$message = $mailaccess->moveMsg($msg_ids, $_POST['folder']) ? null : lang('Move of message failed');
						break;
					
					case 'copy':
						if (!$mailaccess->capabilities('folders')) {
							$message = lang('This account type does not support folders');
							break;
						}
	
						if ($folder == $_POST['folder']) {
							$message = lang('Moving/copying messages to same folder is not permitted');
							break;
						}
	
						if (!$mailaccess->isValidMailbox($folder)) {
							common::redirect('redirect.php?email.list.php', lang('Invalid mailbox name supplied'));
						}

						$message = $mailaccess->copyMsg($msg_ids, $_POST['folder']) ? null : lang('Move of message failed');
						break;
	
					case 'read':
					case 'unread':
					case 'flagged':
					case 'unflagged':
					case 'draft':
					case 'undraft':
					case 'deleted':
					case 'undeleted':
					case 'answered':
					case 'unanswered':
						if (!$mailaccess->capabilities('folders')) {
							$message = lang('This account type does not support folders');
							break;
						}

						$message = $mailaccess->setflag($msg_ids, $_POST['action']) ? null : lang('Failed to update message(s)');
						break;

					case 'blocksender':
						foreach ($_msg_ids[$folder] as $msg_id) {
							$msgSummary = $mailaccess->getMsgSummary($msg_id);
							$blockedValues[] = $msgSummary['email'];
						}
						break;

					case 'blocksubject':
						foreach ($_msg_ids[$folder] as $msg_id) {
							$msgSummary = $mailaccess->getMsgSummary($msg_id);
							// FIXME Should use subject_raw here? In case of quotes (")...
							$blockedValues[] = $msgSummary['subject'];
						}
						break;

					case 'forward_att':
						// FIXME Not implemented yet
						break;

					default:
						$message = '';
						break;

				} // End switch
			} // End foreach

		} else {
			$message = lang('No messages were selected');
		}

		// Post handling for blocking options needed for
		// building the redirect URL
		if (in(@$_POST['action'], 'blocksender', 'blocksubject') AND !empty($blockedValues)) {
			$redirect_to = 'preferences.blacklists.php?from=listing&action=' . $_POST['action'];
			foreach ($blockedValues as $value) {
				$redirect_to .= '&value[]=' . $value;
			}
		}

	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}

/**
* Redirect
*/
	common::redirect($redirect_to, $message);
?>