<?php
/**
* Filename.......: configure.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/01 13:26:59 $
* CVS Revision...: $Revision: 1.4 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');
	$action = @$_GET['action'];

/**
 * Test if local.config.xml is writeable.
 */
    if (!is_writable($CONFIG['conf_dir'] . 'local.config.xml')) {
        $action = 'warn';
    } else {
    	print "Configuration web interface not (yet) available...";
    	exit(0);
    }

/**
* Set base configuration path
*/
	$config->setBasePath('v-webmail/configuration/');

/**
* Main part of program
*/
	switch ($action) {
		case 'save':
			pdd($_POST);
			break;

		case 'warn':
			showWarning();
			break;

		default:
			// Show form
			showForm($config);
			break;
	}


/**
* Function to show warning. Cannout edit config file.
*
*/
function showWarning()
{
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<title>V-webmail Configuration</title>
	<style type="text/css">
	<!--
	body, h1 {
		font-family: Verdana, Sans-Serif;
	}

	p.warning {
		color: red;
		font-weight: bold;
	}

	fieldset {
		padding: 5px;
	}

	td.label {
		font-size: 80%;
		background-color: #efefef;
		border: 1px dashed #aaaaaa;
	}
	// -->
	</style>
<body>
<h1>V-webmail Configuration</h1>
<p class="warning">Editor disabled. Make config '<?=$CONFIG['conf_dir'] . 'local.config.xml'?>' writable and try again.</p>
</body>
</html>
<?php
}



/**
* Function to show the configuration form
*
*/
function showForm($config)
{
	// Grab defined languages from config
	$languages = $config->getValue('/v-webmail/languages/language', 'array');

	// Create array keyed by language filename, valued by description
	$languageDescriptions = array();
	foreach ($languages as $language) {
		$languageDescriptions[$language['filename']] = $language['description'];
	}

	// Create a list of language files in the lang dir
	$languageFiles = array();
	$dir = opendir($GLOBALS['CONFIG']['lang_dir']);
	while ($filename = readdir($dir)) {
		if (preg_match('/^lang\..+\.php$/i', $filename) AND $filename != 'lang.template.php') {
			$languageFiles[] = $filename;
		}
	}
	sort($languageFiles);

	//pdd($config->getValue('servers/server'));

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<title>V-webmail Configuration</title>

	<script type="text/javascript" defer="defer" src="javascript/configure/configure.js">
	</script>
	<script type="text/javascript" defer="defer">
	<!--
   		// Add onload event to body.
   		addEvent(window, 'load', firstStart);
		// -->
	</script>

    <style type="text/css">
	<!--
	body, h1 {
		font-family: Verdana, Sans-Serif;
	}

	fieldset {
		padding: 5px;
	}

	td.label {
		font-size: 80%;
		background-color: #efefef;
		border: 1px dashed #aaaaaa;
	}
	// -->
	</style>
<body>
<h1>V-webmail Configuration</h1>

<button onclick="showFieldset('fieldset_general')">General Settings</button>&nbsp;
<button onclick="showFieldset('fieldset_servers')">IMAP/POP3 Servers</button>&nbsp;
<button onclick="showFieldset('fieldset_vhosts')">Virtual Host Definitions</button>&nbsp;
<button onclick="showFieldset('fieldset_languages')">Language Files</button>

<form action="configure.php?action=save" method="post" name="configForm" id="configForm">

<fieldset style="width: 75%; display: none" id="fieldset_general">
	<legend>General Settings</legend>

	<table border="0">
		<tr>
			<td width="20%"><?=lang('Default Language')?></td>
			<td colspan="2"><input type="text" name="general/default_lang" value="<?=$config->getValue('general/default_lang')?>" /></td>
		</tr>
		<tr>
			<td colspan="3" class="label">
				This is the default language file to use. If you want to set it to something other
				than english, check first the lang/ directory to see what language files are available.
				Then pick a code (the two/three letters in the middle of the files name, eg en, de, id, big5)
				and set it here.
			</td>
		</tr>

		<tr><td colspan="3">&nbsp;</td></tr>

		<tr>
			<td><?=lang('Config Checks')?></td>
			<td colspan="2"><input type="checkbox" name="general/config_checks" value="1" <?=($config->getValue('general/config_checks', 'boolean') ? 'checked="checked"' : '')?> /></td>
		</tr>
		<tr>
			<td colspan="3" class="label">
				This flag determines whether configuration checks are performed when the login page is displayed.
				You should leave this turned On until you are confident that V-webmail is running ok. Various
				checks are performed, eg permissions on directories, correct PHP versions and imap extension
				availability.
			</td>
		</tr>

		<tr><td colspan="3">&nbsp;</td></tr>

		<tr>
			<td><?=lang('Servers Strict')?></td>
			<td colspan="2"><input type="checkbox" name="general/servers_strict" value="1" <?=($config->getValue('general/servers_strict', 'boolean') ? 'checked="checked"' : '')?> /></td>
		</tr>
		<tr>
			<td colspan="3" class="label">
				This setting determines, as mentioned above, whether the users of V-webmail will be
				limited to the server settings in this file or not. If you set this to On and have
				multiple servers
			</td>
		</tr>

		<tr><td colspan="3">&nbsp;</td></tr>

		<tr>
			<td valign="top"><?=lang('Preferences Storage')?></td>
			<td valign="top">
				<input type="radio" name="general/prefs_storage/type" value="file" onclick="preferencesStorage_onclick(this)" <?=($config->getValue('general/prefs_storage/type') == 'file' ? 'checked="checked"' : '')?> id="general/prefs_storage/type_file" /> <label for="general/prefs_storage/type_file">File</label><br />
				<input type="radio" name="general/prefs_storage/type" value="mysql" onclick="preferencesStorage_onclick(this)" <?=($config->getValue('general/prefs_storage/type') == 'mysql' ? 'checked="checked"' : '')?> id="general/prefs_storage/type_mysql" /> <label for="general/prefs_storage/type_mysql">MySQL</label><br />
				<input type="radio" name="general/prefs_storage/type" value="postgres" onclick="preferencesStorage_onclick(this)" <?=($config->getValue('general/prefs_storage/type') == 'postgres' ? 'checked="checked"' : '')?> id="general/prefs_storage/type_postgres"/> <label for="general/prefs_storage/type_postgres">PostgreSQL</label>
			</td>
			<td>
				<table border="0" id="prefsStorageDBTable">
					<tr>
						<td>Hostname</td>
						<td><input type="text" name="general/prefs_storage/hostname" value="<?=$config->getValue('general/prefs_storage/hostname')?>" /></td>
					</tr>
					<tr>
						<td>Username</td>
						<td><input type="text" name="general/prefs_storage/username" value="<?=$config->getValue('general/prefs_storage/username')?>" /></td>
					</tr>
					<tr>
						<td>Password</td>
						<td><input type="text" name="general/prefs_storage/password" value="<?=$config->getValue('general/prefs_storage/password')?>" /></td>
					</tr>
					<tr>
						<td>Database</td>
						<td><input type="text" name="general/prefs_storage/database" value="<?=$config->getValue('general/prefs_storage/database')?>" /></td>
					</tr>
					<tr>
						<td>Table</td>
						<td><input type="text" name="general/prefs_storage/table" value="<?=$config->getValue('general/prefs_storage/table')?>" /></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="3" class="label">
				This option determines how your preferences are stored. The default option is using files. The
				other options are currently MySQL or Postgres. If you want to use MySQL or Postgres instead of files
				you should comment out the files line (prefix the line with a semi-colon (;)), and uncomment the appropriate
				line beneath (remove the semi-colon (;) at the start of the line). Specify the correct details on the
				MySQL/Postgres line, as illustrated by the bracketed words. If you have wierd characters in your username
				or password you may need to enclose the entire text after the equals in double quotes.
			</td>
		</tr>

		<tr><td colspan="3">&nbsp;</td></tr>

	</table>
</fieldset>


<fieldset style="width: 75%; display: none" id="fieldset_servers">
	<legend>Servers</legend>

	<table border="1">
		<tr>
			<td colspan="3" align="center">
				<select name="servers/server" size="10" style="width: 300px" onchange="serversList_onchange(this)">
					<?foreach($config->getValue('servers/server', 'array') as $s):?>
						<option value="<?=htmlspecialchars($s['description'])?>:<?=htmlspecialchars($s['hostname'])?>:<?=(int)$s['port']?>:<?=$s['type']?>:<?=htmlspecialchars($s['domain'])?>:<?=(int)$s['extended_listing']?>:<?=(int)$s['use_uids']?>:<?=(int)$s['smtp']['enabled']?>:<?=htmlspecialchars($s['smtp']['hostname'])?>:<?=(int)$s['smtp']['port']?>:<?=htmlspecialchars($s['smtp']['helo'])?>:<?=(int)$s['smtp']['authentication']['enabled']?>:<?=htmlspecialchars($s['smtp']['authentication']['username'])?>:<?=htmlspecialchars($s['smtp']['authentication']['password'])?>"><?=htmlspecialchars($s['description'])?></option>
					<?endforeach?>
				</select>
			</td>
		</tr>

		<tr>
			<td align="center" colspan="3">
				<button name="serversServerAdd" style="width: 95px" onclick="serversServerAdd_onclick()">Add</button>&nbsp;
				<button name="serversServerRemove" style="width: 95px" onclick="serversServerRemove_onclick()" disabled="disabled">Remove</button>&nbsp;
				<button name="serversServerNew" style="width: 95px" onclick="serversServerNew_onclick()">New</button>
			</td>
		</tr>

		<tr>
			<td>Description</td>
			<td><input type="text" name="servers/server/description" value="" /></td>
			<td rowspan="8" valign="top">
				SMTP Details
				<table border="1" disabled="disabled" id="serversServerSMTPTable">
					<tr>
						<td>Hostname</td>
						<td>sdsd<input type="text" name="servers/server/smtp/hostname" value="" disabled="disabled" /></td>
					</tr>
					<tr>
						<td>Port</td>
						<td><input type="text" name="servers/server/smtp/port" value="25" disabled="disabled" /></td>
					</tr>
					<tr>
						<td>HELO/EHLO String</td>
						<td><input type="text" name="servers/server/smtp/helo" value="" disabled="disabled" /></td>
					</tr>
					<tr>
						<td>Use Authentication</td>
						<td><input type="checkbox" value="1" name="servers/server/smtp/authentication/enabled" disabled="disabled" /></td>
					</tr>
					<tr>
						<td>Username</td>
						<td><input type="text" name="servers/server/smtp/authentication/username" value="" disabled="disabled" /></td>
					</tr>
					<tr>
						<td>Password</td>
						<td><input type="text" name="servers/server/smtp/authentication/password" value="" disabled="disabled"  /></td>
					</tr>
				</table>
			</td>
		</tr>
		
		<tr>
			<td>Hostname</td>
			<td><input type="text" name="servers/server/hostname" value="" /></td>
		</tr>
		
		<tr>
			<td>Port</td>
			<td><input type="text" name="servers/server/port" value="143" /></td>
		</tr>
		
		<tr>
			<td>Type</td>
			<td>
				<select name="servers/server/type">
					<option value="imap">imap</option>
					<option value="imap/notls">imap/notls</option>
					<option value="imap/ssl">imap/ssl</option>
					<option value="imap/ssl/novalidate-cert">imap/ssl/novalidate-cert</option>
					<option value="pop3">pop3</option>
					<option value="pop3/notls">pop3/notls</option>
					<option value="pop3/ssl">pop3/ssl</option>
					<option value="pop3/ssl/novalidate-cert">pop3/ssl/novalidate-cert</option>
				</select>
			</td>
		</tr>
		
		<tr>
			<td>Domain</td>
			<td><input type="text" name="servers/server/domain" value="" /></td>
		</tr>
		
		<tr>
			<td>Extended Listing</td>
			<td><input type="checkbox" value="1" name="servers/server/extended_listing" /></td>
		</tr>
		
		<tr>
			<td>Use UIDs</td>
			<td><input type="checkbox" value="1" name="servers/server/use_uids" /></td>
		</tr>

		<tr>
			<td>Use SMTP</td>
			<td><input type="checkbox" value="1" name="servers/server/smtp/enabled" onclick="serversServerUseSMTP_onclick(this)" /></td>
		</tr>
	</table>
	
</fieldset>


<fieldset style="width: 75%; display: none" id="fieldset_vhosts">
	<legend>Virtual Host Definitions</legend>
	
</fieldset>


<fieldset style="width: 75%; display: none" id="fieldset_languages">
	<legend>Languages</legend>
	<table border="0">
		<tr>
			<td valign="top">Current languages available:</td>
			<td>
				<table border="0">
					<tr>
						<td align="center">Filename</td>
						<td align="center">Description</td>
					</tr>

				<?foreach($languageFiles as $l):?>
					<tr>
						<td><?=$l?></td>
						<td><input type="text" name="/v-webmail/languages/language[<?=$l?>]" value="<?=htmlspecialchars(@$languageDescriptions[$l])?>" /></td>
					</tr>
				<?endforeach?>
				</table>
			</td>
		</tr>
	</table>
</fieldset>

<input type="submit" value="Save Changes" />

</form>

</body>
</html>
<?php
}
?>