<?php
/**
* Filename.......: addressbook.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:46 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

    include('config.php');

/*
* Check Login
*/
    auth::check_login('login.php', 'addressbook.php');

/*
* Check for any error msg
*/
    common::errorMsg($error_msg);

/*
* Get ab entries
* // FIXME This function contains migration code which will need
*          removing at some point.
*/
    $ab = &new addressbook();

/**
* Add address link from email viewing or contextmenu
*/
    if (!empty($_GET['add_address'])) {

        $ab->addAddress($_GET['add_address']);
        $ab->sort('surname', 1);
        $ab->save();
    
        // Figure out where to redirect to
        if (!empty($_GET['from']) AND $_GET['from'] == 'listing') {
            $redirect = 'email.list.php';

        } elseif (!empty($_GET['referer'])) {
            $redirect = $_GET['referer'];

        } elseif (!empty($_SERVER['HTTP_REFERER'])) {
            $redirect = $_SERVER['HTTP_REFERER'];
        }

        common::redirect($redirect, htmlspecialchars($_GET['add_address']) . lang(' was added to the addressbook'));
    }

/**
* A POST request (one of many...)
*/
    if (!empty($_POST)) {
        switch (@$_POST['action']) {
            case 'new':
                $_POST['uid'] = $ab->importAddress(array('forename' => $_POST['forename'], 'surname' => $_POST['surname']));
                // Deliberate fallthrough

            case 'edit':
                $ab->setAddressProperty($_POST['uid'], 'title', $_POST['title']);
                $ab->setAddressProperty($_POST['uid'], 'forename', $_POST['forename']);
                $ab->setAddressProperty($_POST['uid'], 'surname', $_POST['surname']);
                $ab->setAddressProperty($_POST['uid'], 'email', $_POST['email_1']);
                $ab->setAddressProperty($_POST['uid'], 'email_2', $_POST['email_2']);
                $ab->setAddressProperty($_POST['uid'], 'email_3', $_POST['email_3']);
                $ab->setAddressProperty($_POST['uid'], 'telephone_home', $_POST['telephone_home']);
                $ab->setAddressProperty($_POST['uid'], 'telephone_work', $_POST['telephone_work']);
                $ab->setAddressProperty($_POST['uid'], 'telephone_cell', $_POST['telephone_cell']);
                $ab->setAddressProperty($_POST['uid'], 'telephone_fax', $_POST['telephone_fax']);
                $ab->setAddressProperty($_POST['uid'], 'street', $_POST['street']);
                $ab->setAddressProperty($_POST['uid'], 'city', $_POST['city']);
                $ab->setAddressProperty($_POST['uid'], 'province', $_POST['province']);
                $ab->setAddressProperty($_POST['uid'], 'postcode', $_POST['postcode']);
                $ab->setAddressProperty($_POST['uid'], 'country', $_POST['country']);
                $ab->setAddressProperty($_POST['uid'], 'notes', $_POST['notes']);

                $categories = array_values(array_unique(preg_split('/\s*,\s*/', $_POST['categories'], -1, PREG_SPLIT_NO_EMPTY)));
                $ab->setAddressProperty($_POST['uid'], 'categories', $categories);

                // Add/update defined categories list
                $ab->updateCategories($categories);

                // Save the addressbook
                if ($ab->save()) {
                    $errorMsg = $_POST['action'] == 'edit' ? lang('Changes saved') : lang('New entry added');
                } else {
                    $errorMsg = lang('Failed to save changes');
                }

                common::redirect('redirect.php?to=' . urlencode('addressbook.php'), $errorMsg);
                break;

            case 'delete_address':
                /**
                * Check for ids
                */
                if (!empty($_POST['addresses'])) {
                    foreach ($_POST['addresses'] as $uid) {
                        $ab->deleteAddress($uid);
                    }
                    $ab->sort('surname', 1);
                    $ab->save();

                    common::redirect('redirect.php?to=addressbook.php');

                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('No id given'));
                }
                break;

            case 'delete_group':
                /**
                * Check for ids
                */
                if (!empty($_POST['groups'])) {
                    foreach ($_POST['groups'] as $group) {
                        $ab->deleteGroup($group);
                    }
                    $ab->save();
                    
                    common::redirect('redirect.php?to=addressbook.php');
                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('No id given'));
                }
                break;

            case 'new_group':
                if (!empty($_POST['new_group'])) {
                    $ab->createGroup($_POST['new_group']);
                    $ab->save();
                    common::redirect('redirect.php?to=addressbook.php');
                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('Empty group name!'));
                }
                break;

            case 'addtogroup':
                if (!empty($_POST['select_addtogroup'])) {
                    foreach ($_POST['addresses'] as $uid) {
                        $ab->addAddressToGroup($_POST['select_addtogroup'], $uid);
                    }
                    $ab->save();
                    common::redirect('redirect.php?to=addressbook.php');
                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('You must select a group!'));
                }
                break;
            
            case 'editgroup':
                if ($_POST['group'] != $_POST['groupname']) { // Old vs New names
                    // Non empty new name
                    if (!$_POST['groupname']) {
                        common::redirect('redirect.php?to=' . urlencode('addressbook.php?page=editgroup&group=' . $_POST['group']), lang('You must enter a name!'));
                    }
                    $ab->deleteGroup($_POST['group']);
                    $ab->createGroup($_POST['groupname']);
                }

                $ab->setGroupMembers($_POST['groupname'], @(array)$_POST['group_members']);
                $ab->save();

                common::redirect('redirect.php?to=addressbook.php');
                break;

            default:
                common::redirect('addressbook.php');
        }

/**
* Normal GET request
*/
    } else {
        switch (@$_GET['page']) {
            case 'new':
                $title        = lang('New addressbook entry');
                $submit_value = lang('Add entry');

                // Create categories for dropdown selection
                $allCategories = $ab->getCategoryList();
                $template      = 'addressbook.edit.html';
                break;

            case 'edit':
                $title        = lang('Edit addressbook entry');
                $submit_value = lang('Save changes');

                /**
                * Check for id
                */
                if (!isset($_GET['uid'])) {
                    common::redirect('redirect.php?to=addressbook.php', lang('No id given'));
                }
        
                /*
                * Get the specific entry from the addressbook
                */
                if ($ab->getAddress($_GET['uid'])) {
                    $entry = $ab->getAddress($_GET['uid']);
                    $entry['uid'] = $_GET['uid'];
                    $entry = htmlspecialchars_r($entry);
                    extract($entry, EXTR_PREFIX_ALL, 'form');

                    // Create categories for dropdown selection
                    $allCategories = $ab->getCategoryList();

                    // Create categories string
                    $form_categories = @implode(', ', $form_categories);
        
                    // Set correct title checked variable
                    ${'form_title_' . @$form_title} = 'selected="selected"';
                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('Given id is not valid'));
                }
        
                $template = 'addressbook.edit.html';
                break;

            /**
            * Group edit page
            */
            case 'editgroup':
                if (!empty($_GET['group'])) {
                    // Get group members
                    $groupname = htmlspecialchars($_GET['group']);
                    $members   = $ab->getGroupMembers($_GET['group']);
                    $members   = htmlspecialchars_r($members);
                    $template  = 'addressbook.groupedit.html';
                    
                    // Get all addresses
                    $all_addresses = $ab->getAllAddresses();
                    $all_addresses = htmlspecialchars_r($all_addresses);

                    for ($i=0, $cnt=count($all_addresses); $i<$cnt; $i++) {
                        if ($ab->inGroup($all_addresses[$i]['uid'], $_GET['group'])) {
                            unset($all_addresses[$i]);
                        }
                    }
                    $all_addresses = array_values($all_addresses);

                } else {
                    common::redirect('redirect.php?to=addressbook.php', lang('You must select a group!'));
                }
                break;

            /**
            * Intermediary page which creates a vCard from an addressbook entry
            * and bungs it in the session as an attachment.
            */
            case 'sendvcard':
                if ( ($vCard = $ab->createVcardFromUid($_GET['uid'])) !== false) {
                    $fullname = $ab->getFullNameByUid($_GET['uid']);
                    
                    if (empty($fullname)) {
                        $fullname = $ab->getAddress($_GET['uid']);
                        $fullname = $fullname['email'];
                    }

                    // Write vCard to file
                    include_once($CONFIG['pear_dir'] . 'File.php');
                    $filename = File::getTempFile($CONFIG['tmp_dir']);
                    if (File::write($filename, $vCard)) {

                        $SESSION['email_compose']['files'][] = array(
                                                                        'tmp_name' => $filename,
                                                                        'size'     => strlen($vCard),
                                                                        'c_type'   => 'text/x-vcard',
                                                                        'filename' => $fullname . '.vcf',
                                                                        'encoding' => '7bit'
                                                                    );
                        common::redirect('email.compose.php');
                    } else {
                        common::redirect('addressbook.php', 'Error attaching vCard!');
                    }
                } else {
                    common::redirect('addressbook.php', 'Error generating vCard!');
                }
                break;

            /**
            * List page
            */
            default:
                // Order by...
                if (!empty($_GET['order_by']) AND in_array($_GET['order_by'], array('forename', 'surname', 'email'))) {
                    $order_by = $_GET['order_by'];
                } else {
                    $order_by = 'surname';
                }
                
                // Order direction...
                $order_dir = @$_GET['order_dir'] == 'desc' ? 'desc' : 'asc';
            
                // Order by stuff
                ${'order_by_' . $order_by} = ($order_dir == 'asc' ? '<img src="images/v-webmail/orderbyasc.gif" height="12" width="12">' : '<img src="images/v-webmail/orderbydesc.gif">');
            
                // Links
                $forename_link = 'addressbook.php?' . VWEBMAILSESSION . '&order_by=forename&order_dir=' . ($order_by == 'forename' && $order_dir == 'asc' ? 'desc' : 'asc');
                $surname_link  = 'addressbook.php?' . VWEBMAILSESSION . '&order_by=surname&order_dir='  . ($order_by == 'surname'  && $order_dir == 'asc' ? 'desc' : 'asc');
                $email_link    = 'addressbook.php?' . VWEBMAILSESSION . '&order_by=email&order_dir='    . ($order_by == 'email'    && $order_dir == 'asc' ? 'desc' : 'asc');

                // Do the sort
                $ab->sort($order_by, $order_dir == 'asc' ? 1 : 0);

                // And now get the addresses
                $addresses = array();
                if (!empty($ab->addresses)) {
                    foreach ($ab->addresses as $id => $values) {
                        // Check for filter
                        if (!empty($_GET['filter']) AND @!in_array($_GET['filter'], $values['categories'])) {
                            continue;
                        }

                        $link = $ab->createStringFromAddress($values);
                        $addresses[] = array_merge(array('uid' => $values['uid'], 'link' => urlencode($link)), $values);
                    }
                    $addresses = htmlspecialchars_r($addresses);
                }
                
                // Create categories for filter dropdown selection
                $allCategories = $ab->getCategoryList();

                $template = 'addressbook.list.html';

                /**
                * Create "All addresses" group members list
                */
                $all_addresses_group = array();
                foreach ($addresses as $a) {
                    $all_addresses_group[] = $ab->createLinkStringFromAddress($a);
                }
                $all_addresses_group = implode(', ', $all_addresses_group);
                
                /**
                * Get rest of groups
                */
                $grouplist = $ab->getGroupList();
        }
    }

/**
* Call the template
*/
    require($CONFIG['includes'] . 'template.wrapper.php');
?>
