<?php
/**
* Filename.......: addressbook.import.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/26 11:52:10 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');
	require($CONFIG['includes'] . 'vCard.php');

/*
* Check Login
*/
	auth::check_login('login.php', 'addressbook.import.php');

/*
* Check for any error msg
*/
	common::errorMsg($error_msg);

/*
* Get ab entries
*/
	$ab = &new addressbook();

/**
* Actions
*/
	switch (@$_GET['action']) {
		/**
        * Process the import
        */
		case 'process_import':
			if (@$_GET['type'] == 'attachment') {
				if (!empty($_GET['msg_id']) AND !empty($_GET['mime_id']) AND !empty($_GET['encoding']) AND !empty($_GET['ctype'])) {
					if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {
						/**
				        * Check the message exists
				        */
						if (!@$mailaccess->headerinfo($_GET['msg_id'])) {
							common::redirect('addressbook.php', lang('No such msg'));
						}
						
						/**
                        * Grab the attachment
                        */
						$body = decode_body($mailaccess->getPart($_GET['msg_id'], $_GET['mime_id']), strtolower($_GET['encoding']));
						
						/**
                        * Now process depending on what type of
						* attachment it is
                        */
						switch ($_GET['ctype']) {
							case 'application/vnd.v-webmail.addressbook':
								if (!empty($body) AND $body = unserialize($body) AND is_array($body)) {
									foreach ($body as $address) {
										$ab->importAddress($address);
									}
									$ab->save();
									common::redirect($_SERVER['HTTP_REFERER'], count($body) . lang(' addresses imported'));
		
								} else {
									common::redirect($_SERVER['HTTP_REFERER'], lang('Attachment was not found!'));
								}
								break;

							case 'text/x-vcard':
								if (!empty($body)) {
									$vCard = new vCard($body);
									
									// Name
									$name = $vCard->getFirstInstanceOf('N');
									$name = explode(';', $name->value);
									$address['title']    = $name[3];
									$address['forename'] = $name[1];
									$address['surname']  = $name[0];

									// Emails
									$emails = $vCard->getAllInstancesOf('EMAIL');
									for ($i=0; $i<count($emails) AND $i<3; $i++) {
										$address['email_' . ($i + 1)] = $emails[$i]->value;
									}
									$address['email'] = $address['email_1'];
									unset($address['email_1']);
									
									// Telephones
									$tels = $vCard->getAllInstancesOf('TEL');
									for ($i=0; $i<count($tels) AND $i<4; $i++) {
										if (!empty($tels[$i]->parameters['TYPE'])) {
											if (in_array('HOME', $tels[$i]->parameters['TYPE']) AND in_array('VOICE', $tels[$i]->parameters['TYPE'])) {
												$address['telephone_home'] = $tels[$i]->value;

											} elseif (in_array('WORK', $tels[$i]->parameters['TYPE']) AND in_array('VOICE', $tels[$i]->parameters['TYPE'])) {
												$address['telephone_work'] = $tels[$i]->value;

											} elseif (in_array('CELL', $tels[$i]->parameters['TYPE']) AND in_array('VOICE', $tels[$i]->parameters['TYPE'])) {
												$address['telephone_cell'] = $tels[$i]->value;

											} elseif (in_array('FAX', $tels[$i]->parameters['TYPE'])) {
												$address['telephone_fax'] = $tels[$i]->value;
											}
										}
									}
									
									// Address
									$adr = $vCard->getFirstInstanceOf('ADR');
									if (!empty($adr)) {
										$adr = explode(';', $adr->value);
										$address['street']   = $adr[2];
										$address['city']     = $adr[3];
										$address['province'] = $adr[4];
										$address['postcode'] = $adr[5];
										$address['country']  = $adr[6];
									}

									// Notes
									$note = $vCard->getFirstInstanceOf('NOTE');
									$address['notes'] = $note->value;
									
									// Categories
									$address['categories'] = $vCard->getCategories();
									
									// Import and save
									$ab->importAddress($address);
									$ab->save();
									
									common::redirect($_SERVER['HTTP_REFERER'], '1' . lang(' addresses imported'));
								}
								break;
						}

					} else {
						common::redirect($_SERVER['HTTP_REFERER'], lang('Failed to connect to account!'));
					}
				} else {
					common::redirect($_SERVER['HTTP_REFERER'], lang('Either msg_id or mime_id missing!'));
				}

			/**
            * Import form submitted
            */
			} elseif (@$_GET['type'] == 'csv') {
				if (@$_POST['source'] == 'file') {
					if (!empty($_FILES['import_file']['tmp_name']) AND $_FILES['import_file']['tmp_name'] !== 'none' AND $_FILES['import_file']['error'] == 0) {
						require_once($CONFIG['pear_dir'] . 'File.php');
						$csvData = File::readAll($_FILES['import_file']['tmp_name']);
					} else {
						switch (@$_FILES['import_file']['error']) {
							case 1:  $error_msg = lang('File exceeded maximum permissable size!'); break;
							case 2:  $error_msg = lang('File exceeded maximum permissable size!'); break;
							case 3:  $error_msg = lang('File was only partially uploaded!'); break;
							case 4:  $error_msg = lang('No file was uploaded'); break;
							default: $error_msg = lang('An unknown error occurred'); break;
						}
					}
				} elseif (@$_POST['source'] == 'text') {
					$csvData = $_POST['import_text'];
				} else {
					common::redirect('addressbook.import.php', lang('No CSV source was selected'));
				}
				
				/**
                * Now work out the format
                */
				if (!empty($_POST['fields'])) {

					$separator         = !empty($_POST['separator']) ? $_POST['separator'] : ',';
					$definedFieldCount = count($_POST['fields']);
					$csvLines          = preg_split('/\s*\r?\n\s*/', trim($csvData), -1, PREG_SPLIT_NO_EMPTY);

					$corruptLines = 0;
					$okLines      = 0;
					$lines        = array();

					// Lose header line ?
					if (@$_POST['ignore_header_line']) {
						array_shift($csvLines);
					}

					// Loop thru csv lines
					foreach ($csvLines as $line) {
						$fields = preg_split('/\s*' . preg_quote($separator) . '\s*/', trim($line));
						if (count($fields) != $definedFieldCount) {
							$corruptLines++;
							continue;
						} else {
							$okLines++;
							$lines[] = $fields;
						}
					}
					
					// Replace numeric keys with textual field names and import
					for ($i=0; $i<count($lines); $i++) {
						for ($j=0; $j<count($lines[$i]); $j++) {

							// Unescape commas also
							$fieldname = $_POST['fields'][$j];
							$value = str_replace('~', ',', $lines[$i][$j]);

							// Categories is an array
							if ($fieldname == 'categories') {
								$newvalue = array();
								if (!empty($value)) {
									$newvalue = explode(',', $value);
								}
								$value = $newvalue;
							}
							$addresses[$i][$fieldname] = $value;
						}
						$ab->importAddress($addresses[$i]);
					}

					$ab->save();

					// Redirect
					common::redirect('addressbook.php', $okLines . lang(' addresses imported'));

				} else {
					common::redirect('addressbook.import.php', 'No CSV fields specified!');
				}
			}
			break;

		default:
			break;
	}

/**
* Call the template
*/
	$template = 'addressbook.import.html';
	include($CONFIG['includes'] . 'template.wrapper.php');
?>
