<?php
/**
* Filename.......: addressbook.export.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/26 12:13:11 $
* CVS Revision...: $Revision: 1.4 $
* Copyright......: 2001-2004 Richard Heyes
*/

	include('config.php');

/*
* Check Login
*/
	auth::check_login('login.php', 'addressbook.export.php');

/*
* Check for any error msg
*/
	common::errorMsg($error_msg);

/*
* Get ab entries
* // FIXME This function contains migration code which will need
*          removing at some point.
*/
	$ab = &new addressbook();

/**
* Actions
*/
	switch (@$_GET['action']) {
		/**
        * Process the export
        */
		case 'process_export':
			if (!empty($ab->addresses)) {

                // Create the attachment and redirect to the compose page
				if (@$_GET['method']  == 'attachment') {
					$data = $ab->getSerializedExport(@$_GET['uids']);
	
					// Write addressbook to file
					include_once($CONFIG['pear_dir'] . 'File.php');
					$filename = File::getTempFile($CONFIG['tmp_dir']);
					if (File::write($filename, $data)) {
	
						$SESSION['email_compose']['files'][] = array(
																		'tmp_name' => $filename,
																		'size'     => strlen($data),
																		'c_type'   => 'application/vnd.v-webmail.addressbook',
																		'filename' => 'addressbook.dat',
																		'encoding' => 'base64'
																	);
						common::redirect('email.compose.php');
					} else {
						common::redirect('addressbook.export.php', 'Error attaching addressbook data');
					}
	
				// Create CSV and force download
				} elseif (@$_GET['method'] == 'csv') {

					$csvLines = array();
					$csvLines[] = 'TITLE,FORENAME,SURNAME,EMAIL,EMAIL_2,EMAIL_3,TEL_HOME,TEL_WORK,TEL_CELL,TEL_FAX,STREET,CITY,PROVINCE,POSTCODE,COUNTRY,NOTES,CATEGORIES';

					$uids = @$_GET['uids'];
					foreach ($ab->addresses as $address) {

						if (!empty($uids) && is_array($uids)) {
							// Skip records that are not selected
							if (!in_array($address['uid'], $uids)) {
								continue;
							}
						}

						$line = @array($address['title'],
						               $address['forename'],       $address['surname'],
									   $address['email'],          $address['email_2'],
									   $address['email_3'],        $address['telephone_home'],
									   $address['telephone_work'], $address['telephone_cell'],
									   $address['telephone_fax'],  $address['street'],
									   $address['city'],           $address['province'],
									   $address['postcode'],       $address['country'],
									   $address['notes'],          implode(',', $address['categories']));

						// Escape commas
						for($i=0; $i < sizeof($line); $i++) {
							$line[$i] = str_replace(',', '~', $line[$i]);
						}

						// Add CSV line
						$csvLines[] = preg_replace('/\r?\n/', '\\n', implode(',', $line));
					}
					
					/**
                    * Send headers and then dump the data
                    */
					header('Content-Type: text/csv');
					header('Content-Disposition: attachment; filename=addressbook.csv');
					echo implode("\r\n", $csvLines);
					exit;

				} else {
					common::redirect('redirect.php?to=addressbook.export.php', 'Please select an export method!');
				}
			} else {
				common::redirect('redirect.php?to=addressbook.export.php', 'No addresses to export!');
			}
			break;

		default:
			/**
			* Create the $addresses array for the select box
			*/
			foreach ($ab->addresses as $id => $values) {
				$address['name'] = $ab->getFullName($values) != '' ? $ab->getFullName($values) : $values['email'];
				$address['uid']  = $values['uid'];

				$addresses[] = $address;
			}
			
			if (empty($addresses)) {
				$addresses[] = array('name' => 'No addresses to export!', 'uid' => '');
			}
			break;
	}

/**
* Call the template
*/
	$template = 'addressbook.export.html';
	include($CONFIG['includes'] . 'template.wrapper.php');
?>
