<?php

include(realpath(dirname(__FILE__)) . '/config.php');
include_once(APP_FOLDER . 'content/PublicPollsContent.php');

/* Check if apoll is installed */
if (!Various::checkIfInstalled()){
     die("Apoll is not installed, please go to <a href='" . WEB_URL . "install/'>install folder</a> to install apoll.");
}

$pollClass = new PublicPollsContent();
$poll = $pollClass->viewDetails();
$settings = various::getMainSetings();

$cookie = isset($_COOKIE[$poll['identificator']]) ? $_COOKIE[$poll['identificator']] : 0;
$ipAddress = $_SERVER['REMOTE_ADDR'];
$webAddress = !empty($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : WEB_URL . "poll.php?id=" . $poll['pollID'];

if ($pollClass->checkIfUserVoteByIp($poll['pollID'], $ipAddress) != 0 || !empty($cookie)) {
	header("Location:" . $webAddress);
	die();
}

if ($pollClass->vote($poll['identificator'], $ipAddress)) {
	header("Location:" . $webAddress);
	die();
} else {
	die("Error while voteing!");
}

?>