<?php

include(realpath(dirname(__FILE__)) . '/config.php');
include_once(APP_FOLDER . 'content/PublicPollsContent.php');

/* Check if apoll is installed */
if (!Various::checkIfInstalled()){
     die("Apoll is not installed, please go to <a href='" . WEB_URL . "install/'>install folder</a> to install apoll.");
}

$pollClass = new PublicPollsContent();
$poll = $pollClass->viewDetails();
$settings = various::getMainSetings();
$smarty->assign("voteText", $settings['voteText']);

if (empty($poll)) {
	die("Empty or wrong id!");
}

$cookie = isset($_COOKIE[$poll['identificator']]) ? $_COOKIE[$poll['identificator']] : 0;
$ipAddress = $_SERVER['REMOTE_ADDR'];
$show = 0;

switch ($settings['blockBy']) {
	case 0:
		if (!empty($cookie)) {
			$show = 1;
		}
		break;
	case 1:
		if ($pollClass->checkIfUserVoteByIp($poll['pollID'], $ipAddress) != 0) {
			$show = 1;
		}
		break;
	case 2:
		default:
		if ($pollClass->checkIfUserVoteByIp($poll['pollID'], $ipAddress) != 0 || !empty($cookie)) {
			$show = 1;
		}
		break;
}

switch ($show) {
	case 0:
		default:
		$smarty->display("vote.tpl");
		break;
	case 1:
		$smarty->display("results.tpl");
		break;
}

?>