<?php
  
class AdminDashboard {
    
    public function __construct($function) {
      call_user_func(array($this, $function));
    }
    
    private function view() {
        global $smarty;
        
        $lastFivePolls = $this->dbGetLastFivePolls();
        $smarty->assign("lastFivePolls", $lastFivePolls);
        $qurrentPoll = $this->qurrentPoll();
        $smarty->assign("qurrentPoll", $qurrentPoll);
    }
    
    private function dbGetLastFivePolls() {
        global $dbe;
        
        $sql = "SELECT question, totalVotes
                FROM " . TABLE_PREFIX . "polls
                ORDER BY pollID DESC
                LIMIT 0,5";
        $polls = array();
        if ($result = $dbe->Execute($sql)) {
            while ($rs = $result->FetchRow()) {
                 $polls[] = $rs;
            }
        }
        return $polls;
    }
    
    private function qurrentPoll() {
        global $dbe;
        
        $sql = "SELECT pollID, question, totalVotes
                FROM " . TABLE_PREFIX . "polls
                ORDER BY pollID DESC
                LIMIT 0,1";
        $result = $dbe->Execute($sql);
        $poll = $result->FetchRow();
        $results = various::getPollResults($poll['pollID']);
        $results = various::getPollPercents($results, $poll['totalVotes']);
        $poll['results'] = $results;
        return $poll;
    }
}
?>