<?php
  
class AdminUsersContent {
    
    public function __construct($function) {
    	if (method_exists($this, $function)) {
    		call_user_func(array($this, $function));
    	}
    }
    
    private function listUsers() {
        global $smarty;
        
        $users = $this->dbGetUsers();
        $smarty->assign("users", $users);
    }
    
    private function addUsers() {
        global $smarty;
        
        if (isset($_POST['addUser'])) {
            $add = $this->dbAddUser();
            switch ($add) {
                case 0:
                    $smarty->assign("addError", "true");
                    break;
                case 1:
                    $smarty->assign("addSuccess", "true");
                    break;
                case 2:
                    $smarty->assign("passwordError", "true");
                    break;
                case 3:
                    $smarty->assign("emailError", "true");
                    break;
                case 4:
                    $smarty->assign("userExists", "true");
                    break;
            }
        }
    }
    
    private function detailsUsers() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        $user = $this->dbGetUserByID($id);
        $smarty->assign("user", $user);
    }
    
    private function editUsers() {
        global $smarty;
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        
        if (isset($_POST['editUser'])) {
            $edit = $this->dbEditUser($id);
            switch ($edit) {
                case 0:
                    $smarty->assign("editError", "true");
                    break;
                case 1:
                    $smarty->assign("editSuccess", "true");
                    break;
                case 2:
                    $smarty->assign("emailError", "true");
                    break;
                case 3:
                    $smarty->assign("userExists", "true");
                    break;
            }
        }
        
        if (isset($_POST['editPassword'])) {
            $edit = $this->dbEditUserPassword($id);
            new dBug($edit);
            switch ($edit) {
                case 0:
                    $smarty->assign("editPasswordError", "true");
                    break;
                case 1:
                    $smarty->assign("editPasswordSuccess", "true");
                    break;
                case 2:
                    $smarty->assign("wrongPassword", "true");
                    break;
                case 3:
                    $smarty->assign("passwordError", "true");
                    break;
            }
        }
        
        $user = $this->dbGetUserByID($id);
        $smarty->assign("user", $user);
    }
    
    private function deleteUsers() {
        global $smarty;
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        
        $delete = $this->dbDeleteUser($id);
        if ($delete) {
            $smarty->assign("deleteSuccess", "true");
        } else {
            $smarty->assign("deleteError", "true");  
        }
        
        $this->listUsers();
    }  
    
    private function dbDeleteUser($id) {
        global $dbe;
        
        $sql = "DELETE FROM " . TABLE_PREFIX . "users
                WHERE userID = '$id'";
        if ($dbe->Execute($sql)) {
            return 1;
        }
        return 0;
    }
    
    private function dbEditUserPassword($id) {
        global $dbe;
        
        $password = !empty($_POST['password']) ? strip_tags($_POST['password']) : '';
        $password = addslashes(substr($password, 0, 32));
        $password = md5($password);
        $password_again = !empty($_POST['password_again']) ? strip_tags($_POST['password_again']) : '';
        $password_again = addslashes(substr($password_again, 0, 32));
        $password_again = md5($password_again);
        $old_password = !empty($_POST['old_password']) ? strip_tags($_POST['old_password']) : '';
        $old_password = addslashes(substr($old_password, 0, 32));
        $old_password = md5($old_password);
        $userPassword = $this->dbGetUserPassword($id);
        
        if ($userPassword !== $old_password) {
            return 2;
        }
        
        if ($password !== $password_again) {
            return 3;
        }
        
        $sql = "UPDATE " . TABLE_PREFIX . "users
                SET password = '$password'
                WHERE userID = '$id'";
        if ($dbe->Execute($sql)) {
            return 1;
        }
        return 0;
    }
    
    private function dbGetUserPassword($id) {
        global $dbe;
        
        $sql = "SELECT password
                FROM " . TABLE_PREFIX . "users
                WHERE userID = '$id'";
        return $dbe->GetOne($sql);
    }
    
    private function dbEditUser($id) {
        global $dbe;
        
        $firstname = !empty($_POST['firstname']) ? strip_tags($_POST['firstname']) : '';
        $firstname = addslashes(substr($firstname, 0, 32));
        $lastname = !empty($_POST['lastname']) ? strip_tags($_POST['lastname']) : '';
        $lastname = addslashes(substr($lastname, 0, 32));
        $username = !empty($_POST['username']) ? strip_tags($_POST['username']) : '';
        $username = addslashes(substr($username, 0, 32));
        $email = !empty($_POST['email']) ? strip_tags($_POST['email']) : '';
        $email = addslashes(substr($email, 0, 64));
        $user = $this->dbGetUserByID($id);
        
        if (!various::validateEmail($email)) {
            return 2;
        }
        
        if (various::checkIfUserExists($username, $email) && ($user['username'] !== $username OR $user['email'] !== $email)) {
            return 3;
        }
        
        $sql = "UPDATE " . TABLE_PREFIX . "users
                SET firstname = '$firstname', lastname = '$lastname', username = '$username', email = '$email'
                WHERE userID = '$id'";
        if ($dbe->Execute($sql)) {
            return 1;
        }
        return 0;
    } 
    
    private function dbGetUserByID($id) {
        global $dbe;
        
        $sql = "SELECT userID, firstname, lastname, username, email
                FROM " . TABLE_PREFIX . "users
                WHERE userID = '$id'";
        $result = $dbe->Execute($sql);
        return $result->FetchRow($sql);
    }
    
    private function dbAddUser() {
        global $dbe;
        
        $firstname = !empty($_POST['firstname']) ? strip_tags($_POST['firstname']) : '';
        $firstname = addslashes(substr($firstname, 0, 32));
        $lastname = !empty($_POST['lastname']) ? strip_tags($_POST['lastname']) : '';
        $lastname = addslashes(substr($lastname, 0, 32));
        $username = !empty($_POST['username']) ? strip_tags($_POST['username']) : '';
        $username = addslashes(substr($username, 0, 32));
        $password = !empty($_POST['password']) ? strip_tags($_POST['password']) : '';
        $password = addslashes(substr($password, 0, 32));
        $password = md5($password);
        $password_again = !empty($_POST['password_again']) ? strip_tags($_POST['password_again']) : '';
        $password_again = addslashes(substr($password_again, 0, 32));
        $password_again = md5($password_again);
        $email = !empty($_POST['email']) ? strip_tags($_POST['email']) : '';
        $email = addslashes(substr($email, 0, 64));
        
        if ($password !== $password_again) {
            return 2;
        }
        
        if (!various::validateEmail($email)) {
            return 3;
        }
        
        if (various::checkIfUserExists($username, $email)) {
            return 4;
        }
        
        $sql = "INSERT INTO " . TABLE_PREFIX . "users
                (firstname, lastname, username, password, email)
                VALUES
                ('$firstname', '$lastname', '$username', '$password', '$email')";
        if ($dbe->Execute($sql)) {
            return 1;
        }
        return 0;
    }
    
    private function dbGetUsers() {
        global $dbe;
        
        $sql = "SELECT userID, username
                FROM " . TABLE_PREFIX . "users";
        $users = array();
        if ($result = $dbe->Execute($sql)) {
            while ($rs = $result->FetchRow()) {
                $rs['polls'] = $this->numUserPolls($rs['userID']);
                $users[] = $rs;
            }
        }
        return $users;
    }
    
    private function numUserPolls($id) {
        global $dbe;
        
        $sql = "SELECT count(*)
                FROM " . TABLE_PREFIX . "polls
                WHERE authorID = '$id'";
        return $dbe->GetOne($sql);
    }
}
  
?>