<?php

include_once(APP_FOLDER . 'content/PollsContent.php');

class AdminPollsContent extends PollsContent {
    
    public function __construct($function) {
    	if (method_exists($this, $function)) {
    		call_user_func(array($this, $function));
    	}
    }
    
    private function listPolls() {
        global $smarty;
        
        $polls = $this->dbGetPolls();
        $smarty->assign("polls", $polls);
    }
    
    private function editPolls() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        if (isset($_POST['editPoll'])) {
            $update = $this->dbUpdatePoll($id);
            switch ($update) {
                case 0:
                    $smarty->assign("editError", true);
                    break;
                case 1:
                    $smarty->assign("editSuccess", true);
                    break;
            }
        }
        $poll = $this->dbGetPoll($id);
        $smarty->assign("poll", $poll);
    }
    
    private function dbUpdatePoll($id) {
        global $dbe;
        
        $question = $_POST['question'];
        
        $sql = "UPDATE " . TABLE_PREFIX . "polls
                SET question = '$question'
                WHERE pollID = '$id'";
        if ($dbe->Execute($sql)) {
            $answers = $_POST['answers'];
            $i = 0;
            foreach ($answers as $tmp) {
                $key = array_keys($answers);
                $key = $key[$i];
                $tmp = strip_tags($tmp);
                $tmp = addslashes(substr($tmp, 0, 128));
                $sql = "UPDATE " . TABLE_PREFIX . "results
                        SET value = '$tmp' WHERE id = '$key'";
                $dbe->Execute($sql);
                $i++;
            }
            return true;
        }
        return false;
    }
    
    private function detailsPolls() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        $poll = $this->dbGetPoll($id);
        $smarty->assign("poll", $poll);
    }
    
    private function activePolls() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0; 
        $active = $this->dbActivePoll($id);
        switch ($active) {
            case 0:
                $smarty->assign("activeError", true);
                break;
            case 1:
                $smarty->assign("activeSuccess", true);
                break;
        }
        $this->listPolls();
    }
    
    private function dbActivePoll($id) {
        global $dbe;
        
        $sql = "UPDATE " . TABLE_PREFIX . "polls
                SET status = '1'
                WHERE pollID = '$id'";
        if ($dbe->Execute($sql)) {
            return true;
        }
        return false;
    }
    
    private function deactivePolls() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0; 
        $deactive = $this->dbDeactivePoll($id);
        switch ($deactive) {
            case 0:
                $smarty->assign("deactiveError", true);
                break;
            case 1:
                $smarty->assign("deactiveSuccess", true);
                break;
        }
        $this->listPolls();
    }
    
    private function dbDeactivePoll($id) {
        global $dbe;
        
        $sql = "UPDATE " . TABLE_PREFIX . "polls
                SET status = '0'
                WHERE pollID = '$id'";
        if ($dbe->Execute($sql)) {
            return true;
        }
        return false;
    }
    
    private function deletePolls() {
        global $smarty;
        
        $id = !empty($_GET['id']) ? (int)$_GET['id'] : 0;
        $delete = $this->dbDeletePoll($id);
        switch ($delete) {
            case 0:
                $smarty->assign("deleteError", true);
                break;
            case 1:
                $smarty->assign("deleteSuccess", true);
                break;
        }
        $this->listPolls();
    }
    
    private function dbDeletePoll($id) {
        global $dbe;
        
        $sql = "DELETE FROM " . TABLE_PREFIX . "polls
                WHERE pollID = '$id' AND status = '0'";
        if ($dbe->Execute($sql)) {
            $sql = "DELETE FROM " . TABLE_PREFIX . "results
                    WHERE fk_pollID = '$id'";
            $dbe->Execute($sql);
            return true;
        }
        return false;
    }
    
    private function addPolls() {
        global $smarty, $dbe;
        
        if (isset($_POST['addPoll'])) {
            $add = $this->dbAddPoll();
            if (empty($add)) {
               $smarty->assign("addError", true); 
            }
            else {
               $smarty->assign("addSuccess", true);
               $smarty->assign("pollID", $add); 
            }
        }
    }
    
    private function dbAddPoll() {
        global $dbe;
        
        $question = !empty($_POST['question']) ? strip_tags($_POST['question']) : '';
        $question = addslashes(substr($question, 0, 64));
        $answer = is_array($_POST['answer']) ? $_POST['answer'] : array();
        $userID = various::getUserID();
        $time = time();
        
        $sql = "INSERT INTO " . TABLE_PREFIX . "polls
                (question, totalVotes, authorID, createTime, status)
                VALUES
                ('$question', '0', '$userID', '$time', '1')";
        if (!$dbe->Execute($sql)) {
            return 0;
        }
        
        $pollID = $dbe->Insert_ID();
        $pollIdentification = "ap_" . $pollID . "_" . rand(1000, 9999);
        
        $sql = "UPDATE " . TABLE_PREFIX . "polls
        		SET identificator = '$pollIdentification'";
        $dbe->Execute($sql);
        
        $answersSql = '';
        foreach ($answer as $tmp) {
            $tmp = strip_tags($tmp);
            $tmp = addslashes(substr($tmp, 0, 128));
            if (!empty($tmp)) {
                if (empty($answersSql)) {
                    $answersSql = "('$pollID', '$tmp', '0')";
                } else {
                    $answersSql .= ", ('$pollID', '$tmp', '0')";
                }
            }
        }
        
        $sql = "INSERT INTO " . TABLE_PREFIX . "results
                (fk_pollID, value, votes)
                VALUES
                $answersSql";
        if ($dbe->Execute($sql)) {
            return $pollID;
        }
        return 0;
    }
    
    private function dbGetPolls() {
        global $dbe;
        
        $sql = "SELECT pollID, question, totalVotes, createTime, status
                FROM " . TABLE_PREFIX . "polls
                ORDER BY pollID DESC";
        $polls = array();
        if ($result = $dbe->Execute($sql)) {
            while ($rs = $result->FetchRow()) {
                $rs['time'] = date("y/m/d", $rs['createTime']);
                $polls[] = $rs;
            }
        }
        return $polls;
    }
}
  
?>