<?php
  
include(realpath(dirname(__FILE__)) . '/config.php');

/* Check if apoll is installed */
if (!Various::checkIfInstalled()){
     die("Apoll is not installed, please go to <a href='" . WEB_URL_ROOT . "install/'>install folder</a> to install apoll.");
}

/* Session info */
$sessionID = !empty($_SESSION['ap_sesid']) ? substr($_SESSION['ap_sesid'], 0, 32) : 0;
$status = !empty($_SESSION['ap_status']) ? $_SESSION['ap_status'] : 0;
$username = !empty($_SESSION['ap_username']) ? $_SESSION['ap_username'] : 0;

/* Get language files */
$language = various::getAdminLanguage();
$smarty->assign("language", $language);
@include (LANG_FOLDER . $language . '/language.php');
$smarty->assign("lang", $lang); 

/* Check User */
if (!various::checkIfUserIsLogged($sessionID)) {
    if (isset($_POST['login'])) {
        if (!various::loginUser()) {
            $smarty->display("login.tpl");
            die();
        }
    } else {
        $smarty->display("login.tpl");
        die();
    }
}

/* Available values */
$showValues = array("content");
$classValues = array("settings", "users", "polls");

/* Get values */
$show = empty($_GET['show']) ? '' : $_GET['show'];
$class = empty($_GET['class']) ? '' : $_GET['class'];
$view = empty($_GET['view']) ? '' : $_GET['view'];

/* Init content */
if ($show == 'dashboard' OR empty($show)) {
    $show = 'dashboard';
    $className = 'AdminDashboard';
    $param = 'view';
    include(APP_FOLDER . 'dashboard/' . $className . '.php');
    $class = new $className($param);
    $smarty->assign("show", $show);
    $smarty->display("index.tpl");
} else if ($show == 'logout') {
    session_destroy();
    header("Location:" . WEB_URL);
    die();
} else if (!empty($show) && in_array($show, $showValues) && !empty($class) && in_array($class, $classValues)) {
    $className = 'Admin' . ucfirst($class) . ucfirst($show);
    $param = $view . ucfirst($class);
    $smarty->assign("show", $show);
    $smarty->assign("class", $class);
    $smarty->assign("view", $view);
    $smarty->assign("param", $param);
    include (APP_FOLDER . $show . '/' . $className . '.php');
    $class = new $className($param);
    $smarty->display("index.tpl");
}

?>