<?php

/* Important constants */
$dirName = dirname($_SERVER['SCRIPT_NAME']) == "/" ? "/" : dirname($_SERVER['SCRIPT_NAME']) . "/";
$dirName = preg_replace("~\\\~", "/", $dirName);
$dirName = preg_replace("~//~", "/", $dirName);
define("WEB_URL", "http://" . $_SERVER['HTTP_HOST'] . $dirName);
define("WEB_URL_ROOT", preg_replace("~admin/~", "", WEB_URL));
define("ROOT", realpath(dirname(__FILE__)) . "/../");
define("APP_FOLDER", ROOT . "application/");
define("LANG_FOLDER", ROOT . "languages/");  
define("LIBRARY", ROOT . "libs/");
define("THEMES_FOLDER", ROOT . "themes/admin/");
define("THEMES_PUBLIC_FOLDER", ROOT . "themes/public/");

/* Include libs */
include (LIBRARY . 'dBug/dBug.php');
include(LIBRARY . 'adolite/adodb.inc.php');
include(LIBRARY . 'smarty/Smarty.class.php');

/* Import various functions */
include(APP_FOLDER . 'various/various.php');

/* Include global config file */
include(ROOT . 'global_config.php');

/* Configure AdoDB */
$dbe = ADONewConnection('mysql', 'pear');
$result = $dbe->Connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
$dbe->SetFetchMode(ADODB_FETCH_ASSOC);
$dbe->_logsql = false;
//$dbe->debug = true;
if (!$dbe) {
  die('Could not connect to database!');
}

/* Get Theme */
$theme = various::getAdminTheme();

/* Configure smarty */
$smarty = new Smarty;
$smarty->compile_check = true;
//$smarty->compile_check = false;
$smarty->debugging = false;
$smarty->security_settings['ALLOW_CONSTANTS'];
//$smarty->debugging = true;

$smarty->compile_dir = ROOT . "cache/admin/";
$smarty->template_dir = ROOT . "themes/admin/" . $theme . "/";

$smarty->left_delimiter = '{{';
$smarty->right_delimiter = '}}';

$smarty->assign("templateUrl", WEB_URL . '../themes/admin/' . $theme . '/');

?>