<?php
	
///////////////////////////////////////////////////////////////////
//
// Class for connecting, performaing database opertions.
//
// License: Visit http://www.uloki.com/license.php, See LICENSE.
//////////////////////////////////////////////////////////////////

/**
 * ULoKI PHP Poll - PHP database class
 * @package ULoKI PHP Pol Script
 * @subpackage Database
 * @author Umakant Patil (umakantpatil4@rediffmail.com)
 */

 
class ulokidb 
{
	
    /** 
	 * Stores database link resource.
     * @access private
     */	
	var $dblink;

	/**
	 * Stores last query made
	 */
	var $last_query;

	/**
	 * Stores number of rows in last query executed
	 */
	var $last_num_rows;
		
	
	/**
	 * Connects to database, with database selection
	 * PHP 4 constructor calls php 5 constructor
	 */
	function ulokidb($hostname,$dbuser,$dbpass,$dbname) {
		return $this->__construct($hostname,$dbuser,$dbpass,$dbname);
	}

	/** 
	 * Connects to database and selects db. If connection successfull then returns resource link,
	 * else echo's error's and returns false.
	 * PHP 5 constructor
	 *
	 * @param string $hostname MySQL hostname
	 * @param string $dbuser MySQL username
	 * @param string $dbpass MySQL password
	 * @param string $dbname MySQL database name
	 * @return bool
	 */	
	function __construct($hostname,$dbuser,$dbpass,$dbname) {
		global $config; 
		if(!$this->dblink) {
			if($this->dblink=mysql_connect($hostname,$dbuser,$dbpass)){
				if(mysql_select_db($dbname,$this->dblink)){
					return $this->dblink;
				}else{
					die("Database cant be selected.");
					return false;				
				}
			}
			else{
				die("No connection can be established.");
				return false;
			}
		}
		else{
			return $this->dblink;
		}		
	}	



	/**
	 * Executes the SELECT query using current connection and returns array. 
	 * If array is empty then returns false
	 *
	 * @param string $query SELECT query
	 * @return bool
	 */
	function select($query){
		$result2=mysql_query($query,$this->dblink);
		$result3=mysql_num_rows($result2);
		if($result3 > 0){
			while($row=mysql_fetch_object($result2)){
				if($row){
					$result[] = $row;
				}
			}
			return $result;
		}
		return false;
	}


	/**
	 *Executes the SELECT query using current connection for 1 row selection and returns 1 array row. 
	 * If array is empty then returns false
	 *
	 * @param string $query SELECT query having LIMIT 0,1
	 * @return bool
	 *
	 */
	function get_row($query){
		
		$result2=mysql_query($query,$this->dblink);
		$result3=mysql_num_rows($result2);
		if($result3 > 0){
			$result=mysql_fetch_object($result2);
			return $result;
		}else{
			return false;
		}
			
	}

	/**
	 * COUNTS number of rows using SELECT rows. 
	 *
	 * @param string $query SELECT query
	 * @return integer
	 *
	 */	
	function count_rows($query){

		$count2=mysql_query($query,$this->dblink);
		$count=(int) mysql_num_rows($count2);
		return $count;
	}

	/**
	 * INSERT or REPLACE query can be passed and executed, returns insertid
	 *
	 * @param string $query INSERT query
	 * @return integer 
	 *
	 */		
	function insert_data($query){
		$insert=mysql_query($query,$this->dblink);
		$insertdata=mysql_insert_id($this->dblink);
		return $insertdata;
	}

	/**
	 * UPDATE or ALTER query can be passed and executed, returns total affected rows
	 *
	 * @param string $query UPDATE query
	 * @return integer 
	 *
	 */	
	function update_data($query){
		$result2=mysql_query($query,$this->dblink);
		$result=mysql_affected_rows($this->dblink);
		return $result;
	}

	/**
	 * DELETE query can be passed and executed, returns true if executed and false if not error.
	 *
	 * @param string $query DELETE query
	 * @return bool 
	 *
	 */		
	function delete_data($query){
		if(mysql_query($query,$this->dblink))
			return true;
		
		return false;	
	}

	
}

$db = new ulokidb($config->host,$config->dbuser,$config->dbpass,$config->dbname);


?>