<?php
/*
Aplomb Poll - Version 1.1
Copyright (C) 2003 Aplomb Scripts
http://www.global-centre.com/aplomb/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

require_once("functions/general.php");
$exectime['start'] = GetTime();
require ("config.php");


function PrintHeader() {
?>



<!-- Start HTML Header -->
<html>
<head>
<title>Aplomb Poll 1.1</title>
<style type="text/css">p, table, tr, td, h6, input, option, select, textarea { font-family: Verdana, Arial, Helvetica, sans-serif; }.copyright { color: #000000; font-size: 8pt; font-family: Verdana, Arial, Helvetica, sans-serif; }a:link, a:visited, a:active { color: #336699; font-family: Verdana, Arial, Helvetica, sans-serif; text-decoration: underline; }a:hover { color:#990000; font-family: Verdana, Arial, Helvetica, sans-serif; text-decoration: underline; }</style>
</head>
<body>
<!-- End HTML Header -->



<?php
}

function PrintFooter() {
global $exectime;
$exectime['end'] = GetTime();
$exectime = CalcTime($exectime);
echo '<p class="copyright">Powered by <a href="http://www.global-centre.com/aplomb/">Aplomb Poll</a> 1.1. Took '.$exectime.' seconds.</p>';
?>



<!-- Start HTML Footer -->
</body>
</html>
<!-- End HTML Footer -->



<?php
}

function Error($error) {
PrintHeader();
echo '<table border="0" cellpadding="5" width="100%" cellspacing="0"><tr><th style="background-color: #A72305; color: #FFFFFF; text-align: left;">Poll Error</th></tr><tr><td>'.$error.'<br /><br />If you have any queries, please contact the webmaster.<br /><br /><a href="javascript:history.back()">Back</a> | <a href="'.$settings['siteurl'].'">Return to Site</a></td></tr></table>';
PrintFooter();
exit;
}

// Perform Basic Checks

if ($_POST['poll'] == "") {
Error ("No poll specified.");
}

if (!file_exists("db/".$_POST['poll'])) {
Error ("Poll does not exist.");
}

if ($_POST['pollanswer'] == "") {
Error ("You did not place a vote.");
}

if ($_POST['pollanswer'] != "3" AND $_POST['pollanswer'] != "5" AND $_POST['pollanswer'] != "7" AND $_POST['pollanswer'] != "9" AND $_POST['pollanswer'] != "11" AND $_POST['pollanswer'] != "13" AND $_POST['pollanswer'] != "15" AND $_POST['pollanswer'] != "17" AND $_POST['pollanswer'] != "19" AND $_POST['pollanswer'] != "21") {
Error ("You did not place a valid vote.");
}

// Open the Poll File
$filep = fopen ("db/".$_POST['poll'], "r");
$contents = fread ($filep, filesize ("db/".$_POST['poll']));
fclose ($filep);
$contents = explode("|", $contents);

if ($contents['1'] == "0") {
Error ("This poll is locked. You cannot vote on a locked poll.");
}

// Add the vote..
switch ($_POST['pollanswer']) {
case '3':
++$contents['4'];
break;
case '5':
++$contents['6'];
break;
case '7':
++$contents['8'];
break;
case '9':
++$contents['10'];
break;
case '11':
++$contents['13'];
break;
case '13':
++$contents['14'];
break;
case '15':
++$contents['16'];
break;
case '17':
++$contents['18'];
break;
case '19':
++$contents['20'];
break;
case '21':
++$contents['22'];
break;
}

// Increase the amount of votes
++$contents['2'];

// Write
$contentsw = implode ("|", $contents);
$filep = fopen ("db/".$_POST['poll'], "w");
fwrite ($filep, $contentsw);
fclose ($filep);

// Display Message
PrintHeader();
echo '<table border="0" cellpadding="5" width="100%" cellspacing="0"><tr><th style="background-color: #A72305; color: #FFFFFF; text-align: left;">Thanks for your vote!</th></tr><tr><td><b>'.$contents['0'].'</b><br />Total Votes: '.$contents['2'].'<br />';

function PrintResult($id) {
global $contents;
$percent = number_format((($contents[$id] / $contents['2']) * 100), 1);
return '('.$contents[$id].' votes)'.' '.$percent.'% <img src="bar.gif" height="10" width="'.($percent * 3).'" />';
}

// Results
if ($contents['3'] != "") {echo "<p><b>".$contents['3']."</b> ".PrintResult("4")."</p>";}
if ($contents['5'] != "") {echo "<p><b>".$contents['5']."</b> ".PrintResult("6")."</p>";}
if ($contents['7'] != "") {echo "<p><b>".$contents['7']."</b> ".PrintResult("8")."</p>";}
if ($contents['9'] != "") {echo "<p><b>".$contents['9']."</b> ".PrintResult("10")."</p>";}
if ($contents['11'] != "") {echo "<p><b>".$contents['11']."</b> ".PrintResult("12")."</p>";}
if ($contents['13'] != "") {echo "<p><b>".$contents['13']."</b> ".PrintResult("14")."</p>";}
if ($contents['15'] != "") {echo "<p><b>".$contents['15']."</b> ".PrintResult("16")."</p>";}
if ($contents['17'] != "") {echo "<p><b>".$contents['17']."</b> ".PrintResult("18")."</p>";}
if ($contents['19'] != "") {echo "<p><b>".$contents['19']."</b> ".PrintResult("20")."</p>";}
if ($contents['21'] != "") {echo "<p><b>".$contents['21']."</b> ".PrintResult("22")."</p>";}

echo '<a href="javascript:history.back()">Back</a> | <a href="'.$settings['siteurl'].'">Return to Site</a></td></tr></table>';
PrintFooter();
?>