<?php
/*
Aplomb Poll - Version 1.1
Copyright (C) 2003 Aplomb Scripts
http://www.global-centre.com/aplomb/

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class AdminTools extends HTML {

function Execute() {
	// What do you want to do?
	switch ($_GET['do']) {
	case 'masslock':
		$this->MassLock();
	break;
	case 'massunlock':
		$this->MassUnlock();
	break;
	case 'resetvotes':
		$this->ResetVotes();
	break;
	case 'deletepolls':
		$this->DeletePolls();
	break;
	case 'backup':
		$this->BackUpData();
	break;
	case 'restore':
		$this->RestoreData();
	break;
	case 'filecheck':
		$this->CheckFiles();
	break;
	case 'extensioncheck':
		$this->CheckExtensions();
	break;
	default:
		$this->Index();
	}
}

function Index() {
	// Admin CP Tools Page
	echo "<p><b>Tools</b>".$this->tooltip("tools")."</p>";
	echo 'Select a tool:<br /><a href="admin.php?adact=tools&do=masslock">Mass Poll Lock</a>'.$this->tooltip("masslock").'<br /><a href="admin.php?adact=tools&do=massunlock">Mass Poll Unlock</a>'.$this->tooltip("massunlock").'<br /><a href="admin.php?adact=tools&do=resetvotes">Reset Poll Votes</a>'.$this->tooltip("resetvotes").'<br /><a href="admin.php?adact=tools&do=deletepolls">Delete all polls</a>'.$this->tooltip("deleteall").'<br /><a href="admin.php?adact=tools&do=backup">Backup Poll Data</a>'.$this->tooltip("backup").'<br /><a href="admin.php?adact=tools&do=restore">Restore Poll Data</a>'.$this->tooltip("restore").'<br /><a href="admin.php?adact=tools&do=filecheck">File Checker</a>'.$this->tooltip("filechecker").'<br /><a href="admin.php?adact=tools&do=extensioncheck">Extension Checker</a>'.$this->tooltip("extensionchecker");
}

function MassLock() {
	// Locks all polls
	echo "<p><b>Tools - Mass Poll Lock</b>".$this->tooltip("masslock")."</p>";
	if ($_GET['confirm'] == "yes") {
		$handle = opendir("db");
			while (false !== ($file = readdir($handle))) { 
				if ($this->pollexists($file)) { 
					$contents = $this->readpollfile($file);
					if ($contents['1'] == "1") {
						$contents['1'] = "0";
						$this->writefilearray($file, $contents);
					}
				}
			}
		closedir ($handle);

		echo 'All polls locked.<br /><a href="admin.php?adact=tools">Back to Tools Page</a>';
	}
	else {
		echo 'Are you sure you want to lock all polls? <br /><a href="admin.php?adact=tools&do=masslock&confirm=yes">Yes</a> | <a href="javascript:history.back()">No</a>';
	}
}

function MassUnlock() {
	// Unlocks all polls
	echo "<p><b>Tools - Mass Poll Unlock</b>".$this->tooltip("masslock")."</p>";
	if ($_GET['confirm'] == "yes") {
		$handle = opendir("db");
			while (false !== ($file = readdir($handle))) { 
				if ($this->pollexists($file)) { 
					$contents = $this->readpollfile($file);
					if ($contents['1'] == "0") {
						$contents['1'] = "1";
						$this->writefilearray($file, $contents);
					}
				}
			}
		closedir ($handle);

		echo 'All polls unlocked.<br /><a href="admin.php?adact=tools">Back to Tools Page</a>';
	}
	else {
		echo 'Are you sure you want to unlock all polls? <br /><a href="admin.php?adact=tools&do=massunlock&confirm=yes">Yes</a> | <a href="javascript:history.back()">No</a>';
	}
}
function ResetVotes() {
	// Resets the votes in all the polls to 0.
	echo "<p><b>Tools - Reset Poll Votes</b>".$this->tooltip("masslock")."</p>";
	if ($_GET['confirm'] == "yes") {
		$handle = opendir("db");
			while (false !== ($file = readdir($handle))) { 
				if ($this->pollexists($file)) { 
					$contents = $this->readpollfile($file);
					$contents['2'] = "0";
					$contents['4'] = "0";
					$contents['6'] = "0";
					$contents['8'] = "0";
					$contents['10'] = "0";
					$contents['12'] = "0";
					$contents['14'] = "0";
					$contents['16'] = "0";
					$contents['18'] = "0";
					$contents['20'] = "0";
					$contents['22'] = "0";
					$this->writefilearray($file, $contents);
				}
			}
		closedir ($handle);
		echo 'All votes in polls reset.<br /><a href="admin.php?adact=tools">Back to Tools Page</a>';
	}
	else {
		echo 'Are you sure you want to reset votes in all polls? <br /><a href="admin.php?adact=tools&do=resetvotes&confirm=yes">Yes</a> | <a href="javascript:history.back()">No</a>';
	}
}
function DeletePolls() {
	// Deletes all the polls
	echo "<p><b>Tools - Delete All Polls</b>".$this->tooltip("deleteall")."</p>";
	if ($_GET['confirm'] == "yes") {
		$handle = opendir("db");
			while (false !== ($file = readdir($handle))) { 
				if ($this->pollexists($file)) { 
					if (@unlink ("db/".$file)) { echo $file." deleted<br />"; } else { echo "Could not delete ".$file."<br />"; }
				}
			}
		closedir ($handle);
	}
	else {
		echo 'Are you sure you want to delete all polls? <br /><a href="admin.php?adact=tools&do=deletepolls&confirm=yes">Yes</a> | <a href="javascript:history.back()">No</a><br /><br />Are you sure you want to delete all existing polls? This will delete all poll information, including questions, answers, and amount of votes. After deleting, there is no way of recovering the poll information, unless you have made a backup. If you simply wish to stop users from voting, use the Mass Poll Lock tool.';
	}
}

function BackupOutput($message) {
	// Output a backup status message
	echo '<span style="color:#c0c0c0">['.date("d/m/y H:i:s O").']</span> '.$message.'<br />';
}

function BackUpError($message) {
	// Output a backup error message
	echo '<span style="color:red">['.date("d/m/y H:i:s O").'] '.$message.'</span><br />';
}

function BackUpData() {
	if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		// Make a few changes to Directory name
		$_POST['backupname'] = $this->makesafedir($_POST['backupname']);
		// Check for a valid directory name
		if ($_POST['backupname'] == "") {
			echo "You didn't specify a valid backup name.<br />";
		}
		// And also check if the directory exists too
		else if (file_exists("backup/".$_POST['backupname'])) {
			echo "This backup name is already being used, please choose another.<br />";
		}
		// Do the backing up if checks successful
		else {
			$errors = "0";
			$this->BackUpOutput("Starting Backup...");
			if ($errors == "0") {if (@mkdir ("backup/".$_POST['backupname'])) { $this->BackUpOutput("backup/".$_POST['backupname']." created"); } else { $this->BackUpError("Could not create backup/".$_POST['backupname']); ++$errors; } }
			if ($errors == "0") {if ($data = opendir ("db")) { $this->BackUpOutput("Opening db/ folder"); } else { $this->BackUpError("Could not open db folder"); ++$errors; } }
			if ($errors == "0") {
				// If Compression is wanted and ZLIB is loaded
				if ($_POST['compress'] == "yes" AND extension_loaded("zlib") ) {
					while (($file = readdir($data)) !== false) {
						if ($file != "." AND $file != ".." AND $file != "index.html") {
							$fp = fopen("db/".$file, "r");
							$original = fread($fp, filesize("db/".$file));
							fclose($fp);
							$gzdata = gzencode($original, 9);
							$fp = fopen("backup/".$_POST['backupname']."/".$file.".gz", "w");
							fwrite($fp, $gzdata);
							fclose($fp);
							$this->BackUpOutput($file." compressed and backed up");
						}
					}

					$fp = fopen ("backup/".$_POST['backupname']."/compress.txt", "w");
					fwrite ($fp, "yes");
					fclose ($fp);
				}
				// Copy File if Compression not chosen
				else {while (($file = readdir($data)) !== false) {
					if ($file != "." AND $file != ".." AND $file != "index.html") {
						if (@copy ("db/".$file, "backup/".$_POST['backupname']."/".$file)) {
  							$this->BackUpOutput($file." backed up");
						}
					}
				}}
			}
			@closedir ($data);$this->BackUpOutput("Closing db/ folder");

			if ($errors == "0") {$this->BackUpOutput("Backup Complete");}
		}

	echo '<a href="admin.php?adact=tools">Back to Tools Page</a>';
	}
	else {
		// Form with Backup options
		echo "<p><b>Tools - Backup Poll Data</b>".$this->tooltip("backup")."</p>";
		echo '<form action="admin.php?adact=tools&do=backup" method="post"><table cellspacing="0" border="0"><tr><td>Backup Name:</td><td><input type="text" name="backupname" /></td></tr><tr><td>Backup Options:</td><td>';
if (extension_loaded('zlib')) {
echo '<input type="checkbox" name="compress" value="yes" /> Compress Poll Data';
} else {
echo '<input type="checkbox" name="compress" value="yes" disabled="disabled" /> Compress Poll Data (You do not have the required ZLIB library)';
}
echo '</td></tr></table><input type="submit" value="Start Backup" /></form>';
	}
}

function RestoreData() {
	echo "<p><b>Tools - Restore Poll Data</b>".$this->tooltip("restore")."</p>";
	if ($_SERVER['REQUEST_METHOD'] == 'POST') {
		// Lets to the actual Restore thing then
		if (!file_exists("backup/".$_GET['backup']) OR $_GET['backup'] == "index.html") {
			echo "The chosen Backup does not exist.";
		}
		else if (file_exists("backup/".$_GET['backup']."/compress.txt") AND !extension_loaded("zlib")) {
			echo "You have chosen to restore a compressed backup. The ZLib extension was not detected. Please install/activate the Zlib extension before continuing.";
		}
		else {
			$this->BackUpOutput("Starting restore of backup");

			// Checks Complete - If files compressed, set $unzip to 1
			if (file_exists("backup/".$_GET['backup']."/compress.txt")) { $unzip = "1"; }
			$backup = opendir("backup/".$_GET['backup']);
			while (false !== ($file = readdir($backup))) {
				if ($file != "." AND $file != ".." AND $file != "compress.txt" AND $_POST[str_replace(".", "_", $file)]) {
					// Now we have the name of the file to restore. Lets do different things for compressed and non-compressed backups
					if ($unzip == "1") {
						// Files are compressed
						if ($_POST['replace'] == "replace") {
							// Code for compress and replace
							if (file_exists("db/".basename($file, ".gz"))) {
								@unlink ("db/".basename($file, ".gz"));
								$contents = gzfile("backup/".$_GET['backup']."/".$file);
								$fp = fopen ("db/".basename($file, ".gz"), "w");
								fwrite ($fp, $contents[0]);
								fclose ($fp);

								$this->BackUpOutput($file." decompressed and restored, overwriting old version");
							}
							else {
								$contents = gzfile("backup/".$_GET['backup']."/".$file);
								$fp = fopen ("db/".basename($file, ".gz"), "w");
								fwrite ($fp, $contents[0]);
								fclose ($fp);

								$this->BackUpOutput($file." decompressed and restored");
							}
						}
						else {
							// Code for compress and no replace
							if (file_exists("db/".basename($file, ".gz"))) {
								$this->BackUpOutput($file." already exists. Not restored.");
							}
							else {
								$contents = gzfile("backup/".$_GET['backup']."/".$file);
								$fp = fopen ("db/".basename($file, ".gz"), "w");
								fwrite ($fp, $contents[0]);
								fclose ($fp);

								$this->BackUpOutput($file." decompressed and restored");
							}
						}
					}
					else {
						// Files are not compressed. 
						if ($_POST['replace'] == "replace") {
							// Code for no compress, and replace
							if (file_exists("db/".$file)) {
								if (@unlink ("db/".$file) AND copy("backup/".$_GET['backup']."/".$file, "db/".$file)) { $this->BackUpOutput($file." restored, overwriting old version"); } else { $this->BackUpError("Could not restore ".$file); }
							}
							else {
								if (copy("backup/".$_GET['backup']."/".$file, "db/".$file)) { $this->BackUpOutput($file." restored"); } else { $this->BackUpError("Could not restore ".$file); }
							}
						}
						else {
							// Code for no compress, no replace
							if (file_exists("db/".$file)) {
								$this->BackUpOutput($file." already exists. Not restored.");
							}
							else {
								if (copy("backup/".$_GET['backup']."/".$file, "db/".$file)) { $this->BackUpOutput($file." restored"); } else { $this->BackUpError("Could not restore ".$file); }
							}
						}
					}
				}
			}
			closedir ($backup);

			$this->BackUpOutput("Backup Restore Finished");
		}
		echo '<a href="admin.php?adact=tools">Back to Tools Page</a>';
	}
	else {
		if ($_GET['backup'] == "") {
			// Display a list of Backup files
			echo '<table width="100%" style="font-size: 10pt;"><tr><th><p>Backup Name</p></th><th><p>Created</p></th><th><p>Compressed?</p></th><th><p>Options</p></th></tr>';
			$dir = opendir("backup");
			while (false !== ($file = readdir($dir))) {
				if ($file != "." AND $file != ".." AND $file != "index.html" AND is_dir("backup/".$file)) {
					echo '<tr><td>'.$file.'</td><td>'.date("d M Y H:m:s", filemtime("backup/".$file)).'</td><td>';
					if (file_exists("backup/".$file."/compress.txt")) { echo "Yes"; } else { echo "No"; }
					echo '<td><a href="admin.php?adact=tools&do=restore&backup='.$file.'">Restore Backup</a></td></tr>';
				}
			}
			closedir ($dir);
			echo '</table>';
		}
		else {
			if (!file_exists("backup/".$_GET['backup']) OR $_GET['backup'] == "index.html") {
				echo "The chosen Backup does not exist.";
			}
			else if (file_exists("backup/".$_GET['backup']."/compress.txt") AND !extension_loaded("zlib")) {
				echo "You have chosen to restore a compressed backup. The ZLib extension was not detected. Please install/activate the Zlib extension before continuing.";
			}
			else {
				echo "You have chosen to restore the backup <strong>".$_GET['backup']."</strong>.<br /><br />Please select the files you wish to be restored:";
				echo '<form action="admin.php?adact=tools&do=restore&backup='.$_GET['backup'].'" method="post">';

				$dir = opendir("backup/".$_GET['backup']);
				while (false !== ($file = readdir($dir))) {
					if ($file != "." AND $file != ".." AND $file != "compress.txt") {
						echo '<input type="checkbox" name="'.str_replace(".", "_", $file).'" value="1" checked="checked" />'.basename($file, ".gz").'<br />';
					}
				}
				closedir ($dir);

				echo '<br />If File Exists: <select name="replace"><option value="replace">Replace Existing</option><option value="keep">Keep Existing</option></select><br /><input type="Submit" value="Restore Files" /></form>';
			}
		}
	}
}

function FileWritable($file) {
	// Returns whether the file is writable
	if (is_writable($file)) {
		return "<td>Yes</td>";
	}
	else {
		if ($file == "db" OR $file == "backup" OR $file == "config.php") {
			return '<td style="background-color:#FE4E00;">No'.$this->ToolTip("chmod").'</td>';
		}
		else {
			return '<td>No</td>';
		}
	}
}

function FileReadable($file) {
	// Returns whether the file is writable
	if (is_readable($file)) {
		return "<td>Yes</td>";
	}
	else {
		return '<td style="background-color:#FE4E00;">No'.$this->ToolTip("chmod").'</td>';
	}
}

function FileStatus($file) {
	// Returns whether file exists
	if (file_exists($file)) {
		echo '<tr style="background-color:#43FD47;"><td>'.$file.'</td><td>Exists</td>'.$this->FileWritable($file).$this->FileReadable($file);
	}
	else {
		echo '<tr style="background-color:#FE4E00;"><td>'.$file.'</td><td>Does not exist</td><td></td><td></td>';
	}
}

function CheckFiles() {
	echo "<p><b>Tools - File Checker</b>".$this->tooltip("filechecker")."</p>";

	echo "<p>This tool is designed to check all required files exist, and are CHMOD-ed correctly.</p>";

	echo '<table cellspacing="0" cellpadding="5" border="0"><tr><th>File</th><th>Status</th><th>Writable</th><th>Readable</th></tr>';
	$this->FileStatus("admin.php");
	$this->FileStatus("config.php");
	$this->FileStatus("index.php");
	$this->FileStatus("vote.php");

	$this->FileStatus("backup");
	$this->FileStatus("db");

	$this->FileStatus("functions/adgenhtml.php");
	$this->FileStatus("functions/adhome.php");
	$this->FileStatus("functions/adimage.php");
	$this->FileStatus("functions/admanage.php");
	$this->FileStatus("functions/admin.php");
	$this->FileStatus("functions/adoptions.php");
	$this->FileStatus("functions/adtools.php");
	$this->FileStatus("functions/adtooltip.php");
	$this->FileStatus("functions/general.php");
	echo '</table>';

	echo "<p>If either the <strong>db</strong>, <strong>backup</strong> folder or the <strong>config.php</strong> file could not be written to, you will need to make sure they are CHMOD-ed correctly. Aplomb Poll should also be able to be able to read all the files listed. If not, please make sure they are CHMOD-ed correctly".$this->Tooltip("chmod").'. If a file listed above does not exist, please upload a copy of it, from the distribution file.</p>';
}

function ExtensionInfo($extension) {
	// Checks whether an specified extension is loaded, if so prints out information about it, if not say so
	if (extension_loaded($extension)) {
		echo '<tr style="background-color:#43FD47;"><td>'.$extension.'</td><td>Loaded</td>';
	}
	else {
		echo '<tr style="background-color:#FE4E00;"><td>'.$extension.'</td><td>Not Loaded</td>';
	}

	switch ($extension) {
		case 'gd':
		echo '<td>Poll Graph Generation</td>';
		break;
		case 'zlib':
		echo '<td>Compressed Backup Files</td>';
		break;
		default:
		echo '<td></td>';
	}

	echo '</tr>';
}

function CheckExtensions() {
	echo "<p><b>Tools - Extension Checker</b>".$this->tooltip("extensionchecker")."</p>";

	echo 'The following extensions can be used by Aplomb Poll:';
	echo '<table cellspacing="0" cellpadding="5" border="0"><tr><th>Extension Name</th><th>Status</th><th>Usage</th></tr>';
	// $this->ExtensionInfo("gd"); GD Poll Graphs is coming in a later version ;-)
	$this->ExtensionInfo("zlib");
	echo "</table>";
}

}
?>