<?php

session_start();

ob_start("ob_gzhandler");

// To check if data.php and config.php exist, and if guestbook is offline
include ("config/file_offline.php");

// Include language
include ("languages/$g_lang");

// Add flag name
include ("shared/flags.php");

$smilies_path = "smilies";

// Include functions
include ("shared/functions.php");

require_once ("shared/template.php");

// Include header information
include ("config/header.php");

// Include top notes from file (title)
include ("config/topnotes.php");

// Include head notes from file (sign and view guestbook)
include ("config/headnotes.php");

require_once ("shared/template.php");

$template = new Template('./themes/' . $g_style . '/');

$template->set_filenames(array('sign' => 'sign.tpl'));

// Random name fields
if (($_SESSION['name_field'] == "") || ($_SESSION['message_field'] == "")) {
	$_SESSION['name_field'] = md5(uniqid(rand(), true));
	$_SESSION['message_field'] = md5(uniqid(rand(), true));
}

// IP number
$ip_adress = $_SERVER['REMOTE_ADDR'];

// User agent
$ua = $_SERVER['HTTP_USER_AGENT'];

// Browser accepted langauages
$accept_lang = $_SERVER['HTTP_ACCEPT_LANGUAGE'];

// Remote adress
$remote_add = gethostbyaddr($ip_adress);

// Page refer
@$refer = $_SERVER['HTTP_REFERER'];

$max_char_message_size = strlen($max_char_message);

if ($img_verification == "true") {
	if ($img_verification_method == "image")
	{
		$image_verif_inc = "<img src=\"config/image_verification.php\" alt=\"image verification\" />";
	}
	elseif ($img_verification_method == "text")
	{
		$alphanum = "abcdefghijkmnpqrstuvwxyz0123456789";
		
		// generate the verication code
		$rand = substr(str_shuffle($alphanum), 0, 5);
		
		// create the hash for the random number and put it in the session
		$_SESSION['image_random_value'] = md5($rand);
		
		$image_verif_inc = $rand;
	}
	
	$template->assign_block_vars('verification', array(
		'IMAGE_VERIF_INC' =>		$image_verif_inc,
	));
}

$template->assign_vars(array(
	'SIGN1' =>		"sign1.php",
	'SIGN_N' =>		"sign",
	'NAME_FIELD' =>		$_SESSION['name_field'],
	'MESSAGE_FIELD' =>		$_SESSION['message_field'],
	'NAME_G' =>		$name_g,
	'LOCATION_G' =>		$location_g,
	'COUNTRY' =>		"country",
	'COUNTRY_G' =>		$country_g,
	'NAME' =>		"name",
	'MAX_CHAR_FIELD' =>		$max_char_field,
	'FLAG' =>		"flag",
	'EMAIL_G' =>		$email_g,
	'EMAIL' =>		"email",
	'RATING' =>		$rating,
	'STARS' =>		"stars",
	'MESSAGE' =>		"message",
	'MESSAGE_G' =>		$message_g,
	'G_REFER' =>		"refer",
	'REFER' =>		$refer,
	'SEND' =>		$send,
	'SMILIES_PAGE' =>		"smilies.php",
	'COLOR_PAGE' =>		"color.php",
	'MAX_CHAR_MESSAGE' =>		$max_char_message,
	'MAX_CHAR_MESSAGE_SIZE' =>		$max_char_message_size,
	'MISSING' =>		$missing,
	'WRONG_EMAIL' =>		$wrong_email,
	'VERIF_CODE' =>		$verif_code,
	'VERIF' =>		"verif",
	'PREVIEW' =>		$preview,
	'PREVIEW_PAGE' =>		"preview.php",
));

// Get unique flag names from array
$flags_countries = array_unique($flags_countries);

// Sort names alphabeticly
asort($flags_countries);

// Publish country names
foreach ($flags_countries as $id_flag => $country_name)
{
	// Only publish first 25 caracters of country name
	if (strlen($country_name) > 23)
	{
		$country_name = substr($country_name, 0, 23);
	}
	
	$template->assign_block_vars('flags', array(
		'ID_FLAG' =>		$id_flag,
		'COUNTRY_NAME' =>		$country_name,
	));
}

$template->pparse('sign');

// Include foot notes from file (AG name, version, xhtml and css valid)
include ("config/footnotes.php");

?>