<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name='Edit';
require_once('bin/qtg_init.php');

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) {

  include('qtg_map_lib.php');
  if ( file_exists($qtg_language.'/qtg_lang_map.php') ) { include($qtg_language.'/qtg_lang_map.php'); } else { include('english/qtg_lang_map.php'); }
  $arrMapPoints=array();

}}

// INI

$id = -1;
if ( isset($_POST['id']) ) $id = intval(trim($_POST['id']));
if ( isset($_GET['id']) ) $id = intval(trim($_GET['id']));
if ( $id<0 ) die('ID '.$L['E_invalid']);

// --------
// PROCESS POST
// --------

if ( isset($_POST['ok']) )
{

  $oPost = new cPost();
  $oPost->id = $id;

  // read values
  if ( isset($_POST['from']) ) $oPost->postfrom = substr(strip_tags(trim($_POST['from'])),0,50); if ( get_magic_quotes_gpc() ) $oPost->postfrom = stripslashes($oPost->postfrom);
  if ( isset($_POST['mail']) ) $oPost->useremail = substr(strip_tags(trim($_POST['mail'])),0,50);
  if ( isset($_POST['name']) ) $oPost->name = substr(strip_tags(trim($_POST['name'])),0,50); if ( get_magic_quotes_gpc() ) $oPost->name = stripslashes($oPost->name);
  if ( isset($_POST['msg']) )  $oPost->message = strip_tags(trim($_POST['msg'])); if ( get_magic_quotes_gpc() ) $oPost->message = stripslashes($oPost->message);
  if ( isset($_POST['age']) )
  {
    $_POST['age'] = trim($_POST['age']);
    if ( empty($_POST['age']) ) { $oPost->userage = -1; } else { $oPost->userage = intval($_POST['age']); }
  }
  // check code
  if ( isset($_POST['code']) ) $strCode = substr(trim($_POST['code']),0,4);
  if ( empty($qtg_error) && $qtg_antispam<>0 )
  {
    if ( !QTisbetween(intval($strCode),0,9999) ) $qtg_error = $L['E_code'];
    if ( $_SESSION['textcolor'] != sha1($strCode) ) $qtg_error = $L['E_code'];
  }

  // read values
  if ( empty($qtg_error) )
  { 
    // mandatory fields
    $oPost->name = QThtmlquote($oPost->name,true,true,CONVERT_AMP);
    $oPost->message = QThtmlquote($oPost->message, true,true,CONVERT_AMP);
    if ( empty($oPost->name) ) $qtg_error = $L['Name'].S.$L['E_invalid'];
    if ( empty($oPost->message) )  $qtg_error = $L['Message'].S.$L['E_invalid'];
    $oPost->message = str_replace("\r\n\r\n\r\n","\r\n\r\n",$oPost->message);
    $oPost->message = str_replace("\n\n\n","\n\n",$oPost->message);     
    if ( !$oPost->CheckMessage($qtg_max_size,2,2) ) $qtg_error = $L['E_size'];
    if ( isset($_POST['qtg_gcenter']) ) { $oPost->x = QTgetx($_POST['qtg_gcenter']); $oPost->y = QTgety($_POST['qtg_gcenter']); } else { $oPost->x=0;$oPost->y=0; }
  }

  // check optional fields
  if ( empty($qtg_error) && $oPost->userage>=0 ) { if ( !QTisbetween($oPost->userage,1,120) ) $qtg_error = $L['Age'].S.$L['E_invalid']; }
  if ( empty($qtg_error) && $oPost->useremail!='' ) { if ( !QTismail($oPost->useremail) ) $qtg_error = $L['Email'].S.$L['E_invalid']; }
  if ( empty($qtg_error) && $oPost->postfrom!='' ) { $oPost->postfrom = QThtmlquote($oPost->postfrom,true,true,CONVERT_AMP); }

  // multipost check
  if ( empty($qtg_error) && TooMuch($oDB,$qtg_max_day) ) $qtg_error = $L['E_maxday'];

  // flood check
  if ( empty($qtg_error) && !LastPostDelayAcceptable($qtg_max_sec) ) $qtg_error = $L['E_wait'];

  // check message meaning
  if ( empty($qtg_error) && $qtg_meaning )
  {
    if ( !$oPost->CheckMeaning() ) $qtg_error = $L['E_language'];
  }

  // check message wording
  if ( empty($qtg_error) && $qtg_checkword )
  {
    include($qtg_language.'/qtg_lang_goodbad.php');
    if ( !$oPost->CheckWording($voc) ) $qtg_error = $L['E_language'];
  }

  // save value
  if ( empty($qtg_error) )
  { 

    $_SESSION['qtg_endedit'] = time()+300;

    if ( $oDB->type=='ibase' ) 
    {
    $oDB->Query( 'UPDATE '.TABMESSAGE.' SET name="'.$oPost->name.'",textmsg="'.$oPost->message.'",userage='.($oPost->userage>0 ? $oPost->userage : 'NULL').',useremail="'.(!empty($oPost->useremail) ? $oPost->useremail : '').'",postfrom="'.(!empty($oPost->postfrom) ? $oPost->postfrom : '').'",x='.$oPost->x.',y='.$oPost->y.' WHERE id='.$oPost->id );
    }
    else
    {
    $oDB->Query( 'UPDATE '.TABMESSAGE.' SET name="'.$oPost->name.'",message="'.$oPost->message.'",userage='.($oPost->userage>0 ? $oPost->userage : 'NULL').',useremail="'.(!empty($oPost->useremail) ? $oPost->useremail : '').'",postfrom="'.(!empty($oPost->postfrom) ? $oPost->postfrom : '').'",x='.$oPost->x.',y='.$oPost->y.' WHERE id='.$oPost->id );
    }

    // exit  
    include('qtg_p_header.php');
    echo '
    <h2>',$L['Message_send'],'</h2>',$qtg_back,'
    <script type="text/javascript">
    <!--
    setTimeout(\'window.location=document.getElementById("exiturl").href\',3000);
    -->
    </script>
    ';
    include('qtg_p_footer.php');
    exit;
  }

}

// --------
// HTML START
// --------

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) {

  $strHeaderAddScript = QTgmapheader($qtg_gkey);
  $strBodyAddOnunload='GUnload()';

}}

include('qtg_p_header.php');
echo '
<div id="msg_add">
';

echo '
<h2>',$L['Edit_my_message'],'</h2>
';

// QUERY
$oDB->Query("SELECT * FROM ".TABMESSAGE." WHERE id=".$id);
$row = $oDB->Getrow();
$oPost = new cPost($row);

// CHECK USER AND TIME

if ($_SERVER['REMOTE_ADDR']!=$oDB->ip)
{
  echo 'This is not your message...<br/>'.$qtg_back;
  include('qtg_p_footer.php');
  exit;
}
if ( !isset($_SESSION['qtg_beginedit']) || !isset($_SESSION['qtg_endedit']) )
{
  echo 'Out of time...<br/>',$qtg_back;
  include('qtg_p_footer.php');
  exit;
}
if ( time()+0>$_SESSION['qtg_endedit'] )
{
  echo 'Out of time...<br/>',$qtg_back;
  include('qtg_p_footer.php');
  exit;
}

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) {

  if ( $oPost->x==0 && $oPost->y==0 )
  {
  $x = QTgetx($qtg_gcenter);
  $y = QTgety($qtg_gcenter);
  }
  else
  {
  $arrMapPoints[$oPost->id] = array(
  'x'=>$oPost->x,
  'y'=>$oPost->y,
  'title'=>QTunquote($oPost->name),
  'info'=>null,
  'icon'=>$qtg_gsymbol,
  'shadow'=>$qtg_gshadow,
  'printicon'=>$qtg_gprinticon,
  'printshadow'=>$qtg_gprintshadow
  );
  $x = $oPost->x;
  $y = $oPost->y;
  }

}}

if ( !empty($qtg_error) ) echo '<p class="error" style="text-align:center">',$qtg_error,'</p>';
$formaction = 'qtg_msg_edit.php';
include ('qtg_form_msg.php');

// --------
// HTML END
// --------

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 

  $strFooterAddScript = QTgmappoints($qtg_gbuttons,$qtg_gzoom,$L['map'],$y,$x,'drag',$arrMapPoints,true,false).N.'mapload();';

}}

echo $qtg_back;

echo '</div>';
include('qtg_p_footer.php');

?>