<?php



/* ============

 * qtg_map_lib.php

 * ------------

 * version: 1.7 build:20080601

 * This is a module library

 * ------------

 * QTgpoint()

 * QTgpointdelete()

 * QTgmapheader()

 * QTgmappoints()

 * ============ */



// Attention x,y,z MUST be FLOAT (or null) !!!

// If x,y,z are NULL or not float, these functions will returns FALSE.

// When entity (topic) is created, the x,y,z are null (i.e. no point, no display)



// ---------



// QTgpoint

// This moves a point to a new location



function QTgpoint($oDB=null,$table=null,$t=null,$y=null,$x=null,$onerror=null)

{

  // checks

  if ( !is_int($t) ) { if ( isset($onerror) ) return $onerror; die('QTgpoint: arg #3 must be an integer'); }

  if ( !is_string($table) ) { if ( isset($onerror) ) return $onerror; die('QTgpoint: arg #2 must be an string'); }

  if ( !is_float($y) ) { if ( isset($onerror) ) return $onerror; die('QTgpoint: arg #y must be a float'); }

  if ( !is_float($x) ) { if ( isset($onerror) ) return $onerror; die('QTgpoint: arg #x must be a float'); }



  // move the point  

  $oDB->Query('UPDATE '.$table.' SET y='.$y.',x='.$x.' WHERE id='.$t); 

}



// ---------



function QTgpointdelete($oDB=null,$table=null,$t=null,$onerror=null)

{

  // checks

  if ( !is_string($table) ) { if ( isset($onerror) ) return $onerror; die('QTgpointdelete: arg #2 must be an string'); }

  if ( !is_int($t) ) { if ( isset($onerror) ) return $onerror; die('QTgpointdelete: arg #3 must be an integer'); }



  // delete the point  

  $oDB->Query('UPDATE '.$table.' SET y=NULL,x=NULL WHERE id='.$t);  

}



// ---------



// QTgmaphearder

// This returns the <script> that must be include in the header.

// Returns onerror [empty string] if not possible (i.e. no key).



function QTgmapheader($qtg_gkey='',$strAddLibrary='')

{

 return '<script type="text/javascript" src="http://maps.google.com/maps?file=api&amp;v=2&amp;key='.$qtg_gkey.'"></script>'.(!empty($strAddLibrary) ? '<script type="text/javascript" src="'.$strAddLibrary.'"></script>' : '');

}



// ---------



// QTgmappoints

// This returns a gmap javascript (return FALSE otherwise)

// The map is centered on the point x,y and includes the $arrPoints as markers



function QTgmappoints($qtg_gbuttons='P11100',$qtg_gzoom='10',$L,$y=null,$x=null,$strMarkerType='',$arrPoints=array(),$bGeocode=false,$bCompact=false,$onerror=null)

{

  // checks

  if ( !is_float($y) ) { if ( isset($onerror) ) return $onerror; die('QTgmappoints: arg #y must be a float'); }

  if ( !is_float($x) ) { if ( isset($onerror) ) return $onerror; die('QTgmappoints: arg #x must be a float'); }

  if ( !is_string($strMarkerType) ) { if ( isset($onerror) ) return $onerror; die('QTgmappoints: arg #4 must be a string'); }

  if ( !is_array($arrPoints) ) { if ( isset($onerror) ) return $onerror; die('QTgmappoints: arg #5 must be an array'); }



  // prepare map type

  switch (substr($qtg_gbuttons,0,1)) 

  {

  case 'S': $strMapType = 'G_SATELLITE_MAP'; break;

  case 'H': $strMapType = 'G_HYBRID_MAP'; break;

  case 'P': $strMapType = 'G_PHYSICAL_MAP'; break;

  default:  $strMapType = 'G_NORMAL_MAP'; break;

  }

  

  // prepare map options

  $strMapOptions = '';

  if ( substr($qtg_gbuttons,1,1)=='1' ) $strMapOptions .= 'map.addControl(new G'.($bCompact ? 'Small' : 'Large').'MapControl());';

  if ( substr($qtg_gbuttons,2,1)=='1' ) $strMapOptions .= 'var mapControl = new GHierarchicalMapTypeControl(); mapControl.clearRelationships(); mapControl.addRelationship(G_SATELLITE_MAP, G_HYBRID_MAP, "Labels", false); map.addControl(mapControl); map.addMapType(G_PHYSICAL_MAP);';

  if ( substr($qtg_gbuttons,3,1)=='1' ) $strMapOptions .= 'var bottomLeft = new GControlPosition(G_ANCHOR_BOTTOM_LEFT, new GSize(3,36)); map.addControl(new GScaleControl(), bottomLeft);';

  if ( substr($qtg_gbuttons,4,1)=='1' && !$bCompact ) $strMapOptions .= 'map.addControl(new GOverviewMapControl());';

  if ( substr($qtg_gbuttons,5,1)=='1' ) $strMapOptions .= 'map.enableScrollWheelZoom();';

    

  // make the java map

  $strReturn = '

  var map = null;'.($bGeocode ? ' var geocoder = null;' : '').'

  var mgr = null;

  var arr = [];

  var marker = null;

  function mapload()

  {

    if (GBrowserIsCompatible())

    {

      map = new GMap2(document.getElementById("map_canvas"));'.($bGeocode ? ' geocoder = new GClientGeocoder();' : '').'

      map.disableDoubleClickZoom();'.$strMapOptions.'

      var center = new GLatLng('.$y.', '.$x.');

      map.setCenter(center, '.$qtg_gzoom.', '.$strMapType.');      

      map.savePosition();';

    if ( count($arrPoints)>0 )

    {

    foreach ($arrPoints as $aPoint)

    {

      if ( $aPoint['y']!=0 && $aPoint['x']!=0 )

      {

      $strShadow = 'false';      if ( $aPoint['icon'] && isset($aPoint['shadow']) )      { if ( $aPoint['shadow'] ) $strShadow = 'true'; }

      $strPrint = 'false';       if ( $aPoint['icon'] && isset($aPoint['printicon']) )   { if ( $aPoint['printicon'] ) $strPrint = 'true'; }

      $strPrintShadow = 'false'; if ( $aPoint['icon'] && isset($aPoint['printshadow']) ) { if ( $aPoint['printshadow'] ) $strPrintShadow = 'true'; }

      $strReturn .= '

      var marker = getMarker("'.$strMarkerType.'",new GLatLng('.$aPoint['y'].','.$aPoint['x'].'),'.(!empty($aPoint['title']) ? '\''.addslashes($aPoint['title']).'\'' : 'null').','.(isset($aPoint['info']) ? '\''.$aPoint['info'].'\'' : 'null').','.( $aPoint['icon'] ? '\''.$aPoint['icon'].'\'' : 'null').','.$strShadow.','.$strPrint.','.$strPrintShadow.');

      arr.push(marker);';

      }

    }

    if ( count($arrPoints)<2 )

    {

      $strReturn .= '

      map.addOverlay(marker);';

    }

    else

    {

      $strReturn .= '

      mgr = new MarkerManager(map); mgr.addMarkers(arr,2); mgr.refresh();';

    }

    }

  $strReturn .= '

    }

  }

  function getMarker(type, posn, title, info, strIcon, bShadow, bPrintIcon, bPrintShadow)

  {

    var icon = new GIcon(G_DEFAULT_ICON);

    if ( strIcon )

    {

      icon.image = "map/"+strIcon+".png";

      if ( bShadow ) { icon.shadow = "map/"+strIcon+"_shadow.png"; } else { icon.shadow = null; }

      if ( bPrintIcon ) { icon.printImage = "map/"+strIcon+".gif";icon.mozPrintImage = "map/"+strIcon+".gif"; } else { icon.printImage = null; icon.mozPrintImage = null; }

      if ( bPrintShadow ) { icon.printShadow = "map/"+strIcon+"_shadow.gif"; } else { icon.printShadow = null; }

      icon.iconSize = new GSize(32, 32);

      icon.shadowSize = new GSize(59, 32);

      icon.iconAnchor = new GPoint(14, 32);

    }

    if ( type=="click" )

    {

    var m = new GMarker(posn, {icon: icon, title: title, draggable: false });

    GEvent.addListener(m, "click", function() { m.openInfoWindowHtml(info); } ); 

    return m;

    }

    if ( type=="drag" )

    {

    var m = new GMarker(posn, {icon: icon, title: title, draggable: true });

    GEvent.addListener(m, "dragstart", function() { map.closeInfoWindow(); } );      

    GEvent.addListener(m, "dragend", function() { updateLatLngField(m); } );

    return m;

    }

    var m = new GMarker(posn, {icon: icon, title: title, draggable: false });

    return m;

  }

  function getBoundingBox(arrPoints)

  {

    if ( arrPoints.length==0 ) return null;

    var min_y = 90.0;

    var max_y = -90.0;

    var min_x = 180.0;

    var max_x = -180.0;

    var i;

    for ( i in arrPoints)

    {

      if (arrPoints[i].getLatLng().lat()<min_y) min_y=arrPoints[i].getLatLng().lat(); 

      if (arrPoints[i].getLatLng().lng()<min_x) min_x=arrPoints[i].getLatLng().lng(); 

      if (arrPoints[i].getLatLng().lat()>max_y) max_y=arrPoints[i].getLatLng().lat(); 

      if (arrPoints[i].getLatLng().lng()>max_x) max_x=arrPoints[i].getLatLng().lng(); 

    }

    return new GLatLngBounds(new GLatLng(min_y,min_x),new GLatLng(max_y,max_x));

  }

  function zoomToFullExtend()

  {

    if ( arr.length==0 ) return null;

    var bb = getBoundingBox(arr);

    var c = bb.getCenter();

    map.setCenter(c,map.getBoundsZoomLevel(bb));

    return null;

  }

  ';

  if ( $strMarkerType=='drag' )

  {

  $strReturn .= '

  function updateLatLngField(marker)

  {

    if ( !marker ) { document.getElementById("qtg_gcenter").value=""; return null; }

    map.setCenter(marker.getLatLng());

    document.getElementById("qtg_gcenter").value = marker.getLatLng().lat() + "," + marker.getLatLng().lng();

    return null;

  }

  function createMarker()

  {

    map.clearOverlays();

    map.closeInfoWindow();    

    marker = new GMarker(map.getCenter(), {draggable: true});

    GEvent.addListener( marker, "dragstart", function() { map.closeInfoWindow(); } );      

    GEvent.addListener( marker, "dragend", function() { updateLatLngField(marker); } );

    map.addOverlay(marker);

    updateLatLngField(marker);

    return null;

  }

  function deleteMarker()

  {

    map.clearOverlays();

    map.closeInfoWindow();    

    updateLatLngField(null);

    return null;

  }

  function undoChanges()

  {

    map.clearOverlays();

    map.closeInfoWindow();

    map.returnToSavedPosition();

    map.setCenter(map.getCenter(), '.$qtg_gzoom.', '.$strMapType.');

    marker = new GMarker(map.getCenter(), {draggable: true});

    GEvent.addListener( marker, "dragstart", function() { map.closeInfoWindow(); } );      

    GEvent.addListener( marker, "dragend", function() { updateLatLngField(marker); } );

    map.addOverlay(marker);

    updateLatLngField(marker);

    return null;

  }

  ';

  }

  if ( $bGeocode )

  {

  $strReturn .= '

  function showLocation(address)

  {

    geocoder.getLocations(address, addAddressToMap);

    return null;

  }

  function movetotrymarker(marker,trymarker)

  {

    if ( !marker ) { marker = new GMarker(map.getCenter(), {draggable: true}); }

    map.clearOverlays();

    map.closeInfoWindow();

    map.setCenter(trymarker.getLatLng());

    marker.setPoint(trymarker.getLatLng());

    map.addOverlay(marker);

    updateLatLngField(marker);

    return null;

  }

  function addAddressToMap(response)

  {

    if (!response || response.Status.code != 200) {

      alert(html_entity_decode("'.$L['map']['E_noaddr'].'"));

    } else {

      //map.clearOverlays();

      place = response.Placemark[0];

      point = new GLatLng(place.Point.coordinates[1],

                          place.Point.coordinates[0]);

      map.setCenter(point);

      

      // Create our try marker icon

      var baseIcon = new GIcon(G_DEFAULT_ICON);

      baseIcon.image = "map/point_yellow.png";

      baseIcon.shadow = null;

      baseIcon.iconSize = new GSize(32, 32);

      baseIcon.iconAnchor = new GPoint(16, 32);

      

      // Create try marker

      trymarker = new GMarker(point, { icon:baseIcon, draggable:true });

      GEvent.addListener( trymarker, "dragstart", function() { map.closeInfoWindow(); } );      

      GEvent.addListener( trymarker, "dragend", function() { trymarker.openInfoWindowHtml(\'<a class="small" href="javascript:void(0)" onclick="movetotrymarker(marker,trymarker);">'.$L['pntmove'].'</a><br/><span class="small">'.$L['H_pntmove'].'</span>\'); } );

      map.addOverlay(trymarker);

      trymarker.openInfoWindowHtml(\'<a class="small" href="javascript:void(0)" onclick ="movetotrymarker(marker,trymarker);">'.$L['pntmove'].'</a><br/><span class="small">'.$L['H_pntmove'].'</span>\');

    }

    return null;

  }  

  ';

  }  

  return $strReturn;

}



// ---------



function QTgmaptopic($aTopic=null,$onerror=null)

{

  // checks

  if ( !isset($aTopic) ) { if ( isset($onerror) ) return $onerror; die('QTgmaptopic: arg #1 must be a topic'); }



  // uses QTgmapoint

  if ( is_float($aTopic->x) && is_float($aTopic->y) ) return QTgmappoint($aTopic->id,$aTopic->x,$aTopic->y);



  // return false in case of problem

  return false;

  

}



// ---------



function QTgetx($str=null,$onerror=0.0)

{

  // checks

  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTgetx: arg #1 must be a string'); }

  if ( !strstr($str,',') ) { { if ( isset($onerror) ) return $onerror; die('QTgetx: arg #1 must be a string with 2 values'); }}

  $arr = explode(',',$str);

  $str = trim($arr[1]);

  if ( !is_numeric($str) ) { if ( isset($onerror) ) return $onerror; die('QTgetx: x-coordinate is not a float'); }

  Return floatval($str);

}

function QTgety($str=null,$onerror=0.0)

{

  // checks

  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTgetx: arg #1 must be a string'); }

  if ( !strstr($str,',') ) { { if ( isset($onerror) ) return $onerror; die('QTgetx: arg #1 must be a string with 2 values'); }}

  $arr = explode(',',$str);

  $str = trim($arr[0]);

  if ( !is_numeric($str) ) { if ( isset($onerror) ) return $onerror; die('QTgetx: y-coordinate is not a float'); }

  Return floatval($str);

}



// ---------



function QTgoverridesymbol($arrMapPoints,$strIcon,$onerror=null)

{

  if ( !is_array($arrMapPoints) ) { if ( isset($onerror) ) return $onerror; die('QTgoverridesymbol: arg #1 must be an array'); }



  $arrNewPoints = $arrMapPoints;

  foreach ($arrMapPoints as $intKey => $arrPoint)

  {

    if ( $strIcon=='0' )

    {

    $arrNewPoints[$intKey]['icon']=null;

    }

    else

    {

    $arrNewPoints[$intKey]['icon']=$strIcon;

    }

  }

  return $arrNewPoints;

}



?>