<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();

require_once('bin/qtg_init.php');
$strName = '';

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // CHECK FORM VALUE

  $strName = trim($_POST['title']); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
  if ( !QTislogin($strName,2) ) $qtg_error = $L['Username'].S.$L['E_invalid'];

  $strPwd = trim($_POST['pwd']);
  if ( !QTispassword($strPwd,2) ) $qtg_error = $L['Password'].S.$L['E_invalid'];

  // check login
  if ( empty($qtg_error) )
  {
    if ( ($strName!=$qtg_user) && ($strName!=$qtg_user_2) ) $qtg_error=$L['E_access_denied'];
  }
  // check pwd
  if ( empty($qtg_error) )
  {
    if ( ($strName==$qtg_user) && ($strPwd!=$qtg_pwd) ) $qtg_error=$L['E_access_denied'];
    if ( ($strName==$qtg_user_2) && ($strPwd!=$qtg_pwd_2) ) $qtg_error=$L['E_access_denied'];
  }

  // execute
  if ( empty($qtg_error) )
  {
  $_SESSION['qtgAuth'] = 'yes';
  include('qtg_p_header.php');
  echo '
  <h1>',$L['Login'],S,$strName,'</h1>
  <p>&nbsp;</p>
  <table class="tab_button" cellspacing="0">
  <tr class="tr_button">
  <td class="td_button"><a id="exiturl" class="linkbutton" href="qtg_adm.php">',$L['Return_administration'],'</a></td>
  </tr>
  </table>
  <script type="text/javascript">
  <!--
  setTimeout(\'window.location=document.getElementById("exiturl").href\',1000);
  -->
  </script>
  ';
  include('qtg_p_footer.php');
  exit;
  }
}

// LOGOUT

if ( isset($_GET['a']) ) {
if ( $_GET['a']=='out' ) {
  session_destroy();  
  require_once('bin/qtg_init.php');
  $_SESSION['qtgAuth']='N';
  include('qtg_p_header.php');  
  echo '
  <h1>',$L['Logout'],'</h1>
  <p>&nbsp;</p>',$qtg_back,'
  <script type="text/javascript">
  <!--
  setTimeout(\'window.location=document.getElementById("exiturl").href\',1000);
  -->
  </script>
  ';
  include('qtg_p_footer.php');
  exit;
}}

// --------
// START HTML
// --------

include('qtg_p_header.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode(\'',$L['E_mandatory'],': ',$L['Username'],'\')); return false; }
  if (theForm.pwd.value.length==0) { alert(html_entity_decode(\'',$L['E_mandatory'],': ',$L['Password'],'\')); return false; }
  return null;
}
-->
</script>

<div id="login">
<h1>',$L['Login'],'</h1>
<table class="tab_reply">
<tr class="tr_reply">
<td class="td_reply">
<form method="post" action="qtg_login.php" onsubmit="return ValidateForm(this)">
<p class="p_form"><label for="title">',$L['Username'],'</label> <input type="text" id="title" name="title" size="20" maxlength="24" value="',$strName,'"/></p>
<p class="p_form"><label for="pwd">',$L['Password'],'</label> <input type="password" id="pwd" name="pwd" size="20" maxlength="24"/></p>
<p class="p_form">',( !empty($qtg_error) ? '<span class="error">'.$qtg_error.'</span> ' : ''),'<input type="submit" name="ok" value="',$L['Login'],'"/></p>
</form>
</td>
</tr>
</table>
<p>&nbsp;</p>',$qtg_back,'
</div>
';

// --------
// HTML END
// --------

echo '
<script type="text/javascript">
<!--
document.getElementById("title").focus();
if ( document.getElementById("title").value.length>1 ) { document.getElementById("pwd").focus(); }
-->
</script>
';

include('qtg_p_footer.php');

?>