<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qtg_init.php');

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 
  include('qtg_map_lib.php');
  if ( file_exists($qtg_language.'/qtg_lang_map.php') ) { include($qtg_language.'/qtg_lang_map.php'); } else { include('english/qtg_lang_map.php'); }
  // force separate form when map in used
  if ( !$qtg_separateform ) $qtg_separateform = true;
}}

// INI

$intId  = -1;
$strName = '';
$intAge  = '';
$strFrom = '';
$strMail = '';
$strMsg  = '';
$strCode = '';
$bCol = $qtg_column_default;

if ( isset($_GET['v']) ) $_SESSION['qtgview']=$_GET['v'];
if ( isset($_GET['page']) ) { $limit = ($_GET['page']-1)*$qtg_page_size; $currentpage=$_GET['page']; } else { $limit=0; $currentpage=1; }
if ( isset($_SESSION['qtgview']) ) $bCol = ($_SESSION['qtgview']=='col');

// COUNT TOPICS

$oDB->Query("SELECT count(id) as countid FROM ".TABMESSAGE." WHERE id>=0 AND visible='Y'");
$row = $oDB->Getrow();
$intMessages = $row['countid'];

// --------
// HTML START
// --------

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 
  $arrMapPoints = array();
  $strHeaderAddScript = QTgmapheader($qtg_gkey,'http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}}

include('qtg_p_header.php');
echo '
<div id="index">
';

// TIPS WELCOME

echo '
<!-- tips -->
<div class="div_tips">
<table class="tab_tips" cellspacing="0" cellpadding="0">
<tr class="tr_tips">
<td class="td_tips_left"><span class="text_tips">',QTunquote($qtg_welcome),'</span></td>
<td class="td_tips_right">';
if ( $qtg_home<>'' ) echo '&nbsp;<a href="',$qtg_home,'" onmouseout="changeimg(\'home\',\'',$qtg_skin,'/ico_home.gif\')" onmouseover="changeimg(\'home\',\'',$qtg_skin,'/ico_home_on.gif\')"><img id="home" src="',$qtg_skin,'/ico_home.gif" alt="Home" title="',$L['Home'],'" style="border-width:0px;"/></a>';
if ( $qtg_column_change ) echo '&nbsp;<a href="qtg_index.php?v=std" onmouseout="changeimg(\'std\',\'',$qtg_skin,'/ico_view_std.gif\')" onmouseover="changeimg(\'std\',\'',$qtg_skin,'/ico_view_std_on.gif\')"><img id="std" src="',$qtg_skin,'/ico_view_std.gif" alt="view" title="',$L['View_std'],'" style="border-width:0px;"/></a>&nbsp;<a href="qtg_index.php?v=col" onmouseout="changeimg(\'col\',\'',$qtg_skin,'/ico_view_col.gif\')" onmouseover="changeimg(\'col\',\'',$qtg_skin,'/ico_view_col_on.gif\')"><img id="col" src="',$qtg_skin,'/ico_view_col.gif" alt="view" title="',$L['View_col'],'" style="border-width:0px;"/></a>';
echo '</td>
</tr>
</table>
</div>
';

if ( $qtg_actif )
{
  if ( $qtg_separateform )
  {
    echo '<div class="div_sign"><a class="linkbutton" href="qtg_msg_add.php">',$L['Sign'],'</a></div>';
  }
}

// PAGER

$pager = MakePager('qtg_index.php?f=1',$intMessages,$qtg_page_size,$currentpage,$L);

if ( $pager!='' )
{
echo '
<!-- pager -->
<table class="tab_pager" cellspacing="0" cellpadding="0">
<tr class="tr_pager_top">
<td class="td_pager_top">',$L['Page'],$pager,'</td>
</tr>
</table>
';
}

// QUERY
$strState = '* FROM '.TABMESSAGE." WHERE id>=0 AND visible='Y'";
$oDB->Query( LimitSQL($oDB->type,$strState,'issuedate DESC',$limit,$qtg_page_size,$intMessages) );

// DISPLAY

if ( $bCol )
{
echo '
<!-- 2 columns start -->
<table class="tab_layout" cellspacing="0">
<colgroup span="2"><col style="width:50%"></col><col style="width:50%"></col></colgroup>
<tr class="tr_layout"><td class="td_layout">
<!-- 2 columns start -->
';
}

$iCol = 1;
while ( $row=$oDB->Getrow() )
{
  $oPost = new cPost($row,$oDB);
  // ------------
  include('qtg_msg_msg.php'); 
  // ------------


  if ( $_SERVER['REMOTE_ADDR']==$oDB->ip ) {
  if ( isset($_SESSION['qtg_beginedit']) && isset($_SESSION['qtg_endedit']) ) {
  if ( $oPost->issuedate >= date('YmdHis',$_SESSION['qtg_beginedit']) && $oPost->issuedate < date('YmdHis',$_SESSION['qtg_endedit']) ) {
    if ( time()+0 < $_SESSION['qtg_endedit'] )
    {
    echo '&nbsp;<a href="qtg_msg_edit.php?id=',$oPost->id,'">[',$L['Edit_my_message'],']</a>&nbsp;<a href="qtg_msg_del.php?id=',$oPost->id,'">[',$L['Delete_my_message'],']</a><br/><br/>';
    }
    else
    {
    unset($_SESSION['qtg_endedit']);
    unset($_SESSION['qtg_beginedit']);
    }
  }}}

  if ( $bCol )
  {
    if ( $iCol==1 ) echo '</td><td class="td_layout">',N;
    if ( $iCol==2 ) echo '</td></tr><tr class="tr_layout"><td class="td_layout">',N;
    $iCol++;
    if ( $iCol>2 ) $iCol=1;
  }
  
  if ( isset($qtg_gkey) ) { 
  if ( !empty($qtg_gkey) ) { 
  if ( $oPost->x!=0 && $oPost->y!=0 ) {
    $str = IQTbbc($oPost,'html',' ',200,null,null,$arrQTbbc,$L,$qtg_skin,$currentpage);
    $str .= '<br/><br/>'.( $qtg_use_from && !empty($oPost->postfrom) ? $oPost->postfrom.' ' : '' ).QTdate($oPost->issuedate,$arrQTdate);
    $arrMapPoints[$oPost->id] = array(
      'x'=>floatval($oPost->x),
      'y'=>floatval($oPost->y),
      'title'=>QThtmlquote($oPost->name),
      'info'=>'<div class="ginfo">'.QThtmlquote($oPost->name.'<br/><br/>'.$str,true,false).'</div>',
      'icon'=>$qtg_gsymbol,
      'shadow'=>$qtg_gshadow,
      'printicon'=>$qtg_gprinticon,
      'printshadow'=>$qtg_gprintshadow
      );
  }}}
  
}

// end column layout
$iCol = 1;
if ( $bCol ) 
{
echo '
<!-- 2 columns end -->
</td>
</tr>
</table>
<!-- 2 columns end -->
';
}

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 

  if ( count($arrMapPoints)==0 )
  {
    echo '<div class="div_gmap_disabled">'.$L['map']['E_noposition'].'</div>';
  }
  else
  {
    //select zoomto (maximum 20 items in the list)
    if ( count($arrMapPoints)>1 )
    {
      $str = '<p class="p_gmap" style="margin:0 0 4px 0"><a class="a_gmap" href="javascript:void(0)" onclick="zoomToFullExtend(); return false;">'.$L['map']['zoomtoall'].'</a> | '.$L['Goto'].' <select class="gmap" id="zoomto" name="zoomto" size="1" onchange="map.setCenter(eval(this.value));">';
      $str .= '<option class="small_gmap" value="new GLatLng('.QTgety($qtg_gcenter).','.QTgetx($qtg_gcenter).')"> </option>';
      $i=0;
      foreach ( $arrMapPoints as $intKey => $arrMapPoint )
      {
      $str .= '<option class="small_gmap" value="new GLatLng('.$arrMapPoint['y'].','.$arrMapPoint['x'].')">'.$arrMapPoint['title'].'</option>';
      $i++; if ( $i>20 ) break;       
      }
      $str .= '</select></p>';
    }

    echo '
    <div class="div_gmap">
    ',( count($arrMapPoints)>1 ? $str :'' ),'
    <div id="map_canvas" style="width:100%; height:350px;"></div>
    <p class="p_gmap" style="margin:4px 0 0 0">',sprintf($L['map']['items'],strtolower( LangS('Message',count($arrMapPoints),$L)),strtolower(LangS('Message',$intMessages,$L)) ),'</p>
    </div>
    ';
  }

}}

if ( $pager!='' )
{
echo '
<!-- pager -->
<table class="tab_pager" cellspacing="0" cellpadding="0">
<tr class="tr_pager_bot">
<td class="td_pager_bot">',$L['Page'],$pager,'</td>
</tr>
</table>
';
}

if ($qtg_checkip)
{
  if ( strstr($qtg_checkip_list,($_SERVER['REMOTE_ADDR'])) )
  {
    echo '<p style="text-align:center">',$L['E_ip_denied'],'</p>';
    $qtg_actif=false;
  }
}

if ($qtg_actif)
{
  if ($qtg_separateform)
  {
    if ( $intMessages>2 ) echo '<div class="div_sign"><a class="linkbutton" href="qtg_msg_add.php">',$L['Sign'],'</a></div>';
  }
  else
  {
    $formaction = 'qtg_msg_add.php';
    $a='add';
    include('qtg_form_msg.php');
  }
}
else
{
  echo '<p style="text-align:center">',QTunquote($qtg_stop_message),'</p>';
}

// --------
// HTML END
// --------

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 

  $y = floatval(QTgety($qtg_gcenter));
  $x = floatval(QTgetx($qtg_gcenter));

  // center on the first item
  foreach ($arrMapPoints as $intKey => $arrMapPoint)
  {
    if ( !empty($arrMapPoints[$intKey]['y']) && !empty($arrMapPoints[$intKey]['x']) )
    {
    $y=$arrMapPoints[$intKey]['y'];
    $x=$arrMapPoints[$intKey]['x'];
    break;
    }
  }
  $strFooterAddScript = QTgmappoints($qtg_gbuttons,$qtg_gzoom,$L['map'],$y,$x,'click',$arrMapPoints).N.'mapload();';

}}

echo '</div>';
include('qtg_p_footer.php');

?>