<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name='Statistics';

require_once('bin/qtg_init.php');
include($qtg_language.'/qtg_lang_adm.php');
$qtg_skin = 'admin';

$arrGraphT = array();
for ($i=1;$i<13;$i++)
{
  $arrGraphT[$L['dateMMM'][$i]]=0;
}

$intYear = date('Y');
$intGraphYear = $intYear;
  if ( intval(date('n'))<2 ) $intGraphYear--;
  if ( isset($_GET['graphyear']) ) $intGraphYear = intval($_GET['graphyear']);
$arrYears = array($intYear-1=>$intYear-1,$intYear=>$intYear);

// FIRST/LAST DATE

$oDB->Query('SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE id>=0');
$row = $oDB->Getrow();
$intTotalPost = $row['countid'];
$intHiddenPost = 0;
$strFirstdate = '';
$strLastdate ='';
$intStartyear = 0;
$intStartmonth = 0;
$intEndyear = 0;
$intEndmonth = 0;

if ($intTotalPost>0)
{
  $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND visible='N'" );
  $row = $oDB->Getrow();
  $intHiddenPost = $row['countid'];
  $oDB->Query( 'SELECT MIN(issuedate) as firstdate,MAX(issuedate) as lastdate FROM '.TABMESSAGE.' WHERE id>=0 AND issuedate<>"0"' );
  $row = $oDB->Getrow();
  $strFirstdate = QTdate($row['firstdate'],$arrQTdate);
  $strLastdate = QTdate($row['lastdate'],$arrQTdate);
  $intStartyear = intval(substr($row['firstdate'],0,4));
  $intStartmonth = intval(substr($row['firstdate'],4,2));
  $intEndyear = intval(date('Y'));
  $intEndmonth = intval(date('n'));
}

// --------
// HTML START
// --------

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">',N;
echo '<html xmlns="http://www.w3.org/1999/xhtml" dir="',$L['Html_dir'],'" xml:lang="',$L['Html_lang'],'" lang="',$L['Html_lang'],'">',N;
echo '<head>',N;
echo '<title>',$qtg_title,'</title>',N;
echo '<meta http-equiv="content-type" content="text/html; charset=',$L['Html_charset'],'"/>',N;
echo '<link rel="stylesheet" type="text/css" href="admin/qtg_print.css"/>',N;
echo '<link rel="stylesheet" type="text/css" href="admin/qtg_graph.css"/>',N;
echo '</head>',N,'<body>',N,N;

// BANNER

if ($qtg_banner)
{
echo '
<!-- BANNER TOP -->
<div class="div_btop">
<table class="tab_btop" cellspacing="0" cellpadding="0">
<tr class="tr_btop">
<td class="td_btop_left"></td>
<td class="td_btop_center"><img id="logo" src="admin/qtg_logo.gif" width="175" height="50" alt="QuickTalk Guestbook"/></td>
<td class="td_btop_right"></td>
</tr>
</table>
</div>
';
}
else
{
echo '
<!-- NO BANNER TOP -->
<div class="div_nobtop">
<table class="tab_nobtop" cellspacing="0" cellpadding="0">
<tr class="tr_nobtop">
<td class="td_nobtop_left"></td>
<td class="td_nobtop_center"></td>
<td class="td_nobtop_right"></td>
</tr>
</table>
</div>
';
}

echo '
<h1>',$L['Statistics'],'</h1>
<h2>',$L['General_stats'],'</h2>
';

echo '
<table cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" width="180">',$L['Messages'],'</td>
<td class="td_adm">',$intTotalPost,'</td>
</tr>
<tr>
<td class="td_adm_top">',$L['Hidden_messages'],'</td>
<td class="td_adm">',$intHiddenPost,'</td>
</tr>
<tr>
<td class="td_adm_top">',$L['First_message'],'</td>
<td class="td_adm">',$strFirstdate,'</td>
</tr>
<tr>
<td class="td_adm_top">',$L['Last_message'],'</td>
<td class="td_adm">',$strLastdate,'</td>
</tr>
</table>
';

// QUERY

$intTotalPost = 0;

echo '<h2>',$L['Messages_per_month'],'</h2>',N;

echo '<table class="tab_adm" cellspacing="0">',N;
echo '<tr>',N;
echo '<th class="td_adm_top" style="width:50px">&nbsp;</th>',N;
for ($i=1;$i<13;$i++)
{
  echo '<th class="td_adm_top" style="text-align:center;">',$L['dateMM'][$i],'</th>',N;
}
echo '<th class="td_adm_top" style="text-align:center;"><b>',$L['Total'],'</b></th>
</tr>',N;

Foreach ($arrYears as $valYear)
{
  echo '<tr>',N;
  echo '<th class="td_adm_top">',$valYear,'</th>',N;

  $intTotalPost = 0;
  for ($intMonth=1;$intMonth<13;$intMonth++)
  {
    if ( $valYear<$intStartyear )
    {
    echo '<td class="td_adm" style="text-align:center;">&middot;</td>',N;
    continue;
    }
    if ( $valYear==$intStartyear && $intMonth<$intStartmonth)
    {
    echo '<td class="td_adm" style="text-align:center;">&middot;</td>',N;
    continue;
    }
    if ( $valYear==$intEndyear && $intMonth>$intEndmonth )
    {
    echo '<td class="td_adm" style="text-align:center;">&middot;</td>',N;
    continue;
    }
    if ( $valYear>$intEndyear )
    {
    echo '<td class="td_adm" style="text-align:center;">&middot;</td>',N;
    continue;
    }

    switch($oDB->type)
    {
    case 'mysql': $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTRING(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'mssql': $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTRING(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'pg':    $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTRING(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'ibase': $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTRING(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'sqlite':$strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTR(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'access':$strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND LEFT(issuedate,6)='".($valYear*100+$intMonth)."'"; break;
    case 'db2':   $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTR(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'ifx':   $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTRING(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    case 'oci':   $strQ = 'SELECT count(id) as countid FROM '.TABMESSAGE." WHERE id>=0 AND SUBSTR(issuedate,1,6)='".($valYear*100+$intMonth)."'"; break;
    default: die('Unknown db type '.$oDB->type);
    }
    $oDB->Query($strQ);
    $row = $oDB->Getrow();
    echo '<td class="td_adm" style="text-align:center;">',$row['countid'],'</td>',N;
    $intTotalPost = $intTotalPost + $row['countid'];
    if ( $valYear==$intGraphYear ) $arrGraphT[$L['dateMMM'][$intMonth]] = $row['countid'];
  }
  echo '<td class="td_adm_help" style="text-align:center;padding:5px"><b>',$intTotalPost,'</b></td>',N,'</tr>',N;
}

echo '</table>',N;

// GRAPH


if ( file_exists('bin/qt_lib_graph.php') && file_exists('admin/qtg_graph.css') )
{
  include('bin/qt_lib_graph.php');  
  echo '<div style="width:480px;">';
  echo '<h2>',$intGraphYear,'</h2>',N;
  echo '<br/>';
  QTsimplegraph($arrGraphT,false,320,100,2,true,$L['Items_per_month']);
  echo '<br/>';
  QTsimplegraph($arrGraphT,false,350,100,2,'P',$L['Items_per_month'].' (%)');
  echo '<br/>';
  QTsimplegraph($arrGraphT,true,320,100,2,true,$L['Items_per_month_cumul']);
  echo '<br/>';
  QTsimplegraph($arrGraphT,true,350,100,2,'P',$L['Items_per_month_cumul'].' (%)');
  echo '<br/>';
  echo '</div>';
}
else
{
  echo '<p class="small">Graphs cannot be displayed because one of these files is missing: bin/qt_lib_graph.php, admin/qtg_graph.css</p>';
}

// IP STATS

$query = 'SELECT ip,count(ip) as countip FROM '.TABMESSAGE.' WHERE id>=0 GROUP BY ip ORDER BY countip DESC';
if ($oDB->type=="odbc") $query = 'SELECT DISTINCT ip,count(ip) as countip FROM '.TABMESSAGE.' WHERE id>=0 GROUP BY ip ORDER BY count(ip) DESC';
$oDB->Query($query);
$ips='';
$i=1;
While ($row =$oDB->Getrow())
{
  $ip = $row['ip'];
  if ($ip=='') $ip='?.?.?.?';
  $ips .= "<b>{$row['countip']}</b> - $ip<br/>";
  $i++;
  if ($i>5) break;
}

echo '
<h2>',$L['Advenced_stats'],'</h2>
<table cellspacing="0" class="tab_adm">
<tr valign="top">
<td class="td_adm_top" width="180">Top 5 IPs</td>
<td class="td_adm">',$ips,'</td>
</tr>
</table>
<br/>
';

// --------
// HTML END
// --------
echo '
<!-- COPYRIGHT LINE -->
<div class="div_footer">
<div class="div_footer_copy">
<p class="p_footer_copy">powered by QT-cute | v',substr(QTGVERSION,0,3),'</p>
</div>
</div>
<!-- END COPYRIGHT LINE -->

</body>
</html>';

?>