<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name='Messages';

// check login

if ( !isset($_SESSION['qtgAuth']) ) header('Location: qtg_login.php');
if ( $_SESSION['qtgAuth']!='yes' ) header('Location: qtg_login.php');

require_once('bin/qtg_init.php');
include($qtg_language.'/qtg_lang_adm.php');
$qtg_skin='admin';
$arrQTbbc = array(true,true,true,true,true); // administrator can view all the bbc

// --------
// SUBMITTED
// --------

if ( isset($_GET['id']) )
{
  if ( isset($_GET['v']) ) $oDB->Query('UPDATE '.TABMESSAGE." set visible='{$_GET['v']}' WHERE id={$_GET['id']}");
}

// --------
// HTML START
// --------

include('qtg_p_header.php');
include('qtg_adm_menu.php');

echo '
<!-- content -->
<h1>',$L[$pg_name],'</h1>
';

if ( isset($_GET['page']) ) { $limit=($_GET['page']-1)*$qtg_page_size; $currentpage=$_GET['page']; } else { $limit=0; $currentpage=1; }

// count topics

$oDB->Query('SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE id>=0');
$row = $oDB->Getrow();
$count = $row['countid'];

// pager

$words = array($L['First'],$L['Previous'],$L['Next'],$L['Last']);
$pager = MakePager('qtg_adm_msg.php?f=1',$count,$qtg_page_size,$currentpage,$words);
if ( $pager!='' ) $pager = $L['Page'].$pager;

echo '
<!-- pager -->
<table class="tab_pager" cellspacing="0" cellpadding="0">
<tr class="tr_pager_top">
<td class="td_pager_top">',$pager,'</td>
</tr>
</table>
';

// query
$state = '* FROM '.TABMESSAGE.' WHERE id>=0';
$query = LimitSQL($oDB->type,$state,'issuedate DESC',$limit,$qtg_page_size,$count);
$oDB->Query($query);

while ($row = $oDB->Getrow())
{
  $oPost = new cPost($row,$oDB);

  echo '<table class="tab_adm',($oPost->visible=='Y' ? '' : '_hidden'),'" cellspacing="0">',N;
  echo '<tr class="tr_adm_top">',N;
  echo '<td class="td_adm_top">';
  if ( !empty($oPost->postfrom) ) echo $oPost->postfrom.', ';
  echo QTdate($oPost->issuedate,$arrQTdate).'</td>';
  echo '<td class="td_adm" style="width:200px; text-align:center;">';
  echo '<a href="qtg_adm_edit.php?id=',$oPost->id,'&amp;page=',$currentpage,'">',$L['Edit'],'</a>&nbsp;|&nbsp;';
  echo '<a href="qtg_adm_del.php?id=',$oPost->id,'&amp;del=Y">',$L['Delete'],'</a>&nbsp;|&nbsp';
  if ( $oPost->visible=='Y' )
  {
    echo '<a href="qtg_adm_msg.php?id=',$oPost->id,'&amp;v=N&amp;page=',$currentpage,'">',$L['Hide'],'</a>';
  }
  else
  {
    echo '<a href="qtg_adm_msg.php?id=',$oPost->id,'&amp;v=Y&amp;page=',$currentpage,'">',$L['Unhide'],'</a>';
  }
  echo '</td>';
  echo '</tr>',N;
  echo '<tr class="tr_adm">',N;
  echo '<td class="td_adm"><span class="small">',IQTbbc($oPost,'html','<br/>',$qtg_show_size,null,null,$arrQTbbc,$L,$qtg_skin,$currentpage),'</span><br/><b>',$oPost->name,'</b>';
  if ( $oPost->userage>0 ) echo '&nbsp;(',$oPost->userage,')';
  if ( !empty($oPost->useremail) ) echo '&nbsp;',$oPost->useremail;
  echo '</td>';
  echo '<td class="td_adm_help" style="width:200px; text-align:center;"><span class="small">visible <b>',$oPost->visible,'</b></span><br/><span class="small">ip <b>',$oDB->ip,'</b></span></td>';
  echo '</tr>',N;
  echo '</table>',N;
}

echo '
<!-- pager -->
<table class="tab_pager" cellspacing="0" cellpadding="0">
<tr class="tr_pager_bot">
<td class="td_pager_bot">',$pager,'</td>
</tr>
</table>
';

// --------
// HTML END
// --------

include('qtg_p_footer.php');

?>