<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name='';

// CHECK LOGIN

if ( !isset($_SESSION['qtgAuth']) ) header('Location: login.php');
if ( $_SESSION['qtgAuth']!='yes' ) header('Location: login.php');

require_once('bin/qtg_init.php');
include($qtg_language.'/qtg_lang_adm.php');
$qtg_skin='admin';

// CHECK ARGUMENTS

if ( !isset($_GET['y']) ) die ('Missing argument [y]');
if ( !isset($_GET['m']) ) die ('Missing argument [m]');
if ( !isset($_GET['ip']) ) die ('Missing argument [ip]');
if ( !isset($_GET['n']) ) die ('Missing argument [n]');

// READ ARGUMENTS (protection against injection)

$intYear = intval($_GET['y']);
$intMonth = intval($_GET['m']);
$strIp = strip_tags(substr($_GET['ip'],0,30));
$intNum = intval($_GET['n']);

$bHidden = true;
$bBbc = true;
$bSmile = true;
if ( isset($_GET['f']) ) { $f=substr($_GET['f'],0,3); } else { $f='txt'; }
if ( isset($_GET['h']) ) { if ( $_GET['h']=='N' ) $bHidden=false; }
if ( isset($_GET['b']) ) { if ( $_GET['b']=='N' ) $bBbc=false; }
if ( isset($_GET['s']) ) { if ( $_GET['s']=='N' ) $bSmile=false; }

// --------
// SUBMITTED
// --------

if ( isset($_GET['export']) || isset($_GET['delete']) || isset($_GET['hide']) || isset($_GET['unhide']) )
{      
  $str = strval($intYear); if ( $intMonth>0 ) $str = strval($intYear*100+$intMonth);
  switch( $oDB->type )
  {
  case 'mysql': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'mssql': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'pg':    $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'ibase': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'sqlite':$strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'access':$strWhere = 'LEFT(issuedate,'.strlen($str).')="'.$str.'"'; break;
  case 'db2':   $strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'ifx':   $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'oci':   $strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  default: die('Unknown db type '.$oDB->type);
  }

  if ( !empty($strIp) )$strWhere .= ' AND ip="'.$strIp.'"';
  
  if ( isset($_GET['delete']) || isset($_GET['hide']) || isset($_GET['unhide']) )
  {
    include('qtg_p_header.php');
    include('qtg_adm_menu.php');
    if ( isset($_GET['hide']) )   $oDB->Query('UPDATE '.TABMESSAGE.' SET visible="N" WHERE id>=0 AND '.$strWhere);
    if ( isset($_GET['unhide']) ) $oDB->Query('UPDATE '.TABMESSAGE.' SET visible="Y" WHERE id>=0 AND '.$strWhere);
    if ( isset($_GET['delete']) ) $oDB->Query('DELETE FROM '.TABMESSAGE.' WHERE '.$strWhere);
    echo '<h1>',$L['Update_successfull'],'</h1>';
    echo '
    <p><a id="exiturl" href="qtg_adm_msg.php">',$L['Messages'],'</a></p>
    <script type="text/javascript">
    <!--
    setTimeout(\'window.location=document.getElementById("exiturl").href\',1000);
    -->
    </script>
    ';
    include('qtg_p_footer.php');
    exit;
  }
  
  if ( isset($_GET['export']) )
  {
    // attention firebird exception
    $oDB->Query('SELECT * FROM '.TABMESSAGE.' WHERE id>=0 AND '.$strWhere.($bHidden ? '' : ' AND visible="Y"'));
    
    if (!headers_sent())
    {
    header('Content-Type: text/plain; charset='.$L['Html_charset']);
    header('Content-Disposition: attachment; filename="qt_'.date('Ymd').'.'.$f);
    }

    while ( $row = $oDB->Getrow() )
    {    
      $oPost = new cPost($row,$oDB);
      
      if ( $bBbc || $bSmile )
      {
        if ( strstr($oPost->message,'[') )
        {
          if ( $bBbc )   $oPost->message=QTbbc($oPost->message,'deepdrop');
          if ( $bSmile ) $oPost->message=ereg_replace('\[(\:|\;).\]','',$oPost->message);
        }
        if ( strstr($oPost->name,'[') )
        {
          if ( $bBbc )   $oPost->name=QTbbc($oPost->name,'deepdrop');
          if ( $bSmile ) $oPost->name=ereg_replace('\[(\:|\;).\]','',$oPost->name);
        }
      }
      if ( $f=='txt' )
      {
        $oPost->message = QThtml2text($oPost->message);
        $oPost->name = QThtml2text($oPost->name);
        echo $oPost->name;
        if ( !empty($oPost->userage) )   echo " ($oPost->userage)";
        if ( !empty($oPost->useremail) ) echo ", $oPost->useremail";
        if ( !empty($oPost->postfrom) )  echo ", $oPost->postfrom";
        if ( !empty($oPost->issuedate) ) echo " ".QTdate($oPost->issuedate,array('n','datetime','j-n-Y',$qtg_formattime));
        echo "\r\n\r\n".$oPost->message;
        echo "\r\n___________________________\r\n\r\n";
      }
      if ( $f=='csv' )
      {
        $oPost->message = '"'.QThtml2text($oPost->message,"'").'"';
        $oPost->name = '"'.QThtml2text($oPost->name,"'").'"';
        $oPost->message = str_replace("\r\n","\n",$oPost->message);
        $oPost->message = str_replace("\n","\\n",$oPost->message);
        echo $oPost->id.','.$oPost->name.';';
        if ( !empty($oPost->userage) )   { echo $oPost->userage.';'; } else { echo '0;'; }
        if ( !empty($oPost->useremail) ) { echo '"'.$oPost->useremail.'";'; } else { echo '"";'; }
        if ( !empty($oPost->postfrom) )  { echo '"'.$oPost->postfrom.'";'; } else { echo '"";'; }
        echo '"'.$oPost->issuedate.'";';
        echo '"'.$oPost->x.'";';
        echo '"'.$oPost->y.'";';
        echo '"'.$oPost->z.'";';
        echo $oPost->message."\r\n";
      }
    }
    exit;  
  }
}

// --------
// HTML START
// --------

include('qtg_p_header.php');
include('qtg_adm_menu.php');

if ( !isset($_GET['a']) ) die ('Missing argument [a]');
$a = substr($_GET['a'],0,6);

if ( $a=='Export' )
{
echo '
<h1>',$L['Export'],' ',$intNum,' ',$L['Messages'],'</h1>
<p><form method="get" action="qtg_adm_medit_exe.php">
',$L['Format'],'&nbsp;<select name="f">
<option value="txt">Text</option>
<option value="csv">CSV</option>
</select>&nbsp;&nbsp;
',$L['Include_hidden'],'&nbsp;<select name="h">
<option value="Y"',($bHidden ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N"',(!$bHidden ? QSEL : ''),'>',$L['No'],'</option>
</select>&nbsp;&nbsp;
',$L['Drop_bbc'],'&nbsp;<select name="b">
<option value="Y"',($bBbc ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N"',(!$bBbc ? QSEL : ''),'>',$L['No'],'</option>
</select>&nbsp;&nbsp;
',$L['Drop_smile'],'&nbsp;<select name="s">
<option value="Y"',($bSmile ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N"',(!$bSmile ? QSEL : ''),'>',$L['No'],'</option>
</select>&nbsp;&nbsp;
<input type="hidden" name="y" value="',$intYear,'"/>
<input type="hidden" name="m" value="',$intMonth,'"/>
<input type="hidden" name="ip" value="',$strIp,'"/>
<input type="hidden" name="n" value="',$intNum,'"/>
<input type="submit" name="export" value="',$L['Ok'],'"/>
</form></p>
';
}
if ( $a=='Hide' )
{
echo '
<h1>',$L['Hide'],' ',$intNum,' ',$L['Messages'],'</h1>
<p><form method="get" action="qtg_adm_medit_exe.php">
<input type="hidden" name="y" value="',$intYear,'"/>
<input type="hidden" name="m" value="',$intMonth,'"/>
<input type="hidden" name="ip" value="',$strIp,'"/>
<input type="hidden" name="n" value="',$intNum,'"/>
<input type="submit" name="hide" value="',$L['Hide'],' !"/>
</form></p>
';
}
if ( $a=='Unhide' )
{
echo '
<h1>',$L['Unhide'],' ',$intNum,' ',$L['Messages'],'</h1>
<p><form method="get" action="qtg_adm_medit_exe.php">
<input type="hidden" name="y" value="',$intYear,'"/>
<input type="hidden" name="m" value="',$intMonth,'"/>
<input type="hidden" name="ip" value="',$strIp,'"/>
<input type="hidden" name="n" value="',$intNum,'"/>
<input type="submit" name="unhide" value="',$L['Unhide'],' !"/>
</form></p>
';
}
if ( $a=='Delete' )
{
echo '
<h1>',$L['Delete'],' ',$intNum,' ',$L['Messages'],'</h1>
<p><form method="get" action="qtg_adm_medit_exe.php">
<input type="hidden" name="y" value="',$intYear,'"/>
<input type="hidden" name="m" value="',$intMonth,'"/>
<input type="hidden" name="ip" value="',$strIp,'"/>
<input type="hidden" name="n" value="',$intNum,'"/>
<input type="submit" name="delete" value="',$L['Delete'],' !"/>
</form></p>
';
}

// --------
// HTML END
// --------

include('qtg_p_footer.php');

?>