<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name="Multiple_edits";

// CHECK LOGIN

if (!isset($_SESSION['qtgAuth'])) header("Location: login.php");
if ($_SESSION['qtgAuth']!='yes') header("Location: login.php");

require_once('bin/qtg_init.php');
include($qtg_language.'/qtg_lang_adm.php');
$qtg_skin='admin';

// --------
// SUBMITTED
// --------

if (isset($_POST['ok']))
{
  // check form value
  $intYear = intval($_POST['y']);
  $intMonth = intval($_POST['m']);
  $strIp = strip_tags(trim($_POST['ip']));
  $a = $_POST['a'];

  // count impacted rows
  $str = strval($intYear); if ( $intMonth>0 ) $str = strval($intYear*100+$intMonth);

  switch( $oDB->type )
  {
  case 'mysql': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'mssql': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'pg':    $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'ibase': $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'sqlite':$strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'access':$strWhere = 'LEFT(issuedate,'.strlen($str).')="'.$str.'"'; break;
  case 'db2':   $strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'ifx':   $strWhere = 'SUBSTRING(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  case 'oci':   $strWhere = 'SUBSTR(issuedate,1,'.strlen($str).')="'.$str.'"'; break;
  default: die('Unknown db type '.$oDB->type);
  }
  if ( !empty($strIp) ) $strWhere .= ' AND ip="'.$strIp.'"';
  if ( $a=='Unhide' ) $strWhere .= ' AND visible="N"';  
  
  $oDB->Query( 'SELECT count(id) as countid FROM '.TABMESSAGE.' WHERE id>=0 AND '.$strWhere );
  $row = $oDB->Getrow();
  $countid = $row['countid'];

  // EXECUTE
  if ( $row['countid']>0 )
  {
    if ( $a=='Export' || $a=='Hide' || $a=='Unhide' || $a=='Delete' )
    {
      include('qtg_p_header.php');
      echo '<a id="exiturl" href="qtg_adm_medit_exe.php?y=',$intYear,'&amp;m=',$intMonth,'&amp;ip=',$strIp,'&amp;a=',$a,'&amp;n=',$row['countid'],'">Execute action ',$a,'...</a>';
      echo '
      <script type="text/javascript">
      <!--
      setTimeout(\'window.location=document.getElementById("exiturl").href\',0);
      -->
      </script>
      ';
      include('qtg_p_footer.php');
      exit;
    }

  }
  else
  {
    $strInfo = $L['E_no_selection'];
    if ( $a=='Unhide' ) $strInfo = '[0 hidden message]... '.$L['E_no_selection'];
  }
}

// --------
// HTML START
// --------

include('qtg_p_header.php');
include('qtg_adm_menu.php');

echo '
<!-- content -->
<h1>',$L['Multiple_edits'],'</h1>
';

// first year
$oDB->Query( 'SELECT MIN(issuedate) as firstdate FROM '.TABMESSAGE.' WHERE id>=0 AND issuedate<>"0"' );
$row = $oDB->Getrow();
$firstyear = intval(substr($row['firstdate'],0,4));

echo '
<form method="post" action="qtg_adm_medit.php">
<table class="tab_reply">
<tr class="tr_reply">
<td class="td_reply">
<p class="p_form">',$L['Messages_posted_in'],'&nbsp;
<select name="y">';
for ($iYear=$firstyear;$iYear<=date('Y');$iYear++)
{
echo '<option value="',$iYear,'"/>',$iYear,'</option>';
}
echo '</select>
<br/><br/>',$L['Month'],'&nbsp;<select name="m"><option value="0">',$L['All'],'</option>',QTastags($L['dateMMM']),'</select>
<br/><br/>',$L['From_IP'],'&nbsp;<input type="text" name="ip" size="16" maxlength="24"/>
<br/><span class="small">',$L['HFrom_IP'],'</span><br/></p>
<hr>
<p class="p_form">&nbsp;',$L['Action'],' <select name="a">
<option value="Hide">',$L['Hide'],'</option>
<option value="Unhide">',$L['Unhide'],'</option>
<option value="Delete">',$L['Delete'],'</option>
<option value="Export">',$L['Export'],'</option>
</select>&nbsp;
<input type="submit" name="ok" value="',$L['Next'],' &gt;"/>&nbsp;<br/>
</p>
</td>
</table>
</form>
';

// --------
// HTML END
// --------

include('qtg_p_footer.php');

?>