<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name = 'Map';

// CHECK LOGIN

if ( !isset($_SESSION['qtgAuth']) ) die('Access denied');
if ( $_SESSION['qtgAuth']!='yes' ) die('Access denied');

// INITIALISE

require_once('bin/qtg_init.php');
if ( substr($qtg_language,0,9)!='language/' ) $qtg_language = 'language/'.$qtg_language;

  // check values
  if ( !isset($qtg_gkey) ) $qtg_gkey='';
  if ( !isset($qtg_gcenter) ) $qtg_gcenter='50.8468142558,4.35238838196';
  if ( !isset($qtg_gzoom) ) $qtg_gzoom='5';
  if ( !isset($qtg_gbuttons) ) $qtg_gbuttons='P11100';
  if ( !isset($qtg_gfind) ) $qtg_gfind='Brussels, Belgium';
  if ( !isset($qtg_gsymbol) ) $qtg_gsymbol=false;

include($qtg_language.'/qtg_lang_adm.php');
if ( file_exists($qtg_language.'/qtg_lang_map.php') ) { include($qtg_language.'/qtg_lang_map.php'); } else { include('english/qtg_lang_map.php'); }
if ( file_exists($qtg_language.'/qtg_lang_map_adm.php') ) { include($qtg_language.'/qtg_lang_map_adm.php'); } else { include('english/qtg_lang_map_adm.php'); }

$qtg_skin = 'admin';   //override the skin in this page

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // CHECK values
  $qtg_gkey = trim($_POST['qtg_gkey']); if ( strlen($qtg_gkey)<8 ) $qtg_gkey='';
  if ( isset($_POST['qtg_gcenter']) ) { $qtg_gcenter = trim($_POST['qtg_gcenter']); } else { $qtg_gcenter = '50.8468142558,4.35238838196'; }
  if ( isset($_POST['qtg_gzoom']) ) { $qtg_gzoom = trim($_POST['qtg_gzoom']); } else { $qtg_gzoom = '5'; }
  if ( !isset($_POST['maptype']) ) $_POST['maptype']='P';
  if ( !isset($_POST['nav']) ) $_POST['nav']='1';
  if ( !isset($_POST['map']) ) $_POST['map']='1';
  if ( !isset($_POST['scale']) ) $_POST['scale']='1';
  if ( !isset($_POST['qtg_gsymbol']) ) $_POST['qtg_gsymbol']=false;
  $qtg_gbuttons = substr($_POST['maptype'],0,1).(isset($_POST['nav']) ? '1' : '0').(isset($_POST['map']) ? '1' : '0').(isset($_POST['scale']) ? '1' : '0').(isset($_POST['overview']) ? '1' : '0').(isset($_POST['mousewheel']) ? '1' : '0');
  if ( isset($_POST['qtg_gfind']) ) { $qtg_gfind = trim($_POST['qtg_gfind']); } else { $qtg_gfind='Brussels, Belgium'; }
  if ( empty($_POST['qtg_gsymbol']) ) { $qtg_gsymbol=false; } else { $qtg_gsymbol=$_POST['qtg_gsymbol']; }
    
  // SAVE values
  if ( empty($qtg_error) )
  {     
    $strContent = '<?php
    $qtg_gkey = "'.$qtg_gkey.'";
    $qtg_gcenter = "'.$qtg_gcenter.'";
    $qtg_gzoom = "'.$qtg_gzoom.'";
    $qtg_gbuttons = "'.$qtg_gbuttons.'";
    $qtg_gfind = "'.$qtg_gfind.'";
    $qtg_gsymbol = '.($qtg_gsymbol ? '"'.$qtg_gsymbol.'"' : 'false').';
    $qtg_gshadow = '.(file_exists('map/'.$qtg_gsymbol.'_shadow.png') ? 'true' : 'false').';
    $qtg_gprinticon = '.(file_exists('map/'.$qtg_gsymbol.'.gif') ? 'true' : 'false').';
    $qtg_gprintshadow = '.(file_exists('map/'.$qtg_gsymbol.'_shadow.gif') ? 'true' : 'false').';    
    ?>';
    
    if (!is_writable('bin/config_map.php')) $qtg_error='Impossible to write into the file [bin/config_map.php].';
    
    if ( empty($qtg_error) )
    {
       if (!$handle = fopen('bin/config_map.php', 'w')) $qtg_error='Impossible to open the file [bin/config_map.php].';
    }
    if ( empty($qtg_error) )
    {
       if (fwrite($handle, $strContent) === FALSE)
       {
         $qtg_error = 'Impossible to write into the file [bin/config_map.php].';
       }
       else
       {
         $strInfo = $L['Save_successfull'];
         fclose($handle);
       }
    }
  }
}

// --------
// HTML START
// --------

if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) { 
  include('qtg_map_lib.php');
  $strHeaderAddScript = QTgmapheader($qtg_gkey);
  $strBodyAddOnunload='GUnload()';
}}

include('qtg_p_header.php');
include('qtg_adm_menu.php');

echo '<h1>&nbsp;',$L['Map'],'</h1>';
if ( file_exists($qtg_language.'/qtg_map_adm.php.txt') )
{
  echo '<p class="td_adm_help">';
  include($qtg_language.'/qtg_map_adm.php.txt');
  echo '</p>';
}

echo '
<form method="post" action="qtg_adm_map.php">
<h2>&nbsp;',$L['map_adm']['Mapping_settings'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:150px;"><span class="texthead"><label for="qtg_gkey">Google API key</label></span></td>
<td class="td_adm"><input id="qtg_gkey" name="qtg_gkey" size="90" maxlength="100" value="',$qtg_gkey,'"></td>
</tr>
';

if ( !empty($qtg_gkey) )
{

  // Read png in directory

  $intHandle = opendir('map');
  $arrFiles = array();
  while ( false!==($strFile = readdir($intHandle)) )
  {
    if ( $strFile!='.' && $strFile!='..' ) {
    if ( substr($strFile,-4,4)=='.png' ) {
    if ( !strstr($strFile,'shadow') ) {
      $arrFiles[substr($strFile,0,-4)]=ucfirst(substr(str_replace('_',' ',$strFile),0,-4));
    }}}
  }
  closedir($intHandle);
  asort($arrFiles);

echo '<tr>
<th class="td_adm_top">',$L['map_adm']['API_ctrl'],'</th>
<td class="td_adm">
<input type="checkbox" id="nav" name="nav"'.(substr($qtg_gbuttons,1,1)=='1' ? QCHE : '').' style="vertical-align: middle"/><label for="nav">',$L['map_adm']['Ctrl_navigation'],'</label>
&nbsp;<input type="checkbox" id="map" name="map"'.(substr($qtg_gbuttons,2,1)=='1' ? QCHE : '').' style="vertical-align: middle"/><label for="map">',$L['map_adm']['Ctrl_background'],'</label>
&nbsp;<input type="checkbox" id="scale" name="scale"'.(substr($qtg_gbuttons,3,1)=='1' ? QCHE : '').' style="vertical-align: middle"/><label for="scale">',$L['map_adm']['Ctrl_scale'],'</label>
&nbsp;<input type="checkbox" id="overview" name="overview"'.(substr($qtg_gbuttons,4,1)=='1' ? QCHE : '').' style="vertical-align: middle"/><label for="overview">',$L['map_adm']['Ctrl_overview'],'</label>
&nbsp;<input type="checkbox" id="mousewheel" name="mousewheel"'.(substr($qtg_gbuttons,5,1)=='1' ? QCHE : '').' style="vertical-align: middle"/><label for="mousewheel">',$L['map_adm']['Ctrl_mousewheel'],'</label>
</td>
</tr>
<tr>
<th class="td_adm_top"><label for="qtg_gsymbol">',$L['map_adm']['Symbol'],'</label></th>
<td class="td_adm">
<select  id="qtg_gsymbol" name="qtg_gsymbol" size="1">
<option value="0">',$L['map_adm']['Default'],'</option>
<option value="" disabled="disabled">-----------</option>
',QTastags($arrFiles,null,$qtg_gsymbol),'
</select>
</td>
</tr>
</table>
';
echo '
<h2>&nbsp;',$L['map_adm']['Mapping_config'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<tr>
<th class="td_adm_top" style="width:150px;"><label for="qtg_gcenter">',$L['map_adm']['Center'],'</label></th>
<td class="td_adm" style="width:250px;"><input type="text" id="qtg_gcenter" name="qtg_gcenter" size="28" maxlength="100" value="',$qtg_gcenter,'"/><span class="small"> ',$L['map_adm']['Latlng'],'</span></td>
<td class="td_adm_help">',$L['map_adm']['H_Center'],'</td>
</tr>
';
echo '<tr>
<th class="td_adm_top"><label for="qtg_gzoom">',$L['map_adm']['Zoom'],'</label></th>
<td class="td_adm">
<input type="text" id="qtg_gzoom" name="qtg_gzoom" size="2" maxlength="2" value="',$qtg_gzoom,'"/></td>
<td class="td_adm_help">',$L['map_adm']['H_Zoom'],'</td>
</tr>
';
echo '<tr>
<th class="td_adm_top">',$L['map_adm']['Background'],'</th>
<td class="td_adm"><select id="maptype" name="maptype" size="1">',QTastags($L['map_adm']['Back'],null,substr($qtg_gbuttons,0,1)),'</select></td>
<td class="td_adm_help">',$L['map_adm']['H_Background'],'</td>
</tr>
';
echo '<tr>
<th class="td_adm_top"><label for="qtg_gfind">',$L['map_adm']['Address_sample'],'</label></th>
<td class="td_adm">
<input type="text" id="qtg_gfind" name="qtg_gfind" size="20" maxlength="100" value="',$qtg_gfind,'"/></td>
<td class="td_adm_help">',$L['map_adm']['H_Address_sample'],'</td>
</tr>
';

}

echo '</table>
<p style="text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></p>
</form>
';

if ( !empty($qtg_gkey) )
{
  echo '
  <table width="100%" class="tab_hidden" cellspacing="0">
  <tr style="vertical-align:top">
  <td class="td_hidden">

  <h2>',$L['map_adm']['Preview'],'</h2>
  <div class="td_adm" style="width:500px;">
  <p class="small" style="margin:2px 0 4px 2px;text-align:right">',$L['map']['canmove'],' | <a class="small" href="javascript:void(0)" onclick="undoChanges(); return false;"/>',$L['map']['undo'],'</a></p>
  <div id="map_canvas" style="width:100%; height:350px;"></div>
  <p class="small" style="margin:4px 0 2px 2px;text-align:right">',$L['map']['addrlatlng'],' <input type="text" size="24" id="find" name="find" class="small" value="',$qtg_gfind,'" onKeyUp="handle_keypress(event,\'findit\')" title="',$L['map']['H_addrlatlng'],'"/> <input type="submit" id="findit" class="small" onclick="showLocation(document.getElementById(\'find\').value); return false;" value="',$L['Search'],'"/></p>
  </div>

  </td>
  <td class="td_hidden">&nbsp;</td>
  <td class="td_hidden" style="width:150px">

  <h2>',$L['map_adm']['Other_symbols'],'</h2>
  <table width="100%" class="tab_hidden" cellspacing="0">
  ';
  foreach ($arrFiles as $strFile=>$strName)
  {
    echo '<tr><td class="td_adm" style="width:30px; text-align:center"><img src="map/',$strFile,'.png"/></td><td class="td_adm"><span class="small">',$strName,'</span></td></tr>';
  }
  echo '
  </table>

  </td>
  </tr>
  </table>
  ';
}
else
{
  echo '<p class="disabled">',$L['map_adm']['E_disabled'],'</p>';
}

// HTML END

if ( !empty($qtg_gkey) )
{
  // map loader
  $x = QTgetx($qtg_gcenter); //if ( empty($x) ) $x=0.0;
  $y = QTgety($qtg_gcenter); //if ( empty($y) ) $y=0.0;
  echo '
  <script type="text/javascript">
  <!--
  ',QTgmappoints($qtg_gbuttons,$qtg_gzoom,$L['map'],$y,$x,'drag',array(array('y'=>$y,'x'=>$x,'title'=>$L['map_adm']['Default_center'])),true),'
  mapload();
  -->
  </script>
  ';
}

include('qtg_p_footer.php');

?>