<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name = 'Configuration';

// CHECK LOGIN

if ( !isset($_SESSION['qtgAuth']) ) header('Location: qtg_login.php');
if ( $_SESSION['qtgAuth']!='yes' )  header('Location: qtg_login.php');

// INITIALISE

require_once('bin/qtg_init.php');

include($qtg_language.'/qtg_lang_adm.php');
$gui_skin = $qtg_skin; //conserve the skin setting
$qtg_skin = 'admin';   //override the skin in this page

$name = '';

$bMap=false;
if ( isset($qtg_gkey) ) { 
if ( !empty($qtg_gkey) ) {
  $bMap=true;
}}

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // Check values.
  if ( isset($_POST['Fld'][0]) ) { $qtg_use_age=true;      } else { $qtg_use_age=false;      }
  if ( isset($_POST['Fld'][1]) ) { $qtg_use_email=true;    } else { $qtg_use_email=false;    }
  if ( isset($_POST['Fld'][2]) ) { $qtg_use_from=true;     } else { $qtg_use_from=false;     }
  if ( isset($_POST['Bbc'][0]) ) { $qtg_bbc_bold=true;     } else { $qtg_bbc_bold=false;     }
  if ( isset($_POST['Bbc'][1]) ) { $qtg_bbc_italic=true;   } else { $qtg_bbc_italic=false;   } 
  if ( isset($_POST['Bbc'][2]) ) { $qtg_bbc_underline=true;} else { $qtg_bbc_underline=false;}
  if ( isset($_POST['Bbc'][3]) ) { $qtg_bbc_url=true;      } else { $qtg_bbc_url=false;      }
  if ( isset($_POST['Bbc'][4]) ) { $qtg_bbc_smiley=true;   } else { $qtg_bbc_smiley=false;   }  
  if (empty($_POST['skin']))       { $skin = 'default'; }  else { $skin = $_POST['skin']; }
  if (empty($_POST['formattime'])) { $qtg_formattime=''; } else { $qtg_formattime=stripslashes(trim($_POST['formattime'])); }
  if ( $_POST['coldefault']=='Y' ) { $qtg_column_default=true; } else { $qtg_column_default=false; }
  if ( $_POST['colchange']=='Y' ) { $qtg_column_change=true; } else { $qtg_column_change=false; }
  if ( $_POST['embeded']=='Y' ) { $qtg_embeded=true; } else { $qtg_embeded=false; }
  if ( $_POST['banner']=='Y' ) { $qtg_banner=true; } else { $qtg_banner=false; }
  if ( $_POST['wording']=='Y' ) { $qtg_checkword=true; } else { $qtg_checkword=false; }
  if ( $_POST['separateform']=='Y' ) { $qtg_separateform=true; } else { $qtg_separateform=false; }
  $qtg_use_from_type = intval($_POST['fromtype']);
  
  // mandatory when map is active
  if ( $bMap ) { $qtg_separateform=true; }

  // check sitename
  $str = trim($_POST['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTformattitle($str,255);
  if ( !empty($str) ) { $qtg_title = $str; } else { $qtg_error=$L['Site_name'].S.$L['E_invalid']; }
  
  // home url
  if ( empty($qtg_error) )
  {
    $str = trim($_POST['home']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = QTformattitle($str,100); if ( $str=='http://' || $str=='https://' ) $str='';
    if ( !empty($str) )
    {
    if ( !ereg('^(http://|https://)',$str) ) $qtg_error = $L['Home_page'].' '.$L['E_invalid'].' (http://)';
    }
    $qtg_home = $str;
  }
  
  // check admin email
  if ( empty($qtg_error) )
  {
    $str = trim($_POST['email']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    if ( QTismail($str) ) { $qtg_email = $str; } else { $qtg_error = $L['Home_email'].S.$L['E_invalid']; }
  }

  // check dateformat
  if ( empty($qtg_error) )
  {
    $str = trim($_POST['formatdate']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    if ( empty($str) ) { $qtg_error='Date format cannot be empty...'; $qtg_formatdate='j-M-Y'; }
    if ( empty($qtg_error) ) $qtg_formatdate = $str;
  }

  // check pagewidth
  if ( empty($qtg_error) )
  {
    $str = strip_tags(trim($_POST['width']));
    if ( substr($str,-1,1)=='%' ) { $percent = '%'; } else { $percent = ''; }
    $str = str_replace('%','',$str);
    if ( !is_numeric($str) )
    {
      $qtg_error = $L['Site_width'].S.$L['E_invalid'].' (500-1024, 50%-100%)';
    }
    else
    {
      if ( $percent=='%' )
      {
      if ( !QTisbetween($str,50,100) ) { $qtg_error = $L['Site_width'].S.$L['E_invalid'].' (500-1024 or 50%-100%)'; }
      }
      else
      {
      if ( !QTisbetween($str,500,1024) ) { $qtg_error = $L['Site_width'].S.$L['E_invalid'].' (500-1024, 50%-100%)'; }
      }
    }
    if ( empty($qtg_error) ) $qtg_pagewidth = $str.$percent;
  }

  // check welcome. html accepted
  if ( empty($qtg_error) )
  {
    $qtg_welcome = trim($_POST['welcome']); if ( get_magic_quotes_gpc() ) $qtg_welcome = stripslashes($qtg_welcome);
    $qtg_welcome = QThtmlquote($qtg_welcome);
  }

  // show_size
  if ( empty($qtg_error) )
  {
    $str = trim($_POST['show_size']);
    if ( !is_numeric($str) )
    {
      $qtg_error = $L['Show_max'].S.$L['E_invalid'].' (50-5000)';
    }
    else
    {
      if ( !QTisbetween($str,50,5000) ) $qtg_error = $L['Show_max'].S.$L['E_invalid'].' (50-5000)';
    }
    $qtg_show_size = intval($str);
  }

  // page_size
  if ( empty($qtg_error) )
  {
    $str = trim($_POST['page_size']);
    if ( !is_numeric($str) )
    {
      $qtg_error = $L['Post_per_page'].S.$L['E_invalid'].' (1-999)';
    }
    else
    {
      if ( !QTisbetween($str,1,999) ) $qtg_error = $L['Post_per_page'].S.$L['E_invalid'].' (1-999)';
    }
    $qtg_page_size = intval($str);
  }  
  
  $qtg_language = $_POST['language'];
  if ( !file_exists('language/'.$qtg_language.'/qtg_lang_main.php') )
  {
  $qtg_error = 'Problem to find the file language/'.$qtg_language.'/qtg_lang_main.php. Settings cannot be saved.';
  $qtg_language = 'english';
  }
  if ( !file_exists('language/'.$qtg_language.'/qtg_lang_adm.php') )
  {
  $qtg_error = 'Problem to find the file language/'.$qtg_language.'/qtg_lang_adm.php. Settings cannot be saved.';
  $qtg_language = 'english';
  }
  
  if ( empty($qtg_error) )
  { 
    // check string variables to remove quotes
    foreach (array('qtg_language','skin','qtg_formatdate','qtg_formattime','qtg_title','qtg_home','qtg_email','qtg_pagewidth','qtg_welcome') as $strVar)
    {
      if ( isset($$strVar) ) {
      if ( strstr($$strVar,"'") ) {
        $$strVar = str_replace("'",'&#039;',$$strVar);
      }}
    }
    
    $strContent = '<?php
    $qtg_language = "'.$qtg_language.'";
    $qtg_skin = "'.$skin.'";
    $qtg_formatdate = "'.$qtg_formatdate.'";
    $qtg_formattime = "'.$qtg_formattime.'";
    $qtg_embeded = '.($qtg_embeded ? 'true' : 'false').';
    $qtg_banner = '.($qtg_banner ? 'true' : 'false').';
    $qtg_title = "'.$qtg_title.'";
    $qtg_home = "'.$qtg_home.'";
    $qtg_email = "'.$qtg_email.'";
    $qtg_pagewidth = "'.$qtg_pagewidth.'";
    $qtg_welcome = "'.$qtg_welcome.'";
    $qtg_show_size = '.$qtg_show_size.';
    $qtg_page_size = '.$qtg_page_size.';
    $qtg_use_age = '.($qtg_use_age ? 'true' : 'false').';
    $qtg_use_email = '.($qtg_use_email ? 'true' : 'false').';
    $qtg_use_from = '.($qtg_use_from ? 'true' : 'false').';
    $qtg_use_from_type = '.$qtg_use_from_type.';
    $qtg_column_default = '.($qtg_column_default ? 'true' : 'false').';
    $qtg_column_change = '.($qtg_column_change ? 'true' : 'false').';
    $qtg_separateform = '.($qtg_separateform ? 'true' : 'false').';  
    $qtg_bbc_bold = '.($qtg_bbc_bold ? 'true' : 'false').';
    $qtg_bbc_italic = '.($qtg_bbc_italic ? 'true' : 'false').';
    $qtg_bbc_underline = '.($qtg_bbc_underline ? 'true' : 'false').';
    $qtg_bbc_url = '.($qtg_bbc_url ? 'true' : 'false').';
    $qtg_bbc_smiley = '.($qtg_bbc_smiley ? 'true' : 'false').';
    $qtg_checkword = '.($qtg_checkword ? 'true' : 'false').';
    ?>';
    
    if (!is_writable('bin/config_display.php')) $qtg_error='Impossible to write into the file [bin/config_display.php].';
    
    if ( empty($qtg_error) )
    {
       if (!$handle = fopen('bin/config_display.php', 'w')) $qtg_error='Impossible to open the file [bin/config_display.php].';
    }
    if ( empty($qtg_error) )
    {
       if (fwrite($handle, $strContent) === FALSE)
       {
         $qtg_error = 'Impossible to write into the file [bin/config_display.php].';
       }
       else
       {
         include('language/'.$qtg_language.'/qtg_lang_adm.php');
         $strInfo = $L['Save_successfull'];
         fclose($handle);
       }
    }
  }
}

// --------
// HTML START
// --------

include('qtg_p_header.php');
include('qtg_adm_menu.php');

if ( substr($qtg_language,0,9)!='language/' )
{
$qtg_language = 'language/'.$qtg_language;
}
include($qtg_language.'/qtg_lang_adm.php');

echo '
<h1>&nbsp;',$L[$pg_name],'</h1>
<form method="post" action="qtg_adm_conf.php">
';

echo '
<h2>&nbsp;',$L['Site_settings'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="title">',$L['Site_title'],'</label></span></td>
<td class="td_adm" style="width:220px;"><input id="title" name="title" size="30" maxlength="255" value="',$qtg_title,'"></td>
<td class="td_adm_help">',$L['HSite_title'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="home">',$L['Home_page'],'</label></span></td>
<td class="td_adm"><input id="home" name="home" size="30" maxlength="100" value="',(empty($qtg_home) ? 'http://' : $qtg_home),'"></td>
<td class="td_adm_help">',$L['HHome_page'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="email">',$L['Home_email'],'</label></span></td>
<td class="td_adm"><input id="email" name="email" size="30" maxlength="100" value="',$qtg_email,'"></td>
<td class="td_adm_help">',$L['HHome_email'],'</td>
</tr>
</table>
';

echo '
<h2>&nbsp;',$L['Regional_settings'],'</h2>
<table cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="dateformat">',$L['Date_format'],'</label></span></td>
<td class="td_adm" style="width:220px;">
<input id="formatdate" name="formatdate" size="10" maxlength="24" value="',$qtg_formatdate,'">&nbsp;
<input id="formattime" name="formattime" size="6" maxlength="24" value="',$qtg_formattime,'">
</td>
<td class="td_adm_help">',$L['HDate_format'],'</td>
</tr>
<tr>
';

// Read directory in language
$handle = opendir('language');
$arrFiles = array();
while (false !== ($strFile = readdir($handle)))
{
  if ( $strFile!='.' && $strFile!='..' ) $arrFiles[$strFile] = ucfirst($strFile);
}
closedir($handle);
asort($arrFiles);

echo '<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="language">',$L['Language'],'</label></span></td>
<td class="td_adm" style="width:220px;"><select id="language" name="language">',QTastags($arrFiles,null,substr($qtg_language,9)),'</select></td>
<td class="td_adm_help">',$L['HLanguage'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="wording">',$L['Check_wording'],'</label></span></td>
<td class="td_adm">
<select id="wording" name="wording">
<option value="Y" ',($qtg_checkword ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_checkword ? QSEL : ''),'>',$L['No'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HCheck_wording'],'</td>
</tr>
</table>
';

echo '
<h2>&nbsp;',$L['Skin'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="width">',$L['Site_width'],'</label></span></td>
<td class="td_adm" style="width:220px;"><input id="width" name="width" size="4" maxlength="4" value="',$qtg_pagewidth,'"></td>
<td class="td_adm_help">',$L['HSite_width'],'</td>
</tr>';

// Read directory in skin
$handle = opendir('skin');
$arrFiles = array();
while (false !== ($strFile = readdir($handle)))
{
  if ( $strFile!='.' && $strFile!='..' ) $arrFiles[$strFile] = ucfirst($strFile);
}
closedir($handle);
asort($arrFiles);

$sel = '';
foreach($arrFiles as $key => $val)
{
  $sel .= '<option value="'.$key.'"'.($gui_skin=='skin/'.$key ? QSEL : '').'>'.$val.'</option>';
}

echo '<tr>
<td class="td_adm_top"><span class="texthead"><label for="skin">',$L['Skin'],'</label></span></td>
<td class="td_adm"><select id="skin" name="skin">',$sel,'</select></td>
<td class="td_adm_help">',$L['HSkin'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead"><label for="welcome">',$L['Welcome'],'</label></span></td>
<td class="td_adm" colspan="2"><textarea name="welcome" id="welcome" cols="64" rows="3">',$qtg_welcome,'</textarea></td>
</tr>
</table>
';

echo '
<h2>&nbsp;',$L['Message_settings'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="show_size">',$L['Show_max'],'</label></span></td>
<td class="td_adm" style="width:220px;"><input id="show_size" name="show_size" size="5" maxlength="5" value="',$qtg_show_size,'">&nbsp;',$L['Characters'],'</td>
<td class="td_adm_help">',$L['HShow_max'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="page_size">',$L['Post_per_page'],'</label></span></td>
<td class="td_adm"><input id="page_size" name="page_size" size="2" maxlength="3" value="',$qtg_page_size,'"></td>
<td class="td_adm_help">',$L['HPost_per_page'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead">',$L['Optional_fields'],'</label></span></td>
<td class="td_adm">
<input type="checkbox" id="Fld[0]" name="Fld[0]" value="Age"'.($qtg_use_age ? QCHE : '').'/><label for="Fld[0]"> ',$L['Use_age'],'</label><br/>
<input type="checkbox" id="Fld[1]" name="Fld[1]" value="Email"'.($qtg_use_email ? QCHE : '').'/><label for="Fld[1]"> ',$L['Use_email'],'</label>&nbsp;<br/>
<input type="checkbox" id="Fld[2]" name="Fld[2]" value="From"'.($qtg_use_from ? QCHE : '').'/><label for="Fld[2]"> ',$L['Use_from'],'</label>&nbsp;
<select id="fromtype" name="fromtype">
<option value="0" ',($qtg_use_from_type==0 ? QSEL : ''),'>',$L['Use_from_0'],'</option>
<option value="1" ',($qtg_use_from_type==1 ? QSEL : ''),'>',$L['Use_from_1'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HOptional_fields'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead">',$L['BBC_code'],'</label></span></td>
<td class="td_adm">
<input type="checkbox" id="Bbc[0]" name="Bbc[0]" value="Bold"'.($qtg_bbc_bold ? QCHE : '').'/><label for="Bbc[0]"> ',$L['Ico_bold'],'</label><br/>
<input type="checkbox" id="Bbc[1]" name="Bbc[1]" value="Italic"'.($qtg_bbc_italic ? QCHE : '').'/><label for="Bbc[1]"> ',$L['Ico_italic'],'</label><br/>
<input type="checkbox" id="Bbc[2]" name="Bbc[2]" value="Underline"'.($qtg_bbc_underline ? QCHE : '').'/><label for="Bbc[2]"> ',$L['Ico_under'],'</label><br/>
<input type="checkbox" id="Bbc[3]" name="Bbc[3]" value="Url"'.($qtg_bbc_url ? QCHE : '').'/><label for="Bbc[3]"> ',$L['Ico_url'],'</label><br/>
<input type="checkbox" id="Bbc[4]" name="Bbc[4]" value="Smiley"'.($qtg_bbc_smiley ? QCHE : '').'/><label for="Bbc[4]"> ',$L['Ico_smiley'],'</label>
</td>
<td class="td_adm_help">',$L['HBBC_code'],'</td>
</tr>
</table>
';
echo '
<h2>&nbsp;',$L['Display_options'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="coldefault">',$L['Column_default'],'</label></span></td>
<td class="td_adm" style="width:220px;">
<select id="coldefault" name="coldefault">
<option value="Y" '.($qtg_column_default ? QSEL : '').'>',$L['Yes'],'</option>
<option value="N" '.(!$qtg_column_default ? QSEL : '').'>',$L['No'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HColumn_default'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="colchange">',$L['Column_change'],'</label></span></td>
<td class="td_adm">
<select id="colchange" name="colchange">
<option value="Y" '.($qtg_column_change ? QSEL : '').'>',$L['Yes'],'</option>
<option value="N" '.(!$qtg_column_change ? QSEL : '').'>',$L['No'],'</option>
</select>
<td class="td_adm_help">',$L['HColumn_change'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="banner">',$L['Banner'],'</label></span></td>
<td class="td_adm">
<select id="banner" name="banner">
<option value="Y" '.($qtg_banner ? QSEL : '').'>',$L['Yes'],'</option>
<option value="N" '.(!$qtg_banner ? QSEL : '').'>',$L['No'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HBanner'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="separateform">',$L['Separate_form'],'</label></span></td>
';
if ( $bMap ) 
{
echo '<td class="td_adm">
<select id="separateform" name="separateform" disabled="disabled"><option value="Y">',$L['Yes'],'</option></select>
</td>';
}
else
{
echo '<td class="td_adm">
<select id="separateform" name="separateform">
<option value="Y" ',($qtg_separateform ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_separateform ? QSEL : ''),'>',$L['No'],'</option>
</select>
</td>';
}
echo '
<td class="td_adm_help">',$L['HSeparate_form'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="embeded">',$L['Embeded'],'</label></span></td>
<td class="td_adm">
<select id="embeded" name="embeded">
<option value="Y" ',($qtg_embeded ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_embeded ? QSEL : ''),'>',$L['No'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HEmbeded'],'</td>
</tr>
</table>

<p style="text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></p>
</form>
';

// --------
// HTML END
// --------

include('qtg_p_footer.php');

?>