<?php

/*
 * QuickTalk Guestbook
 *
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Guestbook
 * @package    QuickTalk Guestbook
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2009 The PHP Group
 * @license    http://www.php.net/license/  PHP License 3.0
 * @version    1.7 build:20080601
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
$pg_name='Security';

// CHECK LOGIN

if ( !isset($_SESSION['qtgAuth']) ) header("Location: qtg_login.php");
if ( $_SESSION['qtgAuth']!='yes' )  header("Location: qtg_login.php");

require_once('bin/qtg_init.php');
include($qtg_language.'/qtg_lang_adm.php');
$qtg_skin = 'admin';

// PROCESS

if ( isset($_POST['ok']) )
{
  // check guestbook status
  if ( $_POST['status']=='Y' ) { $qtg_actif=true; } else { $qtg_actif=false; }

  // check stop message. html accepted
  if ( empty($qtg_error) )
  {
    $qtg_stop_message = trim($_POST['stop']); if ( get_magic_quotes_gpc() ) $qtg_stop_message = stripslashes($qtg_stop_message);
    $qtg_stop_message = QThtmlquote($qtg_stop_message);
    if ( empty($qtg_stop_message) ) $qtg_stop_message = 'Guestbook temporary closed.';
  }

  // check notiy
  if ( empty($qtg_error) )
  {
    $qtg_notify = trim($_POST['notify']); if ( get_magic_quotes_gpc() ) $qtg_notify = stripslashes($qtg_notify);
    if ( !empty($qtg_notify) )
    {
       if ( !QTismail($qtg_notify) ) $qtg_error="E-mail {$L['E_invalid']}";
    }
  }  

  // check antispam method
  $qtg_antispam = $_POST['antispam'];
  
  // check msg max size
  $str = trim($_POST['max_size']);
  if ( !is_numeric($str) ) $qtg_error="{$L['Msg_max_size']} {$L['E_invalid']} (500-50000)";
  if ( empty($qtg_error) ) { if ( !QTisbetween($str,500,5000) ) $qtg_error="{$L['Msg_max_size']} {$L['E_invalid']} (500-50000)"; }
  if ( empty($qtg_error) ) $qtg_max_size = intval($str);

  // check qtg_flood time
  $str = trim($_POST['max_sec']);
  if ( !is_numeric($str) ) $qtg_error="{$L['Flood_max_sec']} {$L['E_invalid']} (1-100)";
  if ( empty($qtg_error) ) { if ( !QTisbetween($str,1,100) ) $qtg_error="{$L['Flood_max_sec']} {$L['E_invalid']} (1-100)"; }
  if ( empty($qtg_error) ) $qtg_max_sec = intval($str);
  
  // check day
  $str = trim($_POST['maxday']);
  if ( !is_numeric($str) ) $qtg_error="{$L['Flood_max_day']} {$L['E_invalid']} (1-100)";
  if ( empty($qtg_error) ) { if ( !QTisbetween($str,1,100) ) $qtg_error="{$L['Flood_max_day']} {$L['E_invalid']} (1-100)"; }
  if ( empty($qtg_error) ) $qtg_maxday = intval($str);
  
  // check ip
  if ( $_POST['checkip']=='Y' ) { $qtg_checkip=true; } else { $qtg_checkip=false;}
  $qtg_checkip_list = '';  if ( isset($_POST['iplist']) ) $qtg_checkip_list = trim($_POST['iplist']);
  $qtg_checkip_list = str_replace(array("\r\n","\n",",",";"),' ',$qtg_checkip_list);
  
  // check each ip
  if ( !empty($qtg_checkip_list) )
  {
    $arrIp = explode(' ',$qtg_checkip_list);
    foreach($arrIp as $strIp)
    {
      if ( !ereg("^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\..+$",$strIp) ) $qtg_error='IP '.$L['E_invalid'];
    }
  }
  // check javamail
  if ( $_POST['javamail']=='Y' ) { $qtg_javamail=true; } else { $qtg_javamail=false; }

  // check meaning
  if ( $_POST['meaning']=='Y' ) { $qtg_meaning=true; } else { $qtg_meaning=false; }

  // save result
  if ( empty($qtg_error) )
  { 
    // check string variables to remove quotes
    foreach (array('qtg_stop_message','qtg_notify','qtg_checkip_list') as $strVar)
    {
      if ( isset($$strVar) ) {
      if ( strstr($$strVar,"'") ) {
        $$strVar = str_replace("'",'&#039;',$$strVar);
      }}
    }
    $content = '<?php
    $qtg_actif = '.($qtg_actif ? 'true' : 'false').';
    $qtg_stop_message = "'.$qtg_stop_message.'";
    $qtg_notify = "'.$qtg_notify.'";
    $qtg_max_size = '.$qtg_max_size.';
    $qtg_max_sec = '.$qtg_max_sec.';
    $qtg_max_day = '.$qtg_maxday.';
    $qtg_antispam = '.$qtg_antispam.';
    $qtg_checkip = '.($qtg_checkip ? 'true' : 'false').';
    $qtg_checkip_list = "'.$qtg_checkip_list.'";
    $qtg_javamail = '.($qtg_javamail ? 'true' : 'false').';
    $qtg_meaning = '.($qtg_meaning ? 'true' : 'false').';
    ?>';
    
    if ( !is_writable('bin/config_stop.php') ) $qtg_error='Impossible to write into the file [bin/config_stop.php].';
    
    if ( empty($qtg_error) )
    {
       if (!$handle = fopen('bin/config_stop.php', 'w')) $qtg_error='Impossible to open the file [bin/config_stop.php].';
    }
    if ( empty($qtg_error) )
    {
       if ( fwrite($handle,$content)===FALSE )
       {
        $qtg_error = 'Impossible to write into the file [bin/config_stop.php].';
       }
       else
       {
         $strInfo = $L['Save_successfull'];
         fclose($handle);
       }
    }
  }
}

// --------
// HTML START
// --------

include('qtg_p_header.php');
include('qtg_adm_menu.php');

if ( $qtg_actif )
{
$ico = '<img src="admin/qtg_adm_actif.gif" border="0" alt="actif" title="actif"/>';
}
else
{
$ico = '<img src="admin/qtg_adm_closed.gif" border="0" alt="closed" title="closed"/>';
}

echo '<h1>',$L['Security'],'</h1>

<h2>',$L['Activity_status'],'</h2>
<form method="post" action="qtg_adm.php">
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="status">',$L['Guestbook_status'],'</label></span></th>
<td class="td_adm" style="width:300px;">&nbsp;',$ico,'&nbsp;&nbsp;<select id="status" name="status">
<option value="Y" ',($qtg_actif ? QSEL : ''),'>',$L['Actif'],'</option>
<option value="N" ',(!$qtg_actif ? QSEL : ''),'>',$L['Closed'],'</option>
</select></td>
<td class="td_adm_help">&nbsp;</td>
</tr>
';
echo '<tr valign="top">
<td class="td_adm_top"><span class="texthead"><label for="stop">',$L['Stop_message'],'</label></span></th>
<td class="td_adm"><textarea name="stop" id="stop" cols="45" rows="3">',$qtg_stop_message,'</textarea></td>
<td class="td_adm_help">',$L['HStop_message'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead"><label for="notify">',$L['Activity_notify'],'</label></span></th>
<td class="td_adm"><input type="text" name="notify" id="notify" size="47" maxlength="255" value="',$qtg_notify,'"/></td>
<td class="td_adm_help">',$L['HActivity_notify'],'</td>
</tr>
</table>
';
echo '<h2>',$L['Security_settings'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="max_size">',$L['Msg_max_size'],'</label></span></th>
<td class="td_adm" style="width:200px;"><input id="max_size" name="max_size" size="6" maxlength="6" value="',$qtg_max_size,'">&nbsp;',$L['Characters'],'</td>
<td class="td_adm_help">',$L['HMsg_max_size'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="max_sec">',$L['Flood_max_sec'],'</label></span></th>
<td class="td_adm"><input id="max_sec" name="max_sec" size="3" maxlength="3" value="',$qtg_max_sec,'">&nbsp;',$L['Sec'],'</td>
<td class="td_adm_help">',$L['HFlood_max_sec'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="maxday">',$L['Flood_max_day'],'</label></span></th>
<td class="td_adm"><input id="maxday" name="maxday" size="3" maxlength="3" value="',$qtg_max_day,'">/&nbsp;',$L['User'],'</td>
<td class="td_adm_help">',$L['HFlood_max_day'],'</td>
</tr>
<tr>
<td class="td_adm_top"><span class="texthead"><label for="antispam">',$L['Check_human'],'</label></span></th>
<td class="td_adm">
<select id="antispam" name="antispam">
<option value="0" ',($qtg_antispam==0 ? QSEL : '').'>',$L['No'],'</option>
<option value="1" ',($qtg_antispam==1 ? QSEL : '').'>',$L['Text'],'</option>
<option value="2" ',($qtg_antispam==2 ? QSEL : '').'>',$L['Image'],'</option>
</select>
<td class="td_adm_help">',$L['HCheck_human'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead"><label for="javamail">',$L['Javamail'],'</label></span></th>
<td class="td_adm">
<select id="javamail" name="javamail">
<option value="Y" ',($qtg_javamail ? QSEL : '').'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_javamail ? QSEL : '').'>',$L['No'],'</option>
</select>
<td class="td_adm_help">',$L['HJavamail'],'</td>
</tr>
</table>
';
if ( !isset($qtg_meaning) ) $qtg_meaning=false;
echo '<h2>',$L['Input_control'],'</h2>
<table width="100%" border="0" cellspacing="0" class="tab_adm">
<tr>
<td class="td_adm_top" style="width:180px;"><span class="texthead"><label for="meaning">',$L['Check_meaning'],'</label></span></td>
<td class="td_adm" style="width:200px;">
<select id="meaning" name="meaning">
<option value="Y" ',($qtg_meaning ? QSEL : ''),'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_meaning ? QSEL : ''),'>',$L['No'],'</option>
</select>
</td>
<td class="td_adm_help">',$L['HCheck_meaning'],'</td>
</tr>
<tr valign="top">
<td class="td_adm_top"><span class="texthead"><label for="checkip">',$L['Check_ip'],'</label></span></th>
<td class="td_adm">
<select id="checkip" name="checkip">
<option value="Y" ',($qtg_checkip ? QSEL : '').'>',$L['Yes'],'</option>
<option value="N" ',(!$qtg_checkip ? QSEL : '').'>',$L['No'],'</option>
</select><br/><textarea class="small" name="iplist" id="iplist" cols="25" rows="3">',$qtg_checkip_list.'</textarea>
<td class="td_adm_help">',$L['HCheck_ip'],'</td>
</tr>
</table>
';
echo '<p style="text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></p>
</form>
';

// --------
// HTML END
// --------

include('qtg_p_footer.php');

?>