<?php

// QuickTalk 1.7 build:20080601

switch($oDB->type)
{

case 'mysql':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id int NOT NULL,
  name varchar(50),
  message text NOT NULL,
  userage int NULL,
  useremail varchar(50) NULL,
  postfrom varchar(50) NULL,
  visible char(1) NOT NULL DEFAULT "Y",
  x decimal(13,10) NOT NULL DEFAULT 0,
  y decimal(13,10) NOT NULL DEFAULT 0,
  z decimal(13,2) NOT NULL DEFAULT 0,
  ip varchar(24) NULL,
  issuedate varchar(14) NOT NULL DEFAULT "0",
  PRIMARY KEY (id))';
  break;
  
case 'mssql':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id int NOT NULL CONSTRAINT pk_'.$qtg_prefix.'qtgmessage PRIMARY KEY,
  name varchar(50),
  message text,
  userage int NULL default NULL,
  useremail varchar(50) NULL,
  postfrom varchar(50) NULL DEFAULT NULL,
  visible char(1) NOT NULL DEFAULT "Y",
  x decimal(13,10) NOT NULL DEFAULT 0,
  y decimal(13,10) NOT NULL DEFAULT 0,
  z decimal(13,2) NOT NULL DEFAULT 0,
  ip varchar(24) NULL DEFAULT NULL,
  issuedate varchar(14) NOT NULL DEFAULT "0"
  )';
  break;
  
case 'pg':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id integer,
  name varchar(50),
  message text NOT NULL,
  userage integer NULL,
  useremail varchar(50) NULL,
  postfrom varchar(50) NULL,
  visible char(1) NOT NULL DEFAULT "Y",
  x decimal(13,10) NOT NULL DEFAULT 0,
  y decimal(13,10) NOT NULL DEFAULT 0,
  z decimal(13,2) NOT NULL DEFAULT 0,
  ip varchar(24) NULL,
  issuedate varchar(14) NOT NULL DEFAULT "0",
  PRIMARY KEY (id))';
  break;

case 'sqlite':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id integer,
  name text,
  message text,
  userage integer,
  useremail text,
  postfrom text,
  visible text DEFAULT "Y",
  x real DEFAULT 0,
  y real DEFAULT 0,
  z real DEFAULT 0,
  ip text,
  issuedate text DEFAULT "0",
  PRIMARY KEY (id))';
  break;
  
case 'ibase': // attention message must be replaced by textmsg
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id integer,
  name varchar(50) default NULL,
  textmsg varchar(32700) default NULL,
  userage integer default NULL,
  useremail varchar(50) default NULL,
  postfrom varchar(50) default NULL,
  visible char(1) default "Y",
  x decimal(13,10) default 0,
  y decimal(13,10) default 0,
  z decimal(13,2) default 0,
  ip varchar(24) default NULL,
  issuedate varchar(14) default "0",
  PRIMARY KEY (id))';
  break;
  
case 'access':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id int NOT NULL CONSTRAINT pk_'.$qtg_prefix.'qtgmessage PRIMARY KEY,
  name varchar(50),
  message text,
  userage int,
  useremail varchar(50),
  postfrom varchar(50),
  visible char(1),
  x float,
  y float,
  z float,
  ip varchar(24),
  issuedate varchar(14)
  )';
  break;

case 'db2':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id integer NOT NULL,
  name varchar(50),
  message text,
  userage integer,
  useremail varchar(50),
  postfrom varchar(50),
  visible char(1) NOT NULL DEFAULT "Y",
  x numeric(13,10) NOT NULL DEFAULT 0,
  y numeric(13,10) NOT NULL DEFAULT 0,
  z numeric(13,2) NOT NULL DEFAULT 0,
  ip varchar(24) NULL,
  issuedate varchar(14) NOT NULL DEFAULT "0",
  PRIMARY KEY (id))';
  break;

case 'ifx':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id integer,
  name varchar(50),
  message text,
  userage integer,
  useremail varchar(50),
  postfrom varchar(50),
  visible char(1) default "Y" NOT NULL,
  x numeric(13,10) default 0 NOT NULL,
  y numeric(13,10) default 0 NOT NULL,
  z numeric(13,2) default 0 NOT NULL,
  ip varchar(24),
  issuedate varchar(14) default "0" NOT NULL,
  PRIMARY KEY (id))';
  break;

case 'oci':
  $strQ = 'CREATE TABLE '.$qtg_prefix.'qtgmessage 
  (id number(32),
  name varchar2(50),
  message clob,
  userage number(3),
  useremail varchar2(50),
  postfrom varchar2(50),
  visible char(1) default "Y" NOT NULL,
  x number(13,10) default 0 NOT NULL,
  y number(13,10) default 0 NOT NULL,
  z number(13,2) default 0 NOT NULL,
  ip varchar2(24),
  issuedate varchar(14) default "0" NOT NULL,
  CONSTRAINT id_pk PRIMARY KEY (id))';
  break;
  
default:
  die('Database type ['.$this->type.'] not supported... Must be mysql, mssql, pg, db2, ifx or access');

}

echo '<div style="margin-left:20px; color:blue;">';
$b = $oDB->Query($strQ);
echo '</div>';

if ( !empty($oDB->error) || !$b )
{
  // add version
  $oDB->Query( 'INSERT INTO '.$qtg_prefix.'qtgmessage (id,name,visible) VALUES(-1,"1.7","N")');

  echo '<div class="div_setup_err">',sprintf ($L['E_install'],$qtg_prefix.'qtgmessage',$qtg_database,$qtg_user),'</div>';
  echo '<br/><table cellspacing="0" class="tab_button"><tr><td></td><td class="td_button" style="width:120px">&nbsp;<a href="qtg_setup_1.php">',$L['Restart'],'</a>&nbsp;</td></tr></table>';
  exit;
}

?>