<?php

// QuickTalk 1.7 build:20080601

session_start();

if ( isset($_SESSION['qtg_setup_lang']) ) { $strLang = $_SESSION['qtg_setup_lang']; } else { $strLang = 'en'; }
include('qtg_lang_'.$strLang.'.php');
include('../bin/config.php');
include('../bin/config_display.php');
include('../bin/qt_lib_db.php');
if ( isset($_SESSION['qtg_dbopwd']) )
{
  $qtg_user = $_SESSION['qtg_dbologin'];
  $qtg_pwd = $_SESSION['qtg_dbopwd'];
}  
$oDB = new cDB($qtg_dbsystem,$qtg_host,$qtg_database,$qtg_user,$qtg_pwd,$qtg_port,$qtg_dsn);

$strAppl = 'QuickTalk guestbook 1.7';
$strPrevUrl = 'qtg_setup_2.php';
$strNextUrl = '../qtg_index.php';
$strPrevLabel= $L['Back'];
$strNextLabel= $L['Finish'];

if ( isset($_SESSION['qtg_boardmail']) ) $qtg_email = $_SESSION['qtg_boardmail'];

// search version
$strVersion='1.6';
$oDB->Query( 'SELECT name FROM '.$qtg_prefix.'qtgmessage WHERE id=-1');
$row = $oDB->Getrow();
if ( isset($row['name']) )
{
  if ( $row['name']=='1.7' ) $strVersion='1.7';
}
else
{
  if ( $oDB->type=='ibase')
  {
  $oDB->Query( 'INSERT INTO '.$qtg_prefix.'qtgmessage (id,name,textmsg,visible) VALUES(-1,"1.7","Version","N")');
  }
  else
  {
  $oDB->Query( 'INSERT INTO '.$qtg_prefix.'qtgmessage (id,name,message,visible) VALUES(-1,"1.7","Version","N")');
  }
}

// UPDATE

if ( $strVersion!='1.7' ) 
{
  $strVersion = '1.7';  
  $oDB->Query( 'UPDATE '.$qtg_prefix.'qtgmessage SET name="1.7" WHERE id=-1');
  switch ($oDB->type)
  {
  case 'mysql':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) NOT NULL DEFAULT "0"');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY z decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=DATE_FORMAT(postdate,"%Y%m%d%H%i%s")');
    break;
  case 'mssql':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) NOT NULL DEFAULT "0"');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN z decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=replace(convert(varchar,postdate,102),".","") + replace(convert(varchar,postdate,108),":","")');
    break;
  case 'pg':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) NOT NULL DEFAULT "0"');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN x TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN y TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN z TYPE decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=TO_CHAR(postdate,"YYYYMMDDHH24MISS")');
    break;
  case 'access':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=str( DATEPART("yyyy",postdate)*10000+DATEPART("m",postdate)*100+DATEPART("d",postdate) )');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=issuedate & RIGHT("0" & str(DATEPART("h",postdate)*10000+DATEPART("n",postdate)*100+DATEPART("s",postdate)),6)');
    break;
  case 'sqlite':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate text DEFAULT "0"');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=postdate');
    break;
  case 'ibase':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) DEFAULT "0"');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN x TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN y TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN z TYPE decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=CAST( EXTRACT(YEAR FROM postdate)*1000000000000+EXTRACT(MONTH FROM postdate)*100000000+EXTRACT(DAY FROM postdate)*1000000+EXTRACT(HOUR FROM postdate)*10000+EXTRACT(MINUTE FROM postdate)*100+EXTRACT(SECOND FROM postdate) AS VARCHAR(14) )');
    break;
  case 'db2':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) NOT NULL DEFAULT "0"');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN x SET DATA TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN y SET DATA TYPE decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ALTER COLUMN z SET DATA TYPE decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=CAST( YEAR(postdate)*1000000000000+MONTH(postdate)*100000000+DAY(postdate)*1000000+HOUR(postdate)*10000+MINUTE(postdate)*100+SECOND(postdate) AS VARCHAR(14) )');
    break;
  case 'ifx':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14) default "0" NOT NULL');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY (x decimal(13,10))');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY (y decimal(13,10))');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY (z decimal(13,2))');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=(postdate YEAR TO YEAR)*10000000000+(postdate MONTH TO MONTH)*100000000+(postdate DAY TO DAY)*1000000+HOUR(postdate)*10000+(postdate MINUTE TO MINUTE)*100+(postdate SECOND TO SECOND)');
    break;
  case 'oci':
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage ADD issuedate varchar(14)  default "0" NOT NULL');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY x decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY y decimal(13,10)');
    $oDB->Query('ALTER TABLE '.$qtg_prefix.'qtgmessage MODIFY z decimal(13,2)');
    $oDB->Query('UPDATE '.$qtg_prefix.'qtgmessage SET issuedate=TO_CHAR(postdate,"YYYYMMDDHH24MISS")');
    break;
  }
}

// --------
// HTML START
// --------

include('qtg_setup_hd.php');

// config_display
$strFile = "../bin/config_display.php";
$strContent  = '<?php
$qtg_language = "'.$qtg_language.'";
$qtg_skin = "'.$qtg_skin.'";
$qtg_formatdate = "'.$qtg_formatdate.'";
$qtg_formattime = "'.$qtg_formattime.'";
$qtg_embeded = '.($qtg_embeded ? 'true' : 'false').';
$qtg_banner = '.($qtg_banner ? 'true' : 'false').';
$qtg_title = "'.$qtg_title.'";
$qtg_home = "'.$qtg_home.'";
$qtg_email = "'.$qtg_email.'";
$qtg_pagewidth = "'.$qtg_pagewidth.'";
$qtg_welcome = "'.$qtg_welcome.'";
$qtg_show_size = '.$qtg_show_size.';
$qtg_page_size = '.$qtg_page_size.';
$qtg_use_age = '.($qtg_use_age ? 'true' : 'false').';
$qtg_use_email = '.($qtg_use_email ? 'true' : 'false').';
$qtg_use_from = '.($qtg_use_from ? 'true' : 'false').';
$qtg_use_from_type = '.$qtg_use_from_type.';
$qtg_column_default = '.($qtg_column_default ? 'true' : 'false').';
$qtg_column_change = '.($qtg_column_change ? 'true' : 'false').';
$qtg_separateform = '.($qtg_separateform ? 'true' : 'false').';
$qtg_bbc_bold = '.($qtg_bbc_bold ? 'true' : 'false').';
$qtg_bbc_italic = '.($qtg_bbc_italic ? 'true' : 'false').';
$qtg_bbc_underline = '.($qtg_bbc_underline ? 'true' : 'false').';
$qtg_bbc_url = '.($qtg_bbc_url ? 'true' : 'false').';
$qtg_bbc_smiley = '.($qtg_bbc_smiley ? 'true' : 'false').';
$qtg_checkword = '.($qtg_checkword ? 'true' : 'false').';
 ?>';

if (!is_writable($strFile)) $qtg_error="Impossible to write into the file [$strFile].";

if ( empty($qtg_error) )
{
   if (!$handle = fopen($strFile, 'w')) $qtg_error="Impossible to open the file [$strFile].";
}
if ( empty($qtg_error) )
{
   if (fwrite($handle, $strContent) === FALSE)
   {
    $qtg_error = "Impossible to write into the file [$strFile].";
   }
   else
   {
    fclose($handle);
   }
}

if ( empty($qtg_error) )
{

  if ( isset($_SESSION['qtgInstalled']) )
  {
    echo $L['S_install_exit'];
    echo '<div style="width:350px; padding:10px; border-style:solid; border-color:#FF0000; border-width:1px; background-color:#EEEEEE">',$L['End_message'],'<br/>',$L['User'],': <b>Admin</b><br/>',$L['Password'],': <b>Admin</b><br/></div><br/>';
  }
  else
  {
    echo $L['N_install'];
  }

  echo '<br/><br/><a href="../check_install.php">',$L['Check_install'],'</a><br/><br/>';

}
else
{
  echo '<br/><p class="error">',$qtg_error,'</p>';
}

// --------
// HTML END
// --------

include('qtg_setup_ft.php');


?>
